/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.saaj;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.llom.OMTextImpl;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.saaj.util.IDGenerator;
import org.apache.axis2.saaj.util.SAAJUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SOAPConnectionImpl
extends SOAPConnection {
    private boolean closed = false;
    private ServiceClient serviceClient;
    private static final Log log = LogFactory.getLog((Class)SOAPConnectionImpl.class);

    public SOAPMessage call(SOAPMessage request, Object endpoint) throws SOAPException {
        OperationClient opClient;
        URL url;
        if (this.closed) {
            throw new SOAPException("SOAPConnection closed");
        }
        try {
            url = endpoint instanceof URL ? (URL)endpoint : new URL(endpoint.toString());
        }
        catch (MalformedURLException e) {
            throw new SOAPException(e);
        }
        Options options = new Options();
        options.setTo(new EndpointReference(url.toString()));
        try {
            this.serviceClient = new ServiceClient();
            opClient = this.serviceClient.createClient(ServiceClient.ANON_OUT_IN_OP);
        }
        catch (AxisFault e) {
            throw new SOAPException(e);
        }
        opClient.setOptions(options);
        if (request.countAttachments() != 0) {
            opClient.getOptions().setProperty("enableMTOM", (Object)"true");
            return this.handleSOAPMessage(request, opClient);
        }
        return this.handleSOAPMessage(request, opClient);
    }

    public void close() throws SOAPException {
        if (this.serviceClient != null) {
            try {
                this.serviceClient.cleanup();
            }
            catch (AxisFault axisFault) {
                throw new SOAPException(axisFault.getMessage());
            }
        }
        if (this.closed) {
            throw new SOAPException("SOAPConnection Closed");
        }
        this.closed = true;
    }

    private SOAPMessage handleSOAPMessage(SOAPMessage request, OperationClient opClient) throws SOAPException {
        MessageContext requestMsgCtx = new MessageContext();
        try {
            requestMsgCtx.setEnvelope(this.toOMSOAPEnvelope(request));
            opClient.addMessageContext(requestMsgCtx);
            opClient.execute(true);
            MessageContext msgCtx = opClient.getMessageContext("In");
            return this.getSOAPMessage(msgCtx.getEnvelope());
        }
        catch (AxisFault e) {
            throw new SOAPException(e);
        }
    }

    private SOAPMessage getSOAPMessage(org.apache.axiom.soap.SOAPEnvelope respOMSoapEnv) throws SOAPException {
        System.err.println("####### respOMSoapEnv=" + respOMSoapEnv);
        MessageFactory mf = MessageFactory.newInstance();
        SOAPMessage response = mf.createMessage();
        SOAPPart sPart = response.getSOAPPart();
        SOAPEnvelope env = sPart.getEnvelope();
        SOAPBody body = env.getBody();
        SOAPHeader header = env.getHeader();
        Iterator hbIter = respOMSoapEnv.getHeader().examineAllHeaderBlocks();
        while (hbIter.hasNext()) {
            SOAPHeaderBlock hb = (SOAPHeaderBlock)hbIter.next();
            QName hbQName = hb.getQName();
            SOAPHeaderElement headerEle = header.addHeaderElement(env.createName(hbQName.getLocalPart(), hbQName.getPrefix(), hbQName.getNamespaceURI()));
            Iterator attribIter = hb.getAllAttributes();
            while (attribIter.hasNext()) {
                OMAttribute attr = (OMAttribute)attribIter.next();
                QName attrQName = attr.getQName();
                headerEle.addAttribute(env.createName(attrQName.getLocalPart(), attrQName.getPrefix(), attrQName.getNamespaceURI()), attr.getAttributeValue());
            }
            String role = hb.getRole();
            if (role != null) {
                headerEle.setActor(role);
            }
            headerEle.setMustUnderstand(hb.getMustUnderstand());
            this.toSAAJElement(headerEle, (OMNode)hb, response);
        }
        this.toSAAJElement(body, (OMNode)respOMSoapEnv.getBody(), response);
        return response;
    }

    private void toSAAJElement(SOAPElement saajEle, OMNode omNode, SOAPMessage saajSOAPMsg) throws SOAPException {
        if (omNode instanceof OMText) {
            return;
        }
        if (omNode instanceof OMElement) {
            OMElement omEle = (OMElement)omNode;
            Iterator childIter = omEle.getChildren();
            while (childIter.hasNext()) {
                OMNode omChildNode = (OMNode)childIter.next();
                SOAPElement saajChildEle = null;
                if (omChildNode instanceof OMText) {
                    OMText omText = (OMText)omChildNode;
                    if (omText.isOptimized()) {
                        DataHandler datahandler = (DataHandler)omText.getDataHandler();
                        AttachmentPart attachment = saajSOAPMsg.createAttachmentPart(datahandler);
                        String id = IDGenerator.generateID();
                        attachment.setContentId(id);
                        attachment.setContentType(datahandler.getContentType());
                        saajSOAPMsg.addAttachmentPart(attachment);
                        saajEle.addAttribute(saajSOAPMsg.getSOAPPart().getEnvelope().createName("href"), "cid:" + id);
                    } else {
                        saajChildEle = saajEle.addTextNode(omText.getText());
                    }
                } else if (omChildNode instanceof OMElement) {
                    OMElement omChildEle = (OMElement)omChildNode;
                    QName omChildQName = omChildEle.getQName();
                    saajChildEle = saajEle.addChildElement(omChildQName.getLocalPart(), omChildQName.getPrefix(), omChildQName.getNamespaceURI());
                    Iterator attribIter = omChildEle.getAllAttributes();
                    while (attribIter.hasNext()) {
                        OMAttribute attr = (OMAttribute)attribIter.next();
                        QName attrQName = attr.getQName();
                        saajChildEle.addAttribute(saajSOAPMsg.getSOAPPart().getEnvelope().createName(attrQName.getLocalPart(), attrQName.getPrefix(), attrQName.getNamespaceURI()), attr.getAttributeValue());
                    }
                }
                this.toSAAJElement(saajChildEle, omChildNode, saajSOAPMsg);
            }
        }
    }

    protected org.apache.axiom.soap.SOAPEnvelope toOMSOAPEnvelope(SOAPMessage saajSOAPMsg) throws SOAPException {
        org.apache.axiom.soap.SOAPEnvelope omSOAPEnv = SAAJUtil.toOMSOAPEnvelope(saajSOAPMsg.getSOAPPart().getDocumentElement());
        System.err.println("#### req OM Soap Env=" + omSOAPEnv);
        HashMap<String, AttachmentPart> attachmentMap = new HashMap<String, AttachmentPart>();
        Iterator attachments = saajSOAPMsg.getAttachments();
        while (attachments.hasNext()) {
            AttachmentPart attachment = (AttachmentPart)attachments.next();
            if (attachment.getContentId() == null || attachment.getContentId().trim().length() == 0) {
                attachment.setContentId(IDGenerator.generateID());
            }
            if (attachment.getDataHandler() == null) {
                throw new SOAPException("Attachment with NULL DataHandler");
            }
            attachmentMap.put(attachment.getContentId(), attachment);
        }
        this.insertAttachmentNodes(attachmentMap, (OMElement)omSOAPEnv);
        return omSOAPEnv;
    }

    private void insertAttachmentNodes(Map attachments, OMElement omEnvelope) throws SOAPException {
        Iterator childIter = omEnvelope.getChildElements();
        while (childIter.hasNext()) {
            OMElement child = (OMElement)childIter.next();
            OMAttribute hrefAttr = child.getAttribute(new QName("href"));
            String contentID = this.getContentID(hrefAttr);
            if (contentID != null) {
                child.build();
                AttachmentPart ap = (AttachmentPart)attachments.get(contentID.trim());
                OMTextImpl text = new OMTextImpl((Object)ap.getDataHandler(), true, omEnvelope.getOMFactory());
                child.removeAttribute(hrefAttr);
                child.addChild((OMNode)text);
                continue;
            }
            this.insertAttachmentNodes(attachments, child);
        }
    }

    private String getContentID(OMAttribute attr) {
        if (attr == null) {
            return null;
        }
        String contentId = attr.getAttributeValue();
        if (contentId.startsWith("cid:")) {
            contentId = contentId.substring(4);
            return contentId;
        }
        return null;
    }
}

