/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.util.OnDemandLogger;

public class ListenerManager {
    private static final OnDemandLogger log = new OnDemandLogger(ListenerManager.class);
    protected ListenerManagerShutdownThread shutdownHookThread = null;
    private ConfigurationContext configctx;
    private HashMap<String, TransportListener> startedTransports = new HashMap();
    private boolean stopped = true;
    private boolean shutdownHookRequired = true;

    public void init(ConfigurationContext configCtx) {
        if (this.configctx != null) {
            log.warn("ConfigurationContext provided for the ListenerManager initialization is null. ListenerManager will not be initialized");
            return;
        }
        configCtx.setTransportManager(this);
        this.configctx = configCtx;
        for (TransportInDescription transportIn : this.configctx.getAxisConfiguration().getTransportsIn().values()) {
            try {
                TransportListener listener = transportIn.getReceiver();
                if (listener == null || this.startedTransports.get(transportIn.getName()) != null) continue;
                listener.init(this.configctx, transportIn);
            }
            catch (Exception e) {
                log.error("Couldn't initialize the " + transportIn.getName() + "transport listener", e);
            }
        }
    }

    public ConfigurationContext getConfigctx() {
        return this.configctx;
    }

    public synchronized EndpointReference getEPRforService(String serviceName, String opName, String transportName) throws AxisFault {
        if (transportName == null || "".equals(transportName)) {
            AxisService service = this.configctx.getAxisConfiguration().getService(serviceName);
            if (service == null) {
                throw new AxisFault(Messages.getMessage("servicenotfoundinthesystem", serviceName));
            }
            if (service.isEnableAllTransports()) {
                for (TransportListener transportListener : this.startedTransports.values()) {
                    EndpointReference[] epRsForService = transportListener.getEPRsForService(serviceName, null);
                    if (epRsForService == null) continue;
                    return epRsForService[0];
                }
                return null;
            }
            List<String> exposeTransport = service.getExposedTransports();
            TransportListener listener = this.startedTransports.get(exposeTransport.get(0));
            EndpointReference[] eprsForService = listener.getEPRsForService(serviceName, null);
            return eprsForService != null ? eprsForService[0] : null;
        }
        TransportInDescription trsIN = this.configctx.getAxisConfiguration().getTransportIn(transportName);
        TransportListener listener = trsIN.getReceiver();
        EndpointReference[] eprsForService = listener.getEPRsForService(serviceName, null);
        return eprsForService != null ? eprsForService[0] : null;
    }

    public synchronized void start() {
        if (!this.stopped) {
            log.error("Couldn't start ListenerManager, it seems to be already started!");
            return;
        }
        if (this.configctx == null) {
            log.error("Can't start uninitialized ListenerManager!");
            return;
        }
        for (TransportInDescription o : this.configctx.getAxisConfiguration().getTransportsIn().values()) {
            try {
                TransportInDescription transportIn = o;
                TransportListener listener = transportIn.getReceiver();
                if (listener == null || this.startedTransports.get(transportIn.getName()) != null) continue;
                listener.start();
                this.startedTransports.put(transportIn.getName(), listener);
            }
            catch (Exception e) {
                log.info(e.getMessage(), e);
            }
        }
        if (this.shutdownHookThread == null && this.isShutdownHookRequired()) {
            this.shutdownHookThread = new ListenerManagerShutdownThread(this);
            Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
        }
        this.stopped = false;
    }

    public synchronized void startSystem(ConfigurationContext configurationContext) {
        this.init(configurationContext);
        this.start();
    }

    public synchronized void stop() throws AxisFault {
        HashMap<String, TransportOutDescription> outTransports;
        if (this.stopped) {
            return;
        }
        if (this.shutdownHookThread != null && this.shutdownHookThread.getState() != Thread.State.RUNNABLE) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHookThread);
            this.shutdownHookThread = null;
        }
        Iterator<TransportListener> iterator = this.startedTransports.values().iterator();
        while (iterator.hasNext()) {
            TransportListener o;
            TransportListener transportListener = o = iterator.next();
            transportListener.stop();
        }
        if (log.isDebugEnabled()) {
            log.debug("Start invoke transport sender shutdown.");
        }
        if ((outTransports = this.configctx.getAxisConfiguration().getTransportsOut()).size() > 0) {
            for (TransportOutDescription outDescription : outTransports.values()) {
                TransportSender sender = outDescription.getSender();
                if (sender == null) continue;
                sender.stop();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("End Invoke transport sender shutdown.");
        }
        if (log.isDebugEnabled()) {
            log.debug("Start Invoke modules and services shutdown.");
        }
        this.configctx.shutdownModulesAndServices();
        if (log.isDebugEnabled()) {
            log.debug("End Invoke modules and services shutdown.");
        }
        this.stopped = true;
    }

    public synchronized void addListener(TransportInDescription trsIn, boolean started) throws AxisFault {
        this.configctx.getAxisConfiguration().addTransportIn(trsIn);
        TransportListener transportListener = trsIn.getReceiver();
        if (transportListener != null) {
            if (!started) {
                transportListener.init(this.configctx, trsIn);
                transportListener.start();
                if (this.shutdownHookThread == null && this.isShutdownHookRequired()) {
                    this.shutdownHookThread = new ListenerManagerShutdownThread(this);
                    Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
                }
                this.stopped = false;
            }
            this.startedTransports.put(trsIn.getName(), transportListener);
        }
    }

    public synchronized boolean isListenerRunning(String transportName) {
        return this.startedTransports.get(transportName) != null;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void destroy() throws AxisFault {
        this.stop();
        this.configctx.setTransportManager(null);
        Iterator<TransportInDescription> iterator = this.configctx.getAxisConfiguration().getAxisConfiguration().getTransportsIn().values().iterator();
        while (iterator.hasNext()) {
            TransportInDescription o;
            TransportInDescription transportInDescription = o = iterator.next();
            TransportListener transportListener = transportInDescription.getReceiver();
            transportListener.destroy();
        }
        this.startedTransports.clear();
        this.configctx = null;
    }

    public boolean isShutdownHookRequired() {
        return this.shutdownHookRequired;
    }

    public void setShutdownHookRequired(boolean shutdownHookRequired) {
        this.shutdownHookRequired = shutdownHookRequired;
    }

    static class ListenerManagerShutdownThread
    extends Thread {
        ListenerManager listenerManager;

        public ListenerManagerShutdownThread(ListenerManager listenerManager) {
            this.listenerManager = listenerManager;
        }

        public void run() {
            try {
                if (!this.listenerManager.stopped) {
                    this.listenerManager.stop();
                }
            }
            catch (AxisFault axisFault) {
                log.error(axisFault.getMessage(), axisFault);
            }
        }
    }
}

