/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context.externalize;

import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectStreamConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DebugObjectOutputStream
implements ObjectStreamConstants,
ObjectOutput {
    private static final Log log = LogFactory.getLog(DebugObjectOutputStream.class);
    private static final boolean isDebug = log.isDebugEnabled();
    ObjectOutput out;

    DebugObjectOutputStream(ObjectOutput out) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"--START DebugOutputStream--");
        }
        this.out = out;
    }

    public void close() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"--CLOSE DebugOutputStream--");
        }
        this.out.close();
    }

    public void flush() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"start flush()");
        }
        this.out.flush();
        if (log.isDebugEnabled()) {
            log.debug((Object)"end flush()");
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("start write(b, off, len) off=" + off + " len=" + len));
        }
        if (len > 4 && log.isDebugEnabled()) {
            log.debug((Object)(" first four bytes = '" + b[off] + "' '" + b[off + 1] + "' '" + b[off + 2] + "' '" + b[off + 3] + "'"));
        }
        this.out.write(b, off, len);
        if (log.isDebugEnabled()) {
            log.debug((Object)"end write(b, off, len)");
        }
    }

    public void write(byte[] b) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"start write byte[]");
        }
        this.out.write(b);
        if (log.isDebugEnabled()) {
            log.debug((Object)"end write(b)");
        }
    }

    public void write(int b) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("start write(int) int=" + b));
        }
        this.out.write(b);
        if (log.isDebugEnabled()) {
            log.debug((Object)"end write(int)");
        }
    }

    public void writeBoolean(boolean v) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("start writeBoolean(v) v=" + v));
        }
        this.out.writeBoolean(v);
        if (log.isDebugEnabled()) {
            log.debug((Object)"end writeBoolean(v)");
        }
    }

    public void writeByte(int v) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("start writeByte(v) v=" + v));
        }
        this.out.writeByte(v);
        if (log.isDebugEnabled()) {
            log.debug((Object)"end writeByte(v)");
        }
    }

    public void writeBytes(String s) throws IOException {
        log.debug((Object)("start writeBytes(s) s=" + s));
        this.out.writeBytes(s);
        log.debug((Object)"end writeBytes(s)");
    }

    public void writeChar(int v) throws IOException {
        log.debug((Object)("start writeChar(v) v=" + v));
        this.out.writeChar(v);
        log.debug((Object)"end writeChar(v)");
    }

    public void writeChars(String s) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("start writeChars(s) s=" + s));
        }
        this.out.writeChars(s);
        if (log.isDebugEnabled()) {
            log.debug((Object)"end writeChars(s)");
        }
    }

    public void writeDouble(double v) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("start writeDouble(v) v=" + v));
        }
        this.out.writeDouble(v);
        if (log.isDebugEnabled()) {
            log.debug((Object)"end writeDouble(v)");
        }
    }

    public void writeFloat(float v) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("start writeFloat(v) v=" + v));
        }
        this.out.writeFloat(v);
        if (log.isDebugEnabled()) {
            log.debug((Object)"end writeFloat(v)");
        }
    }

    public void writeInt(int v) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("start writeInt(v) v=" + v));
        }
        this.out.writeInt(v);
        if (log.isDebugEnabled()) {
            log.debug((Object)"end writeInt(v)");
        }
    }

    public void writeLong(long v) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("start writeLong(v) v=" + v));
        }
        this.out.writeLong(v);
        if (log.isDebugEnabled()) {
            log.debug((Object)"end writeLong(v)");
        }
    }

    public void writeObject(Object obj) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("start writeObject(v) v=" + this.valueName(obj)));
        }
        this.out.writeObject(obj);
        if (log.isDebugEnabled()) {
            log.debug((Object)"end writeObject(v)");
        }
    }

    public void writeShort(int v) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("start writeShort(v) v=" + v));
        }
        this.out.writeShort(v);
        if (log.isDebugEnabled()) {
            log.debug((Object)"end writeShort(v)");
        }
    }

    public void writeUTF(String str) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("start writeUTF(v) v=" + str));
        }
        this.out.writeUTF(str);
        if (log.isDebugEnabled()) {
            log.debug((Object)"end writeUTF(v)");
        }
    }

    private String valueName(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return "Object of class = " + obj.getClass().getName();
    }
}

