/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.mail;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.activation.CommandMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MailcapCommandMap;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.OutOnlyAxisOperation;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.transport.mail.MailToInfo;
import org.apache.axis2.transport.mail.MimeBase64BodyPart;
import org.apache.axis2.transport.mail.SynchronousMailListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EMailSender {
    private Properties properties;
    private MessageContext messageContext;
    private PasswordAuthentication passwordAuthentication;
    private OutputStream outputStream;
    private String inReplyTo;
    private EndpointReference from;
    private OMOutputFormat format;
    protected static Log log = LogFactory.getLog((Class)EMailSender.class);

    public void setMessageContext(MessageContext messageContext) {
        this.messageContext = messageContext;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void setPasswordAuthentication(PasswordAuthentication passwordAuthentication) {
        this.passwordAuthentication = passwordAuthentication;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send() throws AxisFault {
        try {
            MailToInfo mailToInfo;
            MimeMessage msg;
            block12: {
                block13: {
                    Session session = Session.getInstance((Properties)this.properties, (Authenticator)new Authenticator(){

                        protected PasswordAuthentication getPasswordAuthentication() {
                            return EMailSender.this.passwordAuthentication;
                        }
                    });
                    msg = new MimeMessage(session);
                    EndpointReference epr = null;
                    if (this.messageContext.getTo() != null && !this.messageContext.getTo().hasAnonymousAddress()) {
                        epr = this.messageContext.getTo();
                    }
                    if (epr == null) break block13;
                    if (!epr.hasNoneAddress()) {
                        mailToInfo = new MailToInfo(epr);
                        msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(mailToInfo.getEmailAddress()));
                        break block12;
                    } else if (this.from != null) {
                        mailToInfo = new MailToInfo(this.from);
                        msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(mailToInfo.getEmailAddress()));
                        break block12;
                    } else {
                        String error = EMailSender.class.getName() + "Couldn't countinue due to" + " FROM addressing is NULL";
                        log.error((Object)error);
                        throw new AxisFault(error);
                    }
                }
                if (this.from != null) {
                    mailToInfo = new MailToInfo(this.from);
                    msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(mailToInfo.getEmailAddress()));
                } else {
                    String error = EMailSender.class.getName() + "Couldn't countinue due to" + " FROM addressing is NULL and EPR is NULL";
                    log.error((Object)error);
                    throw new AxisFault(error);
                }
            }
            msg.setSubject("__ Axis2/Java Mail Message __");
            if (mailToInfo.isxServicePath()) {
                msg.setHeader("X-Service-Path", "\"" + mailToInfo.getContentDescription() + "\"");
            }
            if (this.inReplyTo != null) {
                msg.setHeader("In-Reply-To", this.inReplyTo);
            }
            this.createMailMimeMessage(msg, mailToInfo, this.format);
            Transport.send((Message)msg);
            log.info((Object)("Message being send. [Action = ]" + this.messageContext.getOptions().getAction()));
            this.sendReceive(this.messageContext, msg.getMessageID());
            return;
        }
        catch (AddressException e) {
            throw new AxisFault(e.getMessage(), e);
        }
        catch (MessagingException e) {
            throw new AxisFault(e.getMessage(), e);
        }
    }

    private void createMailMimeMessage(MimeMessage msg, MailToInfo mailToInfo, OMOutputFormat format) throws MessagingException {
        String contentType;
        MimeBase64BodyPart messageBodyPart = new MimeBase64BodyPart();
        messageBodyPart.setText("");
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)messageBodyPart);
        ByteArrayDataSource source = null;
        if (this.outputStream instanceof ByteArrayOutputStream) {
            source = new ByteArrayDataSource(((ByteArrayOutputStream)this.outputStream).toByteArray());
        }
        messageBodyPart = new MimeBase64BodyPart();
        messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
        messageBodyPart.setDisposition("attachment");
        messageBodyPart.addHeader("Content-Description", "\"" + mailToInfo.getContentDescription() + "\"");
        String string = contentType = format.getContentType() != null ? format.getContentType() : "text/xml";
        if (contentType.indexOf("text/xml") > -1 && this.messageContext.getSoapAction() != null) {
            messageBodyPart.setHeader("mail.soapaction", this.messageContext.getSoapAction());
        }
        if (contentType.indexOf("application/soap+xml") > -1) {
            if (this.messageContext.getSoapAction() != null) {
                messageBodyPart.setHeader("Content-Type", contentType + "; charset=" + format.getCharSetEncoding() + " ; action=\"" + this.messageContext.getSoapAction() + "\"");
            }
        } else {
            messageBodyPart.setHeader("Content-Type", contentType + "; charset=" + format.getCharSetEncoding());
        }
        multipart.addBodyPart((BodyPart)messageBodyPart);
        msg.setContent((Multipart)multipart);
    }

    public void setInReplyTo(String inReplyTo) {
        this.inReplyTo = inReplyTo;
    }

    public void setFrom(EndpointReference from) {
        this.from = from;
    }

    public void setFormat(OMOutputFormat format) {
        this.format = format;
    }

    private void sendReceive(MessageContext msgContext, String msgId) throws AxisFault {
        this.storeMessageContext(msgContext, msgId);
        ConfigurationContext cc = msgContext.getConfigurationContext();
        Options options = msgContext.getOptions();
        long outInMilliSeconds = options.getTimeOutInMilliSeconds();
        SynchronousMailListener synchronousMailListener = null;
        AxisOperation axisOperation = msgContext.getAxisOperation();
        if (axisOperation instanceof OutOnlyAxisOperation) {
            return;
        }
        if (!options.isUseSeparateListener() && !msgContext.isServerSide()) {
            Hashtable callBackTable;
            if (!cc.getListenerManager().isListenerRunning("mailto")) {
                TransportInDescription mailTo = cc.getAxisConfiguration().getTransportIn("mailto");
                if (mailTo == null) {
                    throw new AxisFault("Could not found transport for mailto");
                }
                cc.getListenerManager().addListener(mailTo, false);
            }
            if ((callBackTable = (Hashtable)cc.getProperty("callbackTable")) != null) {
                synchronousMailListener = new SynchronousMailListener(this.messageContext, outInMilliSeconds);
                callBackTable.put(msgId, synchronousMailListener);
            }
            while (!synchronousMailListener.isComplete()) {
                try {
                    Thread.sleep(6000L);
                }
                catch (InterruptedException e) {
                    throw new AxisFault(e.getMessage(), e);
                }
            }
            callBackTable.remove(msgId);
        }
    }

    private void storeMessageContext(MessageContext msgContext, String msgId) {
        Hashtable<String, String> mappingTable = (Hashtable<String, String>)msgContext.getConfigurationContext().getProperty("mappingTable");
        if (mappingTable == null) {
            mappingTable = new Hashtable<String, String>();
            msgContext.setProperty("mappingTable", mappingTable);
        }
        if (msgContext.getMessageID() != null) {
            mappingTable.put(msgId, msgContext.getMessageID());
        }
    }

    static {
        MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mc.addMailcap("application/soap+xml;;x-java-content-handler=com.sun.mail.handlers.text_xml");
        CommandMap.setDefaultCommandMap((CommandMap)mc);
    }
}

