/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.async.AsyncResult;
import org.apache.axis2.client.async.AxisCallback;
import org.apache.axis2.client.async.Callback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.ClientUtils;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.util.CallbackReceiver;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class OutInAxisOperationClient
extends OperationClient {
    private static Log log = LogFactory.getLog((Class)OutInAxisOperationClient.class);

    OutInAxisOperationClient(OutInAxisOperation axisOp, ServiceContext sc, Options options) {
        super(axisOp, sc, options);
    }

    public void addMessageContext(MessageContext msgContext) throws AxisFault {
        msgContext.setServiceContext(this.sc);
        if (msgContext.getMessageID() == null) {
            this.setMessageID(msgContext);
        }
        this.axisOp.registerOperationContext(msgContext, this.oc);
    }

    public MessageContext getMessageContext(String messageLabel) throws AxisFault {
        return this.oc.getMessageContext(messageLabel);
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    public void executeImpl(boolean block) throws AxisFault {
        EndpointReference replyTo;
        Boolean useAsyncOption;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entry: OutInAxisOperationClient::execute, " + block));
        }
        if (this.completed) {
            throw new AxisFault(Messages.getMessage("mepiscomplted"));
        }
        ConfigurationContext cc = this.sc.getConfigurationContext();
        MessageContext mc = this.oc.getMessageContext("Out");
        if (mc == null) {
            throw new AxisFault(Messages.getMessage("outmsgctxnull"));
        }
        this.prepareMessageContext(cc, mc);
        if (this.options.getTransportIn() == null && mc.getTransportIn() == null) {
            mc.setTransportIn(ClientUtils.inferInTransport(cc.getAxisConfiguration(), this.options, mc));
        } else if (mc.getTransportIn() == null) {
            mc.setTransportIn(this.options.getTransportIn());
        }
        boolean useAsync = false;
        if (!this.options.isUseSeparateListener() && (useAsyncOption = (Boolean)mc.getProperty("UseAsyncOperations")) != null) {
            useAsync = useAsyncOption;
        }
        if ((replyTo = mc.getReplyTo()) != null && replyTo.hasNoneAddress()) {
            throw new AxisFault(replyTo.getAddress() + "" + " can not be used with OutInAxisOperationClient , user either " + "fireAndForget or sendRobust)");
        }
        if (replyTo != null && !replyTo.hasAnonymousAddress()) {
            useAsync = true;
        }
        if (useAsync || this.options.isUseSeparateListener()) {
            this.sendAsync(useAsync, mc);
        } else if (block) {
            this.send(mc);
            this.completed = true;
        } else {
            this.sc.getConfigurationContext().getThreadPool().execute(new NonBlockingInvocationWorker(this.callback, mc, this.axisCallback));
        }
    }

    private void sendAsync(boolean useAsync, MessageContext mc) throws AxisFault {
        CallbackReceiver callbackReceiver;
        if (log.isDebugEnabled()) {
            log.debug((Object)("useAsync=" + useAsync + ", seperateListener=" + this.options.isUseSeparateListener()));
        }
        if (this.axisOp.getMessageReceiver() != null && this.axisOp.getMessageReceiver() instanceof CallbackReceiver) {
            callbackReceiver = (CallbackReceiver)this.axisOp.getMessageReceiver();
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating new callback receiver");
            }
            callbackReceiver = new CallbackReceiver();
            this.axisOp.setMessageReceiver(callbackReceiver);
        }
        SyncCallBack internalCallback = null;
        if (this.callback != null) {
            callbackReceiver.addCallback(mc.getMessageID(), this.callback);
        } else if (this.axisCallback != null) {
            callbackReceiver.addCallback(mc.getMessageID(), this.axisCallback);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating internal callback");
            }
            internalCallback = new SyncCallBack();
            callbackReceiver.addCallback(mc.getMessageID(), internalCallback);
        }
        Boolean useCustomListener = (Boolean)this.options.getProperty("UseCustomListener");
        if (useAsync) {
            useCustomListener = Boolean.TRUE;
        }
        if (!(useCustomListener != null && useCustomListener.booleanValue() || mc.getReplyTo() != null)) {
            EndpointReference replyToFromTransport = mc.getConfigurationContext().getListenerManager().getEPRforService(this.sc.getAxisService().getName(), this.axisOp.getName().getLocalPart(), mc.getTransportIn().getName());
            if (mc.getReplyTo() == null) {
                mc.setReplyTo(replyToFromTransport);
            } else {
                mc.getReplyTo().setAddress(replyToFromTransport.getAddress());
            }
        }
        mc.setProperty("transportNonBlocking", Boolean.TRUE);
        mc.getConfigurationContext().registerOperationContext(mc.getMessageID(), this.oc);
        AxisEngine.send(mc);
        if (internalCallback != null) {
            internalCallback.waitForCompletion(this.options.getTimeOutInMilliSeconds());
            if (internalCallback.envelope == null) {
                if (internalCallback.error == null) {
                    log.error((Object)"Callback had neither error nor response");
                }
                if (this.options.isExceptionToBeThrownOnSOAPFault()) {
                    throw AxisFault.makeFault(internalCallback.error);
                }
            }
        }
    }

    protected void handleResponse(MessageContext responseMessageContext) throws AxisFault {
        SOAPEnvelope resenvelope;
        responseMessageContext.setSoapAction(null);
        if (responseMessageContext.getEnvelope() == null) {
            resenvelope = TransportUtils.createSOAPMessage(responseMessageContext);
            if (resenvelope != null) {
                responseMessageContext.setEnvelope(resenvelope);
            } else {
                throw new AxisFault(Messages.getMessage("blockingInvocationExpectsResponse"));
            }
        }
        if ((resenvelope = responseMessageContext.getEnvelope()) != null) {
            AxisEngine.receive(responseMessageContext);
            if (responseMessageContext.getReplyTo() != null) {
                this.sc.setTargetEPR(responseMessageContext.getReplyTo());
            }
            if ((resenvelope.getBody().hasFault() || responseMessageContext.isProcessingFault()) && this.options.isExceptionToBeThrownOnSOAPFault()) {
                throw Utils.getInboundFaultFromMessageContext(responseMessageContext);
            }
        }
    }

    protected MessageContext send(MessageContext msgContext) throws AxisFault {
        MessageContext responseMessageContext = msgContext.getConfigurationContext().createMessageContext();
        responseMessageContext.setServerSide(false);
        responseMessageContext.setOperationContext(msgContext.getOperationContext());
        responseMessageContext.setOptions(new Options(this.options));
        responseMessageContext.setMessageID(msgContext.getMessageID());
        this.addMessageContext(responseMessageContext);
        responseMessageContext.setServiceContext(msgContext.getServiceContext());
        responseMessageContext.setAxisMessage(this.axisOp.getMessage("In"));
        AxisEngine.send(msgContext);
        responseMessageContext.setDoingREST(msgContext.isDoingREST());
        responseMessageContext.setProperty("TRANSPORT_HEADERS", msgContext.getProperty("TRANSPORT_HEADERS"));
        responseMessageContext.setProperty(HTTPConstants.MC_HTTP_STATUS_CODE, msgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE));
        responseMessageContext.setProperty("TRANSPORT_IN", msgContext.getProperty("TRANSPORT_IN"));
        responseMessageContext.setTransportIn(msgContext.getTransportIn());
        responseMessageContext.setTransportOut(msgContext.getTransportOut());
        this.handleResponse(responseMessageContext);
        return responseMessageContext;
    }

    private class SyncCallBack
    implements AxisCallback {
        boolean complete;
        boolean receivedFault;
        private SOAPEnvelope envelope;
        private Exception error;

        private SyncCallBack() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitForCompletion(long timeout) throws AxisFault {
            SyncCallBack syncCallBack = this;
            synchronized (syncCallBack) {
                try {
                    if (this.complete) {
                        return !this.receivedFault;
                    }
                    this.wait(timeout);
                    if (!this.complete) {
                        throw new AxisFault(Messages.getMessage("responseTimeOut"));
                    }
                }
                catch (InterruptedException e) {
                    this.error = e;
                }
            }
            if (this.error != null) {
                throw AxisFault.makeFault(this.error);
            }
            return !this.receivedFault;
        }

        public void onMessage(MessageContext msgContext) {
            this.envelope = msgContext.getEnvelope();
            this.envelope.buildWithAttachments();
        }

        public void onFault(MessageContext msgContext) {
            this.error = Utils.getInboundFaultFromMessageContext(msgContext);
        }

        public synchronized void onComplete() {
            this.complete = true;
            this.notify();
        }

        public void onError(Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entry: OutInAxisOperationClient$SyncCallBack::onError, " + e));
            }
            this.error = e;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: OutInAxisOperationClient$SyncCallBack::onError");
            }
        }
    }

    private class NonBlockingInvocationWorker
    implements Runnable {
        private Callback callback;
        private MessageContext msgctx;
        private AxisCallback axisCallback;

        public NonBlockingInvocationWorker(Callback callback, MessageContext msgctx, AxisCallback axisCallback) {
            this.callback = callback;
            this.msgctx = msgctx;
            this.axisCallback = axisCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                MessageContext response = OutInAxisOperationClient.this.send(this.msgctx);
                if (response != null) {
                    SOAPEnvelope resenvelope = response.getEnvelope();
                    SOAPBody body = resenvelope.getBody();
                    if (body.hasFault()) {
                        AxisFault fault = new AxisFault(body.getFault(), response);
                        if (this.callback != null) {
                            this.callback.onError(fault);
                        } else {
                            this.axisCallback.onError(fault);
                        }
                    } else if (this.callback != null) {
                        AsyncResult asyncResult = new AsyncResult(response);
                        this.callback.onComplete(asyncResult);
                    } else {
                        this.axisCallback.onMessage(response);
                    }
                }
            }
            catch (Exception e) {
                if (this.callback != null) {
                    this.callback.onError(e);
                } else {
                    this.axisCallback.onError(e);
                }
            }
            finally {
                if (this.callback != null) {
                    this.callback.setComplete(true);
                }
            }
        }
    }
}

