/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.DependencyManager;
import org.apache.axis2.util.ObjectStateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SessionContext
extends AbstractContext
implements Externalizable {
    private static final long serialVersionUID = -1100610673067568556L;
    private static final int REVISION_1 = 1;
    private static final int revisionID = 1;
    private transient HashMap serviceContextMap = new HashMap();
    private transient HashMap serviceGroupContextMap = new HashMap();
    private String cookieID;
    private static final Log log = LogFactory.getLog((Class)SessionContext.class);
    private static final String myClassName = "SessionContext";
    public long sessionContextTimeoutInterval = 30000L;

    public SessionContext(AbstractContext parent) {
        super(parent);
    }

    public SessionContext() {
    }

    public void init(AxisConfiguration axisConfiguration) throws AxisFault {
    }

    public ServiceContext getServiceContext(AxisService axisService) {
        return (ServiceContext)this.serviceContextMap.get(axisService.getName());
    }

    public void addServiceContext(ServiceContext serviceContext) {
        this.serviceContextMap.put(serviceContext.getAxisService().getName(), serviceContext);
    }

    public void addServiceGroupContext(ServiceGroupContext serviceGroupContext) {
        String serviceGroupID = serviceGroupContext.getDescription().getServiceGroupName();
        this.serviceGroupContextMap.put(serviceGroupID, serviceGroupContext);
    }

    public ServiceGroupContext getServiceGroupContext(String serviceGroupID) {
        return (ServiceGroupContext)this.serviceGroupContextMap.get(serviceGroupID);
    }

    public String getCookieID() {
        return this.cookieID;
    }

    public void setCookieID(String cookieID) {
        this.cookieID = cookieID;
    }

    public void touch() {
        this.lastTouchedTime = new Date().getTime();
        if (this.parent != null) {
            this.parent.touch();
        }
    }

    public long getLastTouchedTime() {
        return this.lastTouchedTime;
    }

    public Iterator getServiceGroupContext() {
        if (this.serviceGroupContextMap != null) {
            if (this.serviceGroupContextMap.isEmpty()) {
                return null;
            }
            return this.serviceGroupContextMap.values().iterator();
        }
        return null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.serviceGroupContextMap != null && !this.serviceGroupContextMap.isEmpty()) {
            Iterator valuse = this.serviceGroupContextMap.values().iterator();
            while (valuse.hasNext()) {
                ServiceGroupContext serviceGroupContext = (ServiceGroupContext)valuse.next();
                this.cleanupServiceContextes(serviceGroupContext);
            }
        }
    }

    private void cleanupServiceContextes(ServiceGroupContext serviceGroupContext) {
        Iterator serviceContecxtes = serviceGroupContext.getServiceContexts();
        while (serviceContecxtes.hasNext()) {
            ServiceContext serviceContext = (ServiceContext)serviceContecxtes.next();
            DependencyManager.destroyServiceObject(serviceContext);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(-1100610673067568556L);
        out.writeInt(1);
        out.writeLong(this.getLastTouchedTime());
        out.writeLong(this.sessionContextTimeoutInterval);
        ObjectStateUtils.writeString(out, this.cookieID, "SessionContext.cookieID");
        Map tmpMap = this.getProperties();
        HashMap tmpHashMap = null;
        if (tmpMap != null && !tmpMap.isEmpty()) {
            tmpHashMap = new HashMap(tmpMap);
        }
        ObjectStateUtils.writeHashMap(out, tmpHashMap, "SessionContext.properties");
        ObjectStateUtils.writeObject(out, this.parent, "SessionContext.parent");
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Object tmpParent;
        if (log.isTraceEnabled()) {
            log.trace((Object)("SessionContext:readExternal():  BEGIN  bytes available in stream [" + in.available() + "]  "));
        }
        long suid = in.readLong();
        int revID = in.readInt();
        if (suid != -1100610673067568556L) {
            throw new ClassNotFoundException("Serialization version ID is not supported.");
        }
        if (revID != 1) {
            throw new ClassNotFoundException("Revision ID is not supported.");
        }
        long time = in.readLong();
        this.setLastTouchedTime(time);
        this.sessionContextTimeoutInterval = in.readLong();
        this.cookieID = ObjectStateUtils.readString(in, "SessionContext.cookieID");
        HashMap tmpHashMap = ObjectStateUtils.readHashMap(in, "SessionContext.properties");
        this.properties = new HashMap();
        if (tmpHashMap != null) {
            this.setProperties(tmpHashMap);
        }
        this.parent = (tmpParent = ObjectStateUtils.readObject(in, "SessionContext.parent")) != null ? (AbstractContext)tmpParent : null;
    }

    public ConfigurationContext getRootContext() {
        return null;
    }
}

