/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.llom.OMTextImpl;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axiom.soap.impl.llom.soap11.SOAP11Factory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.jms.AxisJMSException;
import org.apache.axis2.transport.jms.JMSConstants;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMSUtils {
    private static final Log log = LogFactory.getLog((Class)JMSUtils.class);

    public static boolean isJMSService(AxisService service) {
        boolean process = service.isEnableAllTransports();
        if (process) {
            return true;
        }
        List transports = service.getExposedTransports();
        for (int i = 0; i < transports.size(); ++i) {
            if (!"jms".equals(transports.get(i))) continue;
            return true;
        }
        return false;
    }

    public static String getDestination(AxisService service) {
        Parameter destParam = service.getParameter("transport.jms.Destination");
        String destination = null;
        destination = destParam != null ? (String)destParam.getValue() : service.getName();
        return destination;
    }

    public static Hashtable getProperties(String url) {
        Hashtable<String, String> h = new Hashtable<String, String>();
        int propPos = url.indexOf("?");
        if (propPos != -1) {
            StringTokenizer st = new StringTokenizer(url.substring(propPos + 1), "&");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int sep = token.indexOf("=");
                if (sep == -1) continue;
                h.put(token.substring(0, sep), token.substring(sep + 1));
            }
        }
        return h;
    }

    public static void markServiceAsFaulty(String serviceName, String msg, AxisConfiguration axisCfg) {
        if (serviceName != null) {
            try {
                AxisService service = axisCfg.getService(serviceName);
                axisCfg.getFaultyServices().put(service.getName(), msg);
            }
            catch (AxisFault axisFault) {
                log.warn((Object)("Error marking service : " + serviceName + " as faulty due to : " + msg), (Throwable)axisFault);
            }
        }
    }

    public static InputStream getInputStream(Message message) {
        try {
            if (message instanceof BytesMessage) {
                byte[] buffer = new byte[8192];
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                BytesMessage byteMsg = (BytesMessage)message;
                int bytesRead = byteMsg.readBytes(buffer);
                while (bytesRead != -1) {
                    out.write(buffer, 0, bytesRead);
                    bytesRead = byteMsg.readBytes(buffer);
                }
                return new ByteArrayInputStream(out.toByteArray());
            }
            if (message instanceof TextMessage) {
                TextMessage txtMsg = (TextMessage)message;
                String contentType = message.getStringProperty("contentType");
                if (contentType != null) {
                    return new ByteArrayInputStream(txtMsg.getText().getBytes(TransportUtils.getCharSetEncoding(contentType)));
                }
                return new ByteArrayInputStream(txtMsg.getText().getBytes());
            }
            JMSUtils.handleException("Unsupported JMS message type : " + message.getClass().getName());
        }
        catch (JMSException e) {
            JMSUtils.handleException("JMS Exception getting InputStream into message", (Exception)((Object)e));
        }
        catch (UnsupportedEncodingException e) {
            JMSUtils.handleException("Encoding exception getting InputStream into message", e);
        }
        return null;
    }

    public static String getProperty(Message message, String property) {
        try {
            return message.getStringProperty(property);
        }
        catch (JMSException e) {
            return null;
        }
    }

    public static String getContentType(MessageContext msgCtx) {
        OMOutputFormat format = new OMOutputFormat();
        String soapActionString = JMSUtils.getSOAPAction(msgCtx);
        String charSetEnc = (String)msgCtx.getProperty("CHARACTER_SET_ENCODING");
        if (charSetEnc != null) {
            format.setCharSetEncoding(charSetEnc);
        } else {
            OperationContext opctx = msgCtx.getOperationContext();
            if (opctx != null) {
                charSetEnc = (String)opctx.getProperty("CHARACTER_SET_ENCODING");
            }
        }
        if (charSetEnc == null) {
            charSetEnc = "UTF-8";
        }
        format.setSOAP11(msgCtx.isSOAP11());
        format.setCharSetEncoding(charSetEnc);
        String encoding = format.getCharSetEncoding();
        String contentType = format.getContentType();
        if (encoding != null) {
            contentType = contentType + "; charset=" + encoding;
        }
        if (!msgCtx.isSOAP11() && soapActionString != null && !"".equals(soapActionString.trim())) {
            contentType = contentType + ";action=\"" + soapActionString + "\";";
        }
        return contentType;
    }

    private static String getSOAPAction(MessageContext msgCtx) {
        String soapActionString = msgCtx.getSoapAction();
        if (soapActionString == null || soapActionString.trim().length() == 0) {
            soapActionString = msgCtx.getWSAAction();
        }
        Object disableSoapAction = msgCtx.getOptions().getProperty("disableSoapAction");
        if (soapActionString == null || JavaUtils.isTrueExplicitly(disableSoapAction)) {
            soapActionString = "";
        }
        return soapActionString;
    }

    public static String getDestination(String url) {
        String tempUrl = url.substring("jms:/".length());
        int propPos = tempUrl.indexOf("?");
        if (propPos == -1) {
            return tempUrl;
        }
        return tempUrl.substring(0, propPos);
    }

    public static SOAPEnvelope getSOAPEnvelope(Message message, MessageContext msgContext, InputStream in) throws XMLStreamException {
        SOAPEnvelope envelope = null;
        StAXBuilder builder = null;
        String contentType = JMSUtils.getProperty(message, "contentType");
        if (contentType != null) {
            if (contentType.indexOf("multipart/related") > -1) {
                builder = TransportUtils.selectBuilderForMIME(msgContext, in, contentType, true);
                envelope = (SOAPEnvelope)builder.getDocumentElement();
            } else {
                XMLStreamReader xmlreader;
                if (TransportUtils.getCharSetEncoding(contentType) == null) {
                    xmlreader = StAXUtils.createXMLStreamReader((InputStream)in, (String)"UTF-8");
                    msgContext.setProperty("CHARACTER_SET_ENCODING", "UTF-8");
                } else {
                    String charSetEnc = TransportUtils.getCharSetEncoding(contentType);
                    xmlreader = StAXUtils.createXMLStreamReader((InputStream)in, (String)charSetEnc);
                    msgContext.setProperty("CHARACTER_SET_ENCODING", charSetEnc);
                }
                if (contentType.indexOf("application/soap+xml") > -1) {
                    builder = new StAXSOAPModelBuilder(xmlreader, "http://www.w3.org/2003/05/soap-envelope");
                    envelope = (SOAPEnvelope)builder.getDocumentElement();
                } else if (contentType.indexOf("text/xml") > -1) {
                    builder = new StAXSOAPModelBuilder(xmlreader, "http://schemas.xmlsoap.org/soap/envelope/");
                    envelope = (SOAPEnvelope)builder.getDocumentElement();
                }
            }
        }
        if (builder == null) {
            SOAP11Factory soapFactory = new SOAP11Factory();
            try {
                XMLStreamReader xmlreader = StAXUtils.createXMLStreamReader((InputStream)in, (String)"UTF-8");
                msgContext.setProperty("CHARACTER_SET_ENCODING", "UTF-8");
                builder = new StAXOMBuilder(xmlreader);
                builder.setOMBuilderFactory((OMFactory)soapFactory);
                String ns = builder.getDocumentElement().getNamespace().getNamespaceURI();
                if ("http://www.w3.org/2003/05/soap-envelope".equals(ns)) {
                    envelope = JMSUtils.getEnvelope(in, "http://www.w3.org/2003/05/soap-envelope");
                } else if ("http://schemas.xmlsoap.org/soap/envelope/".equals(ns)) {
                    envelope = JMSUtils.getEnvelope(in, "http://schemas.xmlsoap.org/soap/envelope/");
                } else {
                    msgContext.setDoingREST(true);
                    envelope = soapFactory.getDefaultEnvelope();
                    envelope.getBody().addChild((OMNode)builder.getDocumentElement());
                }
            }
            catch (Exception e) {
                log.debug((Object)"Non SOAP/XML JMS message received");
                Parameter operationParam = msgContext.getAxisService().getParameter("transport.jms.Operation");
                QName operationQName = operationParam != null ? JMSUtils.getQName(operationParam.getValue()) : JMSConstants.DEFAULT_OPERATION;
                AxisOperation operation = msgContext.getAxisService().getOperation(operationQName);
                if (operation != null) {
                    msgContext.setAxisOperation(operation);
                } else {
                    JMSUtils.handleException("Cannot find operation : " + operationQName + " on the service " + msgContext.getAxisService());
                }
                Parameter wrapperParam = msgContext.getAxisService().getParameter("transport.jms.Wrapper");
                QName wrapperQName = wrapperParam != null ? JMSUtils.getQName(wrapperParam.getValue()) : JMSConstants.DEFAULT_WRAPPER;
                OMElement wrapper = soapFactory.createOMElement(wrapperQName, null);
                try {
                    if (message instanceof TextMessage) {
                        OMTextImpl textData = (OMTextImpl)soapFactory.createOMText(((TextMessage)message).getText());
                        wrapper.addChild((OMNode)textData);
                    } else if (message instanceof BytesMessage) {
                        BytesMessage bm = (BytesMessage)message;
                        byte[] msgBytes = new byte[(int)bm.getBodyLength()];
                        bm.reset();
                        bm.readBytes(msgBytes);
                        DataHandler dataHandler = new DataHandler((DataSource)new ByteArrayDataSource(msgBytes));
                        OMText textData = soapFactory.createOMText((Object)dataHandler, true);
                        wrapper.addChild((OMNode)textData);
                        msgContext.setDoingMTOM(true);
                    } else {
                        JMSUtils.handleException("Unsupported JMS Message format : " + message.getJMSType());
                    }
                    envelope = soapFactory.getDefaultEnvelope();
                    envelope.getBody().addChild((OMNode)wrapper);
                }
                catch (JMSException j) {
                    JMSUtils.handleException("Error wrapping JMS message into a SOAP envelope ", (Exception)((Object)j));
                }
            }
        }
        String charEncOfMessage = builder == null ? null : (builder.getDocument() == null ? null : builder.getDocument().getCharsetEncoding());
        String charEncOfTransport = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
        if (charEncOfMessage != null && charEncOfMessage.trim().length() != 0 && !charEncOfMessage.equalsIgnoreCase(charEncOfTransport)) {
            String faultCode = envelope.getNamespace() != null && "http://www.w3.org/2003/05/soap-envelope".equals(envelope.getNamespace().getNamespaceURI()) ? "Sender" : "Client";
            JMSUtils.handleException("Character Set Encoding from transport information do not match with character set encoding in the received SOAP message");
        }
        return envelope;
    }

    private static SOAPEnvelope getEnvelope(InputStream in, String namespace) throws XMLStreamException {
        try {
            in.reset();
        }
        catch (IOException e) {
            throw new XMLStreamException("Error resetting message input stream", e);
        }
        XMLStreamReader xmlreader = StAXUtils.createXMLStreamReader((InputStream)in, (String)"UTF-8");
        StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(xmlreader, namespace);
        return (SOAPEnvelope)builder.getDocumentElement();
    }

    private static QName getQName(Object obj) {
        if (obj instanceof QName) {
            return (QName)obj;
        }
        String value = obj.toString();
        int open = value.indexOf(123);
        int close = value.indexOf(125);
        if (close > open && open > -1 && value.length() > close) {
            return new QName(value.substring(open + 1, close - open), value.substring(close + 1));
        }
        return new QName(value);
    }

    private static void handleException(String s) {
        log.error((Object)s);
        throw new AxisJMSException(s);
    }

    private static void handleException(String s, Exception e) {
        log.error((Object)s, (Throwable)e);
        throw new AxisJMSException(s, e);
    }
}

