/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.engine.DependencyManager;
import org.apache.axis2.util.UUIDGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SessionManager {
    private static final Log LOG = LogFactory.getLog((Class)SessionManager.class);
    private final Map sessionmap = new HashMap();

    public synchronized SessionContext getSessionContext(String sessionKey) {
        SessionContext sessionContext = null;
        if (sessionKey != null && sessionKey.length() != 0) {
            sessionContext = (SessionContext)this.sessionmap.get(sessionKey);
        }
        if (sessionContext == null) {
            sessionKey = UUIDGenerator.getUUID();
            sessionContext = new SessionContext(null);
            sessionContext.setCookieID(sessionKey);
            this.sessionmap.put(sessionKey, sessionContext);
        }
        sessionContext.touch();
        this.cleanupServiceGroupContexts();
        return sessionContext;
    }

    private void cleanupServiceGroupContexts() {
        long currentTime = System.currentTimeMillis();
        Iterator it = this.sessionmap.keySet().iterator();
        while (it.hasNext()) {
            String cookieID = (String)it.next();
            SessionContext sessionContext = (SessionContext)this.sessionmap.get(cookieID);
            if (currentTime - sessionContext.getLastTouchedTime() <= sessionContext.sessionContextTimeoutInterval) continue;
            it.remove();
            Iterator serviceGroupContext = sessionContext.getServiceGroupContext();
            if (serviceGroupContext == null) continue;
            while (serviceGroupContext.hasNext()) {
                ServiceGroupContext groupContext = (ServiceGroupContext)serviceGroupContext.next();
                this.cleanupServiceContexts(groupContext);
            }
        }
    }

    private void cleanupServiceContexts(ServiceGroupContext serviceGroupContext) {
        Iterator it = serviceGroupContext.getServiceContexts();
        while (it.hasNext()) {
            ServiceContext serviceContext = (ServiceContext)it.next();
            try {
                DependencyManager.destroyServiceObject(serviceContext);
            }
            catch (AxisFault axisFault) {
                LOG.info((Object)axisFault.getMessage());
            }
        }
    }
}

