/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport;

import java.io.OutputStream;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.http.HTTPTransportUtils;

public abstract class AbstractTransportSender
extends AbstractHandler
implements TransportSender {
    public static final String NAME = "TransportSender";

    public AbstractTransportSender() {
        this.init(new HandlerDescription(NAME));
    }

    public abstract void finalizeSendWithOutputStreamFromIncomingConnection(MessageContext var1, OutputStream var2) throws AxisFault;

    public abstract void finalizeSendWithToAddress(MessageContext var1, OutputStream var2) throws AxisFault;

    public void init(ConfigurationContext confContext, TransportOutDescription transportOut) throws AxisFault {
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        msgContext.setDoingMTOM(HTTPTransportUtils.doWriteMTOM(msgContext));
        msgContext.setDoingSwA(HTTPTransportUtils.doWriteSwA(msgContext));
        EndpointReference epr = null;
        if (msgContext.getTo() != null && !msgContext.getTo().hasAnonymousAddress()) {
            epr = msgContext.getTo();
        }
        if (epr != null) {
            if (!epr.hasNoneAddress()) {
                OutputStream out = this.openTheConnection(epr, msgContext);
                OutputStream newOut = this.startSendWithToAddress(msgContext, out);
                if (newOut != null) {
                    out = newOut;
                }
                this.writeMessage(msgContext, out);
                this.finalizeSendWithToAddress(msgContext, out);
            }
        } else {
            OutputStream out = (OutputStream)msgContext.getProperty("TRANSPORT_OUT");
            if (out != null) {
                this.startSendWithOutputStreamFromIncomingConnection(msgContext, out);
                this.writeMessage(msgContext, out);
                this.finalizeSendWithOutputStreamFromIncomingConnection(msgContext, out);
            } else {
                throw new AxisFault("Both the TO and Property MessageContext.TRANSPORT_OUT is Null, No where to send");
            }
        }
        if (msgContext.getOperationContext() != null) {
            msgContext.getOperationContext().setProperty("CONTENT_WRITTEN", "true");
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    protected abstract OutputStream openTheConnection(EndpointReference var1, MessageContext var2) throws AxisFault;

    public abstract OutputStream startSendWithOutputStreamFromIncomingConnection(MessageContext var1, OutputStream var2) throws AxisFault;

    public abstract OutputStream startSendWithToAddress(MessageContext var1, OutputStream var2) throws AxisFault;

    public void writeMessage(MessageContext msgContext, OutputStream out) throws AxisFault {
        SOAPEnvelope envelope;
        SOAPEnvelope outputMessage = envelope = msgContext.getEnvelope();
        if (envelope != null && msgContext.isDoingREST()) {
            outputMessage = envelope.getBody().getFirstElement();
        }
        if (outputMessage != null) {
            try {
                OMOutputFormat format = new OMOutputFormat();
                String charSetEnc = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
                format.setDoOptimize(false);
                format.setDoingSWA(false);
                format.setCharSetEncoding(charSetEnc);
                outputMessage.serializeAndConsume(out, format);
                out.flush();
            }
            catch (Exception e) {
                throw new AxisFault(e);
            }
        } else {
            throw new AxisFault(Messages.getMessage("outMessageNull"));
        }
    }
}

