/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.AbstractDispatcher;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SOAPMessageBodyBasedDispatcher
extends AbstractDispatcher {
    public static final String NAME = "SOAPMessageBodyBasedDispatcher";
    private static final Log log = LogFactory.getLog((Class)SOAPMessageBodyBasedDispatcher.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();

    public AxisOperation findOperation(AxisService service, MessageContext messageContext) throws AxisFault {
        OMElement bodyFirstChild = messageContext.getEnvelope().getBody().getFirstElement();
        if (bodyFirstChild == null) {
            return null;
        }
        if (isDebugEnabled) {
            log.debug((Object)("Checking for Operation using SOAP message body's first child's local name : " + bodyFirstChild.getLocalName()));
        }
        QName operationName = new QName(bodyFirstChild.getLocalName());
        return service.getOperation(operationName);
    }

    public AxisService findService(MessageContext messageContext) throws AxisFault {
        OMNamespace ns;
        OMElement bodyFirstChild = messageContext.getEnvelope().getBody().getFirstElement();
        if (bodyFirstChild != null && (ns = bodyFirstChild.getNamespace()) != null) {
            ConfigurationContext configurationContext;
            String[] values;
            String filePart = ns.getNamespaceURI();
            if (isDebugEnabled) {
                log.debug((Object)("Checking for Service using SOAP message body's first child's namespace : " + filePart));
            }
            if ((values = Utils.parseRequestURLForServiceAndOperation(filePart, (configurationContext = messageContext.getConfigurationContext()).getServiceContextPath()))[0] != null) {
                String serviceName = values[0];
                AxisConfiguration registry = configurationContext.getAxisConfiguration();
                return registry.getService(serviceName);
            }
        }
        return null;
    }

    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }
}

