/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultNode;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultRole;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.TargetResolver;
import org.apache.axis2.util.UUIDGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AxisEngine {
    private static final Log log = LogFactory.getLog((Class)AxisEngine.class);
    private ConfigurationContext engineContext;

    public AxisEngine(ConfigurationContext engineContext) {
        this.engineContext = engineContext;
    }

    private void checkMustUnderstand(MessageContext msgContext) throws AxisFault {
        if (!msgContext.isHeaderPresent()) {
            return;
        }
        SOAPEnvelope envelope = msgContext.getEnvelope();
        if (envelope.getHeader() == null) {
            return;
        }
        Iterator headerBlocks = envelope.getHeader().examineAllHeaderBlocks();
        while (headerBlocks.hasNext()) {
            SOAPHeaderBlock headerBlock = (SOAPHeaderBlock)headerBlocks.next();
            if (headerBlock.isProcessed() || !headerBlock.getMustUnderstand()) continue;
            String role = headerBlock.getRole();
            String prefix = envelope.getNamespace().getPrefix();
            if (!msgContext.isSOAP11()) {
                if (prefix == null || "".equals(prefix)) {
                    prefix = "soapenv";
                }
                if (role != null) {
                    if ("http://www.w3.org/2003/05/soap-envelope/role/next".equals(role)) continue;
                    throw new AxisFault(Messages.getMessage("mustunderstandfailed", prefix, "MustUnderstand"));
                }
                throw new AxisFault(Messages.getMessage("mustunderstandfailed", prefix, "MustUnderstand"));
            }
            if (role == null || "http://schemas.xmlsoap.org/soap/actor/next".equals(role)) continue;
            throw new AxisFault(Messages.getMessage("mustunderstandfailed", prefix, "MustUnderstand"));
        }
    }

    public MessageContext createFaultMessageContext(MessageContext processingContext, Throwable e) throws AxisFault {
        EndpointReference faultTo;
        ServiceContext serviceContext;
        if (processingContext.isProcessingFault()) {
            throw new AxisFault(Messages.getMessage("errorwhileProcessingFault"));
        }
        MessageContext faultContext = new MessageContext();
        faultContext.setConfigurationContext(this.engineContext);
        faultContext.setSessionContext(processingContext.getSessionContext());
        faultContext.setTransportIn(processingContext.getTransportIn());
        faultContext.setTransportOut(processingContext.getTransportOut());
        faultContext.setMessageID(UUIDGenerator.getUUID());
        faultContext.addRelatesTo(new RelatesTo(processingContext.getOptions().getMessageId()));
        faultContext.setProperty("CHARACTER_SET_ENCODING", processingContext.getProperty("CHARACTER_SET_ENCODING"));
        faultContext.setProperty("WSAddressingVersion", processingContext.getProperty("WSAddressingVersion"));
        faultContext.setProperty("disableAddressingForOutMessages", processingContext.getProperty("disableAddressingForOutMessages"));
        if (processingContext.getAxisOperation() != null && processingContext.getOperationContext() != null) {
            processingContext.getAxisOperation().addFaultMessageContext(faultContext, processingContext.getOperationContext());
        }
        if ((serviceContext = processingContext.getServiceContext()) != null) {
            faultContext.setServiceContext(serviceContext);
        }
        faultContext.setOperationContext(processingContext.getOperationContext());
        faultContext.setProcessingFault(true);
        faultContext.setServerSide(true);
        faultContext.setDoingREST(processingContext.isDoingREST());
        faultContext.setReplyTo(new EndpointReference("http://www.w3.org/2005/08/addressing/none"));
        AxisOperation op = processingContext.getAxisOperation();
        if (op != null && op.getFaultAction() != null) {
            faultContext.setWSAAction(processingContext.getAxisOperation().getFaultAction());
        } else {
            faultContext.setWSAAction("http://www.w3.org/2005/08/addressing/soap/fault");
        }
        Object faultInfoForHeaders = processingContext.getProperty("FaultHeaders");
        if (faultInfoForHeaders != null) {
            faultContext.setProperty("FaultHeaders", faultInfoForHeaders);
            faultContext.setWSAAction("http://www.w3.org/2005/08/addressing/fault");
        }
        boolean doNotSendFaultUsingFaultTo = false;
        if (faultInfoForHeaders != null) {
            String problemHeaderName = (String)((Map)faultInfoForHeaders).get("ProblemHeaderQName");
            boolean bl = doNotSendFaultUsingFaultTo = problemHeaderName != null && "wsa:FaultTo".equals(problemHeaderName);
        }
        if ((faultTo = processingContext.getFaultTo()) != null && !doNotSendFaultUsingFaultTo) {
            faultContext.setTo(faultTo);
        } else {
            faultContext.setTo(processingContext.getReplyTo());
        }
        TargetResolver targetResolver = faultContext.getConfigurationContext().getAxisConfiguration().getTargetResolverChain();
        if (targetResolver != null) {
            targetResolver.resolveTarget(faultContext);
        }
        TransportOutDescription transportOut = faultContext.getTransportOut();
        try {
            EndpointReference responseEPR = faultContext.getTo();
            if (faultContext.isServerSide() && responseEPR != null && !responseEPR.hasAnonymousAddress() && !responseEPR.hasNoneAddress()) {
                URI uri = new URI(responseEPR.getAddress());
                String scheme = uri.getScheme();
                if (!transportOut.getName().getLocalPart().equals(scheme)) {
                    ConfigurationContext configurationContext = faultContext.getConfigurationContext();
                    transportOut = configurationContext.getAxisConfiguration().getTransportOut(new QName(scheme));
                    if (transportOut == null) {
                        throw new AxisFault("Can not find the transport sender : " + scheme);
                    }
                    faultContext.setTransportOut(transportOut);
                }
            }
        }
        catch (URISyntaxException urise) {
            throw new AxisFault(urise);
        }
        SOAPEnvelope envelope = processingContext.isSOAP11() ? OMAbstractFactory.getSOAP11Factory().getDefaultFaultEnvelope() : OMAbstractFactory.getSOAP12Factory().getDefaultFaultEnvelope();
        this.extractFaultInformationFromMessageContext(processingContext, envelope.getBody().getFault(), e);
        faultContext.setEnvelope(envelope);
        faultContext.setProperty("TRANSPORT_OUT", processingContext.getProperty("TRANSPORT_OUT"));
        faultContext.setProperty("OutTransportInfo", processingContext.getProperty("OutTransportInfo"));
        return faultContext;
    }

    private void extractFaultInformationFromMessageContext(MessageContext context, SOAPFault fault, Throwable e) {
        boolean sendStacktraceDetailsWithFaults;
        Map faultElementsMap;
        Map faultElementsMap2;
        Object faultRole;
        SOAPProcessingException soapException = null;
        AxisFault axisFault = null;
        if (e != null) {
            if (e instanceof AxisFault) {
                axisFault = (AxisFault)e;
            } else if (e.getCause() instanceof AxisFault) {
                axisFault = (AxisFault)e.getCause();
            }
        }
        if (e instanceof SOAPProcessingException) {
            soapException = (SOAPProcessingException)e;
        } else if (axisFault != null && axisFault.getCause() instanceof SOAPProcessingException) {
            soapException = (SOAPProcessingException)axisFault.getCause();
        }
        Object faultCode = context.getProperty("Code");
        String soapFaultCode = "";
        if (faultCode != null) {
            fault.setCode((SOAPFaultCode)faultCode);
        } else if (soapException != null) {
            soapFaultCode = soapException.getFaultCode();
        } else if (axisFault != null) {
            Map faultElementsMap3 = axisFault.getFaultElements();
            if (faultElementsMap3 != null && faultElementsMap3.get("Code") != null) {
                fault.setCode((SOAPFaultCode)faultElementsMap3.get("Code"));
            } else {
                QName faultCodeQName = axisFault.getFaultCode();
                if (faultCodeQName != null) {
                    if (faultCodeQName.getLocalPart().indexOf(":") == -1) {
                        String prefix = faultCodeQName.getPrefix();
                        String uri = faultCodeQName.getNamespaceURI();
                        prefix = prefix == null || "".equals(prefix) ? "axis2" : prefix;
                        uri = uri == null || "".equals(uri) ? "http://ws.apache.org/namespaces/axis2" : uri;
                        soapFaultCode = prefix + ":" + faultCodeQName.getLocalPart();
                        fault.declareNamespace(uri, prefix);
                    } else {
                        soapFaultCode = faultCodeQName.getLocalPart();
                    }
                }
            }
        }
        if (faultCode == null && context.getEnvelope() != null) {
            soapFaultCode = "".equals(soapFaultCode) || soapFaultCode == null ? this.getSenderFaultCode(context.getEnvelope().getNamespace()) : soapFaultCode;
            fault.getCode().getValue().setText(soapFaultCode);
        }
        Object faultReason = context.getProperty("Reason");
        String message = "";
        if (faultReason != null) {
            fault.setReason((SOAPFaultReason)faultReason);
            message = fault.getReason().getFirstSOAPText().getText();
        } else if (soapException != null) {
            message = soapException.getMessage();
        } else if (axisFault != null) {
            Map faultElementsMap4 = axisFault.getFaultElements();
            if (faultElementsMap4 != null && faultElementsMap4.get("Reason") != null) {
                fault.setReason((SOAPFaultReason)faultElementsMap4.get("Reason"));
            } else {
                message = axisFault.getReason();
                if (message == null || "".equals(message)) {
                    message = this.getFaultReasonFromException(e, context);
                }
            }
        }
        if (faultReason == null) {
            message = "".equals(message) || message == null ? "unknown" : message;
            fault.getReason().getFirstSOAPText().setLang("en-US");
            fault.getReason().getFirstSOAPText().setText(message);
        }
        if ((faultRole = context.getProperty("Role")) != null) {
            fault.getRole().setText((String)faultRole);
        } else if (axisFault != null && (faultElementsMap2 = axisFault.getFaultElements()) != null && faultElementsMap2.get("Role") != null) {
            fault.setRole((SOAPFaultRole)faultElementsMap2.get("Role"));
        }
        Object faultNode = context.getProperty("Node");
        if (faultNode != null) {
            fault.getNode().setText((String)faultNode);
        } else if (axisFault != null && (faultElementsMap = axisFault.getFaultElements()) != null && faultElementsMap.get("Node") != null) {
            fault.setNode((SOAPFaultNode)faultElementsMap.get("Node"));
        }
        OperationContext oc = context.getOperationContext();
        Object flagFromContext = null;
        if (oc != null) {
            flagFromContext = context.getOperationContext().getProperty("sendStacktraceDetailsWithFaults");
        }
        if (flagFromContext != null) {
            sendStacktraceDetailsWithFaults = JavaUtils.isTrue(flagFromContext);
        } else {
            Parameter param = context.getParameter("sendStacktraceDetailsWithFaults");
            sendStacktraceDetailsWithFaults = JavaUtils.isTrue(param.getValue());
        }
        Object faultDetail = context.getProperty("Detail");
        if (faultDetail != null) {
            fault.setDetail((SOAPFaultDetail)faultDetail);
        } else if (axisFault != null) {
            Map faultElementsMap5 = axisFault.getFaultElements();
            if (faultElementsMap5 != null && faultElementsMap5.get("Detail") != null) {
                fault.setDetail((SOAPFaultDetail)faultElementsMap5.get("Detail"));
            } else {
                OMElement detail = axisFault.getDetail();
                if (detail != null) {
                    fault.getDetail().addDetailEntry(detail);
                } else if (sendStacktraceDetailsWithFaults) {
                    fault.setException((Exception)axisFault);
                }
            }
        } else if (fault.getException() == null && sendStacktraceDetailsWithFaults) {
            if (e instanceof Exception) {
                fault.setException((Exception)e);
            } else {
                fault.setException(new Exception(e));
            }
        }
    }

    private String getFaultReasonFromException(Throwable e, MessageContext context) {
        boolean drillDownToRootCauseForFaultReason;
        Throwable throwable = e;
        Parameter param = context.getParameter("drillDownToRootCauseForFaultReason");
        boolean bl = drillDownToRootCauseForFaultReason = param != null && ((String)param.getValue()).equalsIgnoreCase("true");
        if (drillDownToRootCauseForFaultReason) {
            while (throwable.getCause() != null) {
                throwable = throwable.getCause();
            }
        }
        return throwable.getMessage();
    }

    public void receive(MessageContext msgContext) throws AxisFault {
        ConfigurationContext confContext = msgContext.getConfigurationContext();
        ArrayList preCalculatedPhases = confContext.getAxisConfiguration().getGlobalInFlow();
        msgContext.setExecutionChain((ArrayList)preCalculatedPhases.clone());
        msgContext.setFLOW(1);
        Handler.InvocationResponse pi = this.invoke(msgContext);
        if (pi.equals(Handler.InvocationResponse.CONTINUE) && msgContext.isServerSide()) {
            this.checkMustUnderstand(msgContext);
            MessageReceiver receiver = msgContext.getAxisOperation().getMessageReceiver();
            receiver.receive(msgContext);
        }
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        Handler currentHandler;
        if (msgContext.getCurrentHandlerIndex() == -1) {
            msgContext.setCurrentHandlerIndex(0);
        }
        Handler.InvocationResponse pi = Handler.InvocationResponse.CONTINUE;
        while (msgContext.getCurrentHandlerIndex() < msgContext.getExecutionChain().size() && !(pi = (currentHandler = (Handler)msgContext.getExecutionChain().get(msgContext.getCurrentHandlerIndex())).invoke(msgContext)).equals(Handler.InvocationResponse.SUSPEND) && !pi.equals(Handler.InvocationResponse.ABORT)) {
            msgContext.setCurrentHandlerIndex(msgContext.getCurrentHandlerIndex() + 1);
        }
        return pi;
    }

    public Handler.InvocationResponse resumeReceive(MessageContext msgContext) throws AxisFault {
        Handler.InvocationResponse pi = this.invoke(msgContext);
        if (pi.equals(Handler.InvocationResponse.CONTINUE) && msgContext.isServerSide()) {
            this.checkMustUnderstand(msgContext);
            MessageReceiver receiver = msgContext.getAxisOperation().getMessageReceiver();
            receiver.receive(msgContext);
        }
        return pi;
    }

    public Handler.InvocationResponse resumeSend(MessageContext msgContext) throws AxisFault {
        Handler.InvocationResponse pi = this.invoke(msgContext);
        if (pi.equals(Handler.InvocationResponse.CONTINUE)) {
            TransportOutDescription transportOut = msgContext.getTransportOut();
            TransportSender sender = transportOut.getSender();
            sender.invoke(msgContext);
        }
        return pi;
    }

    public void receiveFault(MessageContext msgContext) throws AxisFault {
        log.debug((Object)Messages.getMessage("receivederrormessage", msgContext.getMessageID()));
        ConfigurationContext confContext = msgContext.getConfigurationContext();
        ArrayList preCalculatedPhases = confContext.getAxisConfiguration().getInFaultFlow();
        msgContext.setExecutionChain((ArrayList)preCalculatedPhases.clone());
        msgContext.setFLOW(3);
        Handler.InvocationResponse pi = this.invoke(msgContext);
        if (pi.equals(Handler.InvocationResponse.CONTINUE) && msgContext.isServerSide()) {
            this.checkMustUnderstand(msgContext);
            MessageReceiver receiver = msgContext.getAxisOperation().getMessageReceiver();
            receiver.receive(msgContext);
        }
    }

    public Handler.InvocationResponse resume(MessageContext msgctx) throws AxisFault {
        msgctx.setPaused(false);
        if (msgctx.getFLOW() == 1) {
            return this.resumeReceive(msgctx);
        }
        return this.resumeSend(msgctx);
    }

    public void send(MessageContext msgContext) throws AxisFault {
        OperationContext operationContext = msgContext.getOperationContext();
        ArrayList executionChain = operationContext.getAxisOperation().getPhasesOutFlow();
        ArrayList outPhases = new ArrayList();
        outPhases.addAll((ArrayList)executionChain.clone());
        outPhases.addAll((ArrayList)msgContext.getConfigurationContext().getAxisConfiguration().getGlobalOutPhases().clone());
        msgContext.setExecutionChain(outPhases);
        msgContext.setFLOW(2);
        Handler.InvocationResponse pi = this.invoke(msgContext);
        if (pi.equals(Handler.InvocationResponse.CONTINUE)) {
            TransportOutDescription transportOut = msgContext.getTransportOut();
            if (transportOut == null) {
                throw new AxisFault("Transport out has not been set");
            }
            TransportSender sender = transportOut.getSender();
            Object isTransportNonBlocking = msgContext.getProperty("transportNonBlocking");
            if (isTransportNonBlocking != null && ((Boolean)isTransportNonBlocking).booleanValue()) {
                msgContext.getConfigurationContext().getThreadPool().execute(new TransportNonBlockingInvocationWorker(msgContext, sender));
            } else {
                sender.invoke(msgContext);
            }
        }
    }

    public void sendFault(MessageContext msgContext) throws AxisFault {
        OperationContext opContext = msgContext.getOperationContext();
        Handler.InvocationResponse pi = Handler.InvocationResponse.CONTINUE;
        if (opContext != null) {
            AxisOperation axisOperation = opContext.getAxisOperation();
            ArrayList faultExecutionChain = axisOperation.getPhasesOutFaultFlow();
            ArrayList outFaultPhases = new ArrayList();
            outFaultPhases.addAll((ArrayList)faultExecutionChain.clone());
            msgContext.setExecutionChain((ArrayList)outFaultPhases.clone());
            msgContext.setFLOW(4);
            pi = this.invoke(msgContext);
        }
        if (pi.equals(Handler.InvocationResponse.CONTINUE)) {
            msgContext.setExecutionChain((ArrayList)msgContext.getConfigurationContext().getAxisConfiguration().getOutFaultFlow().clone());
            msgContext.setFLOW(4);
            this.invoke(msgContext);
            TransportSender sender = msgContext.getTransportOut().getSender();
            sender.invoke(msgContext);
        }
    }

    private String getSenderFaultCode(OMNamespace soapNamespace) {
        return "http://www.w3.org/2003/05/soap-envelope".equals(soapNamespace.getNamespaceURI()) ? "soapenv:Sender" : "soapenv:Client";
    }

    private class TransportNonBlockingInvocationWorker
    implements Runnable {
        private MessageContext msgctx;
        private TransportSender sender;

        public TransportNonBlockingInvocationWorker(MessageContext msgctx, TransportSender sender) {
            this.msgctx = msgctx;
            this.sender = sender;
        }

        public void run() {
            try {
                this.sender.invoke(this.msgctx);
            }
            catch (Exception e) {
                log.info((Object)e.getMessage());
            }
        }
    }
}

