/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.ModuleConfiguration;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisEvent;
import org.apache.axis2.engine.AxisObserver;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.phaseresolver.PhaseResolver;
import org.apache.axis2.util.TargetResolver;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AxisConfiguration
extends AxisDescription {
    private static final Log log = LogFactory.getLog((Class)AxisConfiguration.class);
    private final HashMap allModules = new HashMap();
    private final HashMap nameToversionMap = new HashMap();
    private final HashMap transportsIn = new HashMap();
    private final HashMap transportsOut = new HashMap();
    private final HashMap policySupportedModules = new HashMap();
    private final ArrayList localPolicyAssertions = new ArrayList();
    private ArrayList observersList = null;
    private URL axis2Repository = null;
    private HashMap allservices = new HashMap();
    private List globalModuleList;
    private final List engagedModules;
    private Hashtable faultyModules;
    private Hashtable faultyServices;
    private ArrayList inFaultPhases;
    private ArrayList inPhasesUptoAndIncludingPostDispatch;
    private HashMap messageReceivers;
    private ClassLoader moduleClassLoader;
    private HashMap moduleConfigmap = new HashMap();
    private ArrayList outFaultPhases;
    private ArrayList outPhases;
    protected PhasesInfo phasesinfo;
    private ClassLoader serviceClassLoader;
    private ClassLoader systemClassLoader;
    private boolean manageTransportSession;
    private boolean start;
    private ArrayList targetResolvers;

    public AxisConfiguration() {
        this.engagedModules = new ArrayList();
        this.globalModuleList = new ArrayList();
        this.messageReceivers = new HashMap();
        this.outPhases = new ArrayList();
        this.inFaultPhases = new ArrayList();
        this.outFaultPhases = new ArrayList();
        this.faultyServices = new Hashtable();
        this.faultyModules = new Hashtable();
        this.observersList = new ArrayList();
        this.inPhasesUptoAndIncludingPostDispatch = new ArrayList();
        this.systemClassLoader = Thread.currentThread().getContextClassLoader();
        this.serviceClassLoader = Thread.currentThread().getContextClassLoader();
        this.moduleClassLoader = Thread.currentThread().getContextClassLoader();
        this.phasesinfo = new PhasesInfo();
        this.targetResolvers = new ArrayList();
    }

    public void addMessageReceiver(String mepURL, MessageReceiver messageReceiver) {
        this.messageReceivers.put(mepURL, messageReceiver);
    }

    public void addModule(AxisModule module) throws AxisFault {
        module.setParent(this);
        this.notifyObservers(4, module);
        String moduleName = module.getName().getLocalPart();
        if (moduleName.endsWith("SNAPSHOT")) {
            QName moduleQName = new QName(moduleName.substring(0, moduleName.indexOf("SNAPSHOT") - 1));
            module.setName(moduleQName);
            this.allModules.put(moduleQName, module);
        } else {
            this.allModules.put(module.getName(), module);
        }
        this.registerModulePolicySupport(module);
        this.registerLocalPolicyAssertions(module);
    }

    public void removeModule(QName module) {
        this.allModules.remove(module);
    }

    public void addModuleConfig(ModuleConfiguration moduleConfiguration) {
        this.moduleConfigmap.put(moduleConfiguration.getModuleName(), moduleConfiguration);
    }

    public void addObservers(AxisObserver axisObserver) {
        this.observersList.add(axisObserver);
    }

    public synchronized void addService(AxisService service) throws AxisFault {
        AxisServiceGroup axisServiceGroup = new AxisServiceGroup();
        axisServiceGroup.setServiceGroupName(service.getName());
        axisServiceGroup.setParent(this);
        axisServiceGroup.addService(service);
        this.addServiceGroup(axisServiceGroup);
    }

    private void isWSDLEnable(AxisService axisService) {
        if (!axisService.isWsdlFound()) {
            Iterator operatins = axisService.getOperations();
            if (operatins.hasNext()) {
                while (operatins.hasNext()) {
                    AxisOperation axisOperation = (AxisOperation)operatins.next();
                    if (axisOperation.getMessageReceiver() == null) {
                        axisService.setWsdlFound(false);
                        return;
                    }
                    String messageReceiverClass = axisOperation.getMessageReceiver().getClass().getName();
                    if ("org.apache.axis2.rpc.receivers.RPCMessageReceiver".equals(messageReceiverClass) || "org.apache.axis2.rpc.receivers.RPCInOnlyMessageReceiver".equals(messageReceiverClass) || "org.apache.axis2.rpc.receivers.RPCInOutAsyncMessageReceiver".equals(messageReceiverClass)) continue;
                    axisService.setWsdlFound(false);
                    return;
                }
                axisService.setWsdlFound(true);
            } else {
                axisService.setWsdlFound(false);
            }
        }
    }

    public synchronized void addServiceGroup(AxisServiceGroup axisServiceGroup) throws AxisFault {
        AxisService description;
        this.notifyObservers(1, axisServiceGroup);
        Iterator services = axisServiceGroup.getServices();
        axisServiceGroup.setParent(this);
        while (services.hasNext()) {
            description = (AxisService)services.next();
            if (this.allservices.get(description.getName()) != null) {
                throw new AxisFault(Messages.getMessage("twoservicecannothavesamename", description.getName()));
            }
            if (description.getSchematargetNamespace() == null) {
                description.setSchematargetNamespace("http://org.apache.axis2/xsd");
            }
            this.isWSDLEnable(description);
        }
        services = axisServiceGroup.getServices();
        while (services.hasNext()) {
            description = (AxisService)services.next();
            if (!description.isUseDefaultChains()) continue;
            Iterator operations = description.getOperations();
            while (operations.hasNext()) {
                AxisOperation operation = (AxisOperation)operations.next();
                this.phasesinfo.setOperationPhases(operation);
            }
        }
        Iterator enModule = this.engagedModules.iterator();
        while (enModule.hasNext()) {
            QName moduleName = (QName)enModule.next();
            axisServiceGroup.engageModule(this.getModule(moduleName), this);
        }
        services = axisServiceGroup.getServices();
        while (services.hasNext()) {
            description = (AxisService)services.next();
            this.allservices.put(description.getName(), description);
            if (description.isClientSide()) continue;
            this.notifyObservers(1, description);
        }
        this.addChild(axisServiceGroup);
    }

    public void removeServiceGroup(String serviceGroupName) throws AxisFault {
        AxisServiceGroup axisServiceGroup = (AxisServiceGroup)this.getChild(serviceGroupName);
        if (axisServiceGroup == null) {
            throw new AxisFault(Messages.getMessage("invalidservicegroupname", serviceGroupName));
        }
        Iterator services = axisServiceGroup.getServices();
        while (services.hasNext()) {
            AxisService axisService = (AxisService)services.next();
            this.allservices.remove(axisService.getName());
            if (axisService.isClientSide()) continue;
            this.notifyObservers(0, axisService);
        }
        this.removeChild(serviceGroupName);
        this.notifyObservers(0, axisServiceGroup);
    }

    public void addTransportIn(TransportInDescription transport) throws AxisFault {
        if (transport.getReceiver() == null) {
            throw new AxisFault("Transport Receiver can not be null for the transport " + transport.getName().getLocalPart());
        }
        this.transportsIn.put(transport.getName(), transport);
    }

    public void addTransportOut(TransportOutDescription transport) throws AxisFault {
        if (transport.getSender() == null) {
            throw new AxisFault("Transport sender can not be null for the transport " + transport.getName().getLocalPart());
        }
        this.transportsOut.put(transport.getName(), transport);
    }

    public void engageModule(QName moduleref) throws AxisFault {
        AxisModule module = this.getModule(moduleref);
        if (module == null) {
            throw new AxisFault(Messages.getMessage("modulenotavailble", moduleref.getLocalPart()));
        }
        this.engageModule(module);
    }

    public void engageModule(String moduleName, String versionID) throws AxisFault {
        QName moduleQName = Utils.getModuleName(moduleName, versionID);
        AxisModule module = this.getModule(moduleQName);
        if (module == null) {
            throw new AxisFault(Messages.getMessage("refertoinvalidmodule"));
        }
        this.engageModule(module);
    }

    public void engageModule(AxisModule axisModule, AxisConfiguration axisConfig) throws AxisFault {
        this.engageModule(axisModule);
    }

    private void engageModule(AxisModule module) throws AxisFault {
        if (module != null) {
            QName moduleQName = module.getName();
            Iterator iterator = this.engagedModules.iterator();
            while (iterator.hasNext()) {
                QName qName = (QName)iterator.next();
                boolean isEngagable = Utils.checkVersion(moduleQName, qName);
                if (isEngagable) continue;
                return;
            }
        } else {
            throw new AxisFault(Messages.getMessage("refertoinvalidmodule"));
        }
        Iterator servicegroups = this.getServiceGroups();
        while (servicegroups.hasNext()) {
            AxisServiceGroup serviceGroup = (AxisServiceGroup)servicegroups.next();
            serviceGroup.engageModule(module, this);
        }
        this.engagedModules.add(module.getName());
    }

    public void disengageModule(AxisModule module) {
        if (module != null && this.isEngaged(module.getName())) {
            PhaseResolver phaseResolver = new PhaseResolver(this);
            phaseResolver.disengageModuleFromGlobalChains(module);
            Iterator serviceItr = this.getServices().values().iterator();
            while (serviceItr.hasNext()) {
                AxisService axisService = (AxisService)serviceItr.next();
                axisService.disengageModule(module);
            }
            Iterator serviceGroups = this.getServiceGroups();
            while (serviceGroups.hasNext()) {
                AxisServiceGroup axisServiceGroup = (AxisServiceGroup)serviceGroups.next();
                axisServiceGroup.removeFromEngageList(module.getName());
            }
            this.engagedModules.remove(module.getName());
        }
    }

    public void notifyObservers(int event_type, AxisService service) {
        AxisEvent event = new AxisEvent(event_type);
        for (int i = 0; i < this.observersList.size(); ++i) {
            AxisObserver axisObserver = (AxisObserver)this.observersList.get(i);
            try {
                if (service.isClientSide()) continue;
                axisObserver.serviceUpdate(event, service);
                continue;
            }
            catch (Throwable e) {
                log.debug((Object)e);
            }
        }
    }

    public void notifyObservers(int event_type, AxisModule moule) {
        AxisEvent event = new AxisEvent(event_type);
        for (int i = 0; i < this.observersList.size(); ++i) {
            AxisObserver axisObserver = (AxisObserver)this.observersList.get(i);
            try {
                axisObserver.moduleUpdate(event, moule);
                continue;
            }
            catch (Throwable e) {
                log.debug((Object)e);
            }
        }
    }

    public void notifyObservers(int event_type, AxisServiceGroup serviceGroup) {
        AxisEvent event = new AxisEvent(event_type);
        for (int i = 0; i < this.observersList.size(); ++i) {
            AxisObserver axisObserver = (AxisObserver)this.observersList.get(i);
            try {
                axisObserver.serviceGroupUpdate(event, serviceGroup);
                continue;
            }
            catch (Throwable e) {
                log.debug((Object)e);
            }
        }
    }

    public synchronized void removeService(String name) throws AxisFault {
        AxisService service = (AxisService)this.allservices.remove(name);
        if (service != null) {
            log.debug((Object)Messages.getMessage("serviceremoved", name));
        }
    }

    public Collection getEngagedModules() {
        return this.engagedModules;
    }

    public List getGlobalModules() {
        return this.globalModuleList;
    }

    public Hashtable getFaultyModules() {
        return this.faultyModules;
    }

    public Hashtable getFaultyServices() {
        return this.faultyServices;
    }

    public void removeFaultyService(String key) {
        Iterator itr = this.faultyServices.keySet().iterator();
        while (itr.hasNext()) {
            String fullFileName = (String)itr.next();
            if (fullFileName.indexOf(key) <= 0) continue;
            this.faultyServices.remove(fullFileName);
            return;
        }
    }

    public ArrayList getGlobalOutPhases() {
        return this.outPhases;
    }

    public ArrayList getInFaultFlow() {
        return this.inFaultPhases;
    }

    public ArrayList getGlobalInFlow() {
        return this.inPhasesUptoAndIncludingPostDispatch;
    }

    public MessageReceiver getMessageReceiver(String mepURL) {
        return (MessageReceiver)this.messageReceivers.get(mepURL);
    }

    public AxisModule getModule(QName name) {
        AxisModule module = (AxisModule)this.allModules.get(name);
        if (module != null) {
            return module;
        }
        String moduleName = name.getLocalPart();
        String defaultModuleVersion = this.getDefaultModuleVersion(moduleName);
        if (defaultModuleVersion != null && (module = (AxisModule)this.allModules.get(Utils.getModuleName(moduleName, defaultModuleVersion))) != null) {
            return module;
        }
        return null;
    }

    public ClassLoader getModuleClassLoader() {
        return this.moduleClassLoader;
    }

    public ModuleConfiguration getModuleConfig(QName moduleName) {
        return (ModuleConfiguration)this.moduleConfigmap.get(moduleName);
    }

    public HashMap getModules() {
        return this.allModules;
    }

    public ArrayList getOutFaultFlow() {
        return this.outFaultPhases;
    }

    public PhasesInfo getPhasesInfo() {
        return this.phasesinfo;
    }

    public URL getRepository() {
        return this.axis2Repository;
    }

    public AxisService getService(String name) throws AxisFault {
        AxisService axisService = (AxisService)this.allservices.get(name);
        if (axisService != null) {
            if (axisService.isActive()) {
                return axisService;
            }
            throw new AxisFault(Messages.getMessage("serviceinactive", name));
        }
        return null;
    }

    public AxisService getServiceForActivation(String serviceName) {
        AxisService axisService = (AxisService)this.allservices.get(serviceName);
        if (axisService != null) {
            return axisService;
        }
        return null;
    }

    public ClassLoader getServiceClassLoader() {
        return this.serviceClassLoader;
    }

    public AxisServiceGroup getServiceGroup(String serviceNameAndGroupString) {
        return (AxisServiceGroup)this.getChild(serviceNameAndGroupString);
    }

    public Iterator getServiceGroups() {
        return this.getChildren();
    }

    public HashMap getServices() {
        Iterator sgs = this.getServiceGroups();
        while (sgs.hasNext()) {
            AxisServiceGroup axisServiceGroup = (AxisServiceGroup)sgs.next();
            Iterator servics = axisServiceGroup.getServices();
            while (servics.hasNext()) {
                AxisService axisService = (AxisService)servics.next();
                this.allservices.put(axisService.getName(), axisService);
            }
        }
        return this.allservices;
    }

    public ClassLoader getSystemClassLoader() {
        return this.systemClassLoader;
    }

    public TransportInDescription getTransportIn(QName name) throws AxisFault {
        return (TransportInDescription)this.transportsIn.get(name);
    }

    public TransportOutDescription getTransportOut(QName name) throws AxisFault {
        return (TransportOutDescription)this.transportsOut.get(name);
    }

    public HashMap getTransportsIn() {
        return this.transportsIn;
    }

    public HashMap getTransportsOut() {
        return this.transportsOut;
    }

    public boolean isEngaged(QName moduleName) {
        boolean b = this.engagedModules.contains(moduleName);
        return b ? b : this.engagedModules.contains(this.getDefaultModule(moduleName.getLocalPart()).getName());
    }

    public void setGlobalOutPhase(ArrayList outPhases) {
        this.outPhases = outPhases;
    }

    public void setInFaultPhases(ArrayList list) {
        this.inFaultPhases = list;
    }

    public void setInPhasesUptoAndIncludingPostDispatch(ArrayList inPhasesUptoAndIncludingPostDispatch) {
        this.inPhasesUptoAndIncludingPostDispatch = inPhasesUptoAndIncludingPostDispatch;
    }

    public void setModuleClassLoader(ClassLoader classLoader) {
        this.moduleClassLoader = classLoader;
    }

    public void setOutFaultPhases(ArrayList list) {
        this.outFaultPhases = list;
    }

    public void setPhasesInfo(PhasesInfo phasesInfo) {
        this.phasesinfo = phasesInfo;
    }

    public void setRepository(URL axis2Repository) {
        this.axis2Repository = axis2Repository;
    }

    public void setServiceClassLoader(ClassLoader classLoader) {
        this.serviceClassLoader = classLoader;
    }

    public void setSystemClassLoader(ClassLoader classLoader) {
        this.systemClassLoader = classLoader;
    }

    public void addDefaultModuleVersion(String moduleName, String moduleVersion) {
        if (this.nameToversionMap.get(moduleName) == null) {
            this.nameToversionMap.put(moduleName, moduleVersion);
        }
    }

    public String getDefaultModuleVersion(String moduleName) {
        return (String)this.nameToversionMap.get(moduleName);
    }

    public AxisModule getDefaultModule(String moduleName) {
        String defualtModuleVersion = this.getDefaultModuleVersion(moduleName);
        if (defualtModuleVersion == null) {
            return (AxisModule)this.allModules.get(new QName(moduleName));
        }
        return (AxisModule)this.allModules.get(new QName(moduleName + "-" + defualtModuleVersion));
    }

    public Object getKey() {
        return this.toString();
    }

    public void stopService(String serviceName) throws AxisFault {
        AxisService service = (AxisService)this.allservices.get(serviceName);
        if (service == null) {
            throw new AxisFault(Messages.getMessage("servicenamenotvalid", serviceName));
        }
        service.setActive(false);
        this.notifyObservers(2, service);
    }

    public void startService(String serviceName) throws AxisFault {
        AxisService service = (AxisService)this.allservices.get(serviceName);
        if (service == null) {
            throw new AxisFault(Messages.getMessage("servicenamenotvalid", serviceName));
        }
        service.setActive(true);
        this.notifyObservers(3, service);
    }

    public boolean isManageTransportSession() {
        return this.manageTransportSession;
    }

    public void setManageTransportSession(boolean manageTransportSession) {
        this.manageTransportSession = manageTransportSession;
    }

    public List getModulesForPolicyNamesapce(String namesapce) {
        return (List)this.policySupportedModules.get(namesapce);
    }

    public void registerModulePolicySupport(AxisModule axisModule) {
        String[] namespaces = axisModule.getSupportedPolicyNamespaces();
        if (namespaces == null) {
            return;
        }
        for (int i = 0; i < namespaces.length; ++i) {
            ArrayList<AxisModule> modulesList = (ArrayList<AxisModule>)this.policySupportedModules.get(namespaces[i]);
            if (modulesList != null) {
                modulesList.add(axisModule);
                continue;
            }
            modulesList = new ArrayList<AxisModule>();
            modulesList.add(axisModule);
            this.policySupportedModules.put(namespaces[i], modulesList);
        }
    }

    public void registerLocalPolicyAssertions(AxisModule axisModule) {
        QName[] localPolicyAssertions = axisModule.getLocalPolicyAssertions();
        if (localPolicyAssertions == null) {
            return;
        }
        for (int i = 0; i < localPolicyAssertions.length; ++i) {
            this.addLocalPolicyAssertion(localPolicyAssertions[i]);
        }
    }

    public ArrayList getObserversList() {
        return this.observersList;
    }

    public boolean isStart() {
        return this.start;
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    public TargetResolver getTargetResolverChain() {
        if (this.targetResolvers.isEmpty()) {
            return null;
        }
        return new TargetResolver(){

            public void resolveTarget(MessageContext messageContext) {
                Iterator iter = AxisConfiguration.this.targetResolvers.iterator();
                while (iter.hasNext()) {
                    TargetResolver tr = (TargetResolver)iter.next();
                    tr.resolveTarget(messageContext);
                }
            }
        };
    }

    public void addTargetResolver(TargetResolver tr) {
        this.targetResolvers.add(tr);
    }

    public void addLocalPolicyAssertion(QName name) {
        this.localPolicyAssertions.add(name);
    }

    public List getLocalPolicyAssertions() {
        return this.localPolicyAssertions;
    }

    public void removeLocalPolicyAssertion(QName name) {
        this.localPolicyAssertions.remove(name);
    }

    public boolean isAssertionLocal(QName name) {
        return this.localPolicyAssertions.contains(name);
    }
}

