/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class URLBasedAxisConfigurator
extends DeploymentEngine
implements AxisConfigurator {
    private static final Log log = LogFactory.getLog((Class)URLBasedAxisConfigurator.class);
    private URL axis2xml;
    private URL repositoy;

    public URLBasedAxisConfigurator(URL axis2xml, URL repositoy) throws AxisFault {
        this.axis2xml = axis2xml;
        this.repositoy = repositoy;
    }

    public AxisConfiguration getAxisConfiguration() throws AxisFault {
        try {
            InputStream axis2xmlStream;
            if (this.axis2xml == null) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                axis2xmlStream = cl.getResourceAsStream("org/apache/axis2/deployment/axis2_default.xml");
            } else {
                axis2xmlStream = this.axis2xml.openStream();
            }
            this.axisConfig = this.populateAxisConfiguration(axis2xmlStream);
            if (this.repositoy == null) {
                Parameter axis2repoPara = this.axisConfig.getParameter("repository");
                if (axis2repoPara != null) {
                    String repoValue = (String)axis2repoPara.getValue();
                    if (repoValue != null && !"".equals(repoValue.trim())) {
                        if (repoValue.startsWith("file://")) {
                            this.loadRepository(repoValue);
                        } else {
                            this.loadRepositoryFromURL(new URL(repoValue));
                        }
                    }
                } else {
                    log.info((Object)"No repository found , module will be loaded from classpath");
                    this.loadFromClassPath();
                }
            } else {
                this.loadRepositoryFromURL(this.repositoy);
            }
        }
        catch (IOException e) {
            throw new AxisFault(e.getMessage());
        }
        return this.axisConfig;
    }

    public void loadServices() {
        try {
            if (this.repositoy == null) {
                String repoValue;
                Parameter axis2repoPara = this.axisConfig.getParameter("repository");
                if (axis2repoPara != null && (repoValue = (String)axis2repoPara.getValue()) != null && !"".equals(repoValue.trim())) {
                    if (repoValue.startsWith("file://")) {
                        super.loadServices();
                    } else {
                        this.loadServicesFromUrl(new URL(repoValue));
                    }
                }
            } else {
                this.loadServicesFromUrl(this.repositoy);
            }
        }
        catch (MalformedURLException e) {
            log.info((Object)e);
        }
    }

    public void engageGlobalModules() throws AxisFault {
        this.engageModules();
    }
}

