/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import org.apache.axis2.deployment.DeploymentConstants;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.repository.util.ArchiveFileData;
import org.apache.axis2.deployment.repository.util.WSInfoList;
import org.apache.axis2.util.Loader;

public class RepositoryListener
implements DeploymentConstants {
    private DeploymentEngine deploymentEngine;
    private WSInfoList wsInfoList;

    public RepositoryListener(DeploymentEngine deploymentEngine, boolean isClasspath) {
        this.deploymentEngine = deploymentEngine;
        this.wsInfoList = new WSInfoList(deploymentEngine);
        if (!isClasspath) {
            this.init();
        }
        this.loadClassPathModules();
    }

    public void checkModules() {
        File root = this.deploymentEngine.getModulesDir();
        File[] files = root.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (this.isSourceControlDir(file)) continue;
                if (!file.isDirectory()) {
                    if (!ArchiveFileData.isModuleArchiveFile(file.getName())) continue;
                    this.wsInfoList.addWSInfoItem(file, 1);
                    continue;
                }
                if ("lib".equalsIgnoreCase(file.getName())) continue;
                this.wsInfoList.addWSInfoItem(file, 1);
            }
        }
    }

    private boolean isSourceControlDir(File file) {
        String name;
        return file.isDirectory() && ((name = file.getName()).equalsIgnoreCase("CVS") || name.equalsIgnoreCase(".svn"));
    }

    private void loadClassPathModules() {
        String classPath = this.getLocation();
        int lstindex = classPath.lastIndexOf(File.separatorChar);
        classPath = lstindex > 0 ? classPath.substring(0, lstindex) : ".";
        File root = new File(classPath);
        File[] files = root.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.isDirectory() || !ArchiveFileData.isModuleArchiveFile(file.getName())) continue;
                this.wsInfoList.addWSInfoItem(file, 1);
            }
        }
        for (ClassLoader cl = this.deploymentEngine.getAxisConfig().getModuleClassLoader(); cl != null; cl = cl.getParent()) {
            if (!(cl instanceof URLClassLoader)) continue;
            URL[] urls = ((URLClassLoader)cl).getURLs();
            for (int i = 0; urls != null && i < urls.length; ++i) {
                File file;
                String path = urls[i].getPath();
                if (path.length() >= 3 && path.charAt(0) == '/' && path.charAt(2) == ':') {
                    path = path.substring(1);
                }
                if (!(file = new File(URLDecoder.decode(urls[i].getPath()).replace('/', File.separatorChar).replace('|', ':'))).isFile() || !ArchiveFileData.isModuleArchiveFile(file.getName())) continue;
                this.wsInfoList.addWSInfoItem(file, 1);
            }
        }
        this.deploymentEngine.doDeploy();
    }

    private String getLocation() {
        try {
            Class clazz = Loader.loadClass("org.apache.axis2.engine.AxisEngine");
            URL url = clazz.getProtectionDomain().getCodeSource().getLocation();
            String location = url.toString();
            if (location.startsWith("jar")) {
                url = ((JarURLConnection)url.openConnection()).getJarFileURL();
                location = url.toString();
            }
            if (location.startsWith("file")) {
                File file = new File(URLDecoder.decode(url.getPath()).replace('/', File.separatorChar).replace('|', ':'));
                return file.getAbsolutePath();
            }
            return url.toString();
        }
        catch (Throwable t) {
            return "an unknown location";
        }
    }

    public void checkServices() {
        this.findServicesInDirectory();
        this.update();
    }

    public void init() {
        this.wsInfoList.init();
        this.checkModules();
        this.deploymentEngine.doDeploy();
    }

    private void findServicesInDirectory() {
        File root = this.deploymentEngine.getServicesDir();
        File[] files = root.listFiles();
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (this.isSourceControlDir(file)) continue;
                if (!file.isDirectory()) {
                    if (!ArchiveFileData.isServiceArchiveFile(file.getName())) continue;
                    this.wsInfoList.addWSInfoItem(file, 0);
                    continue;
                }
                if ("lib".equalsIgnoreCase(file.getName())) continue;
                this.wsInfoList.addWSInfoItem(file, 0);
            }
        }
        this.wsInfoList.addWSInfoItem(null, -1);
    }

    public void startListener() {
        this.checkServices();
        this.update();
    }

    public void update() {
        this.wsInfoList.update();
    }
}

