/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.axis2.description.PolicyInclude;
import org.apache.ws.policy.Policy;
import org.apache.ws.policy.util.PolicyFactory;
import org.apache.ws.policy.util.PolicyWriter;
import org.apache.ws.policy.util.StAXPolicyWriter;

public class PolicyUtil {
    public static void writePolicy(PolicyInclude policy, OutputStream out) {
        if (policy != null) {
            Policy pl = policy.getEffectivePolicy();
            if (pl != null) {
                PolicyWriter write = PolicyFactory.getPolicyWriter((int)2);
                write.writePolicy(pl, out);
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                PrintWriter write = new PrintWriter(out);
                write.write("<policy>no policy found</policy>");
                write.flush();
                write.close();
            }
        } else {
            PrintWriter write = new PrintWriter(out);
            write.write("<policy>no policy found</policy>");
            write.flush();
            write.close();
        }
    }

    public static String getPolicyAsString(Policy policy) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StAXPolicyWriter pwtr = (StAXPolicyWriter)PolicyFactory.getPolicyWriter((int)2);
        pwtr.writePolicy(policy, (OutputStream)baos);
        return PolicyUtil.getSafeString(baos.toString());
    }

    private static String getSafeString(String unsafeString) {
        StringBuffer sbuf = new StringBuffer();
        char[] chars = unsafeString.toCharArray();
        block6: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '\\': {
                    sbuf.append('\\');
                    sbuf.append('\\');
                    continue block6;
                }
                case '\"': {
                    sbuf.append('\\');
                    sbuf.append('\"');
                    continue block6;
                }
                case '\n': {
                    sbuf.append('\\');
                    sbuf.append('n');
                    continue block6;
                }
                case '\r': {
                    sbuf.append('\\');
                    sbuf.append('r');
                    continue block6;
                }
                default: {
                    sbuf.append(c);
                }
            }
        }
        return sbuf.toString();
    }
}

