/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.tcp;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.Socket;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TCPWorker
implements Runnable {
    private static final Log log = LogFactory.getLog((Class)TCPWorker.class);
    private ConfigurationContext configurationContext;
    private Socket socket;

    public TCPWorker(ConfigurationContext configurationContext, Socket socket) {
        this.configurationContext = configurationContext;
        this.socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        MessageContext msgContext = null;
        AxisEngine engine = new AxisEngine(this.configurationContext);
        AxisConfiguration axisConf = this.configurationContext.getAxisConfiguration();
        TransportOutDescription transportOut = axisConf.getTransportOut(new QName("tcp"));
        TransportInDescription transportIn = axisConf.getTransportIn(new QName("tcp"));
        if (transportOut == null || transportIn == null) throw new AxisFault(Messages.getMessage("unknownTransport", "tcp"));
        msgContext = new MessageContext();
        msgContext.setIncomingTransportName("tcp");
        msgContext.setConfigurationContext(this.configurationContext);
        msgContext.setTransportIn(transportIn);
        msgContext.setTransportOut(transportOut);
        msgContext.setServerSide(true);
        OutputStream out = this.socket.getOutputStream();
        msgContext.setProperty("TRANSPORT_OUT", out);
        InputStreamReader in = new InputStreamReader(this.socket.getInputStream());
        XMLStreamReader xmlreader = StAXUtils.createXMLStreamReader((Reader)in);
        StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(xmlreader, null);
        SOAPEnvelope envelope = (SOAPEnvelope)builder.getDocumentElement();
        msgContext.setEnvelope(envelope);
        if (envelope.getBody().hasFault()) {
            engine.receiveFault(msgContext);
        } else {
            engine.receive(msgContext);
        }
        Object var12_15 = null;
        if (this.socket == null) return;
        try {
            this.socket.close();
            return;
        }
        catch (IOException e1) {}
        return;
        {
            catch (Throwable e) {
                try {
                    AxisEngine engine2 = new AxisEngine(this.configurationContext);
                    if (msgContext != null) {
                        msgContext.setProperty("TRANSPORT_OUT", this.socket.getOutputStream());
                        MessageContext faultContext = engine2.createFaultMessageContext(msgContext, e);
                        engine2.sendFault(faultContext);
                    }
                }
                catch (Exception e1) {
                    log.error((Object)e);
                }
                Object var12_16 = null;
                if (this.socket == null) return;
                try {
                    this.socket.close();
                    return;
                }
                catch (IOException e1) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            if (this.socket == null) throw throwable;
            try {
                this.socket.close();
                throw throwable;
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

