/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.mail;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.AbstractTransportSender;
import org.apache.axis2.transport.mail.EMailSender;
import org.apache.axis2.util.Utils;

public class MailTransportSender
extends AbstractTransportSender {
    private static final long serialVersionUID = -2858556361961169381L;
    private String smtpPort = "25";
    private ByteArrayOutputStream byteArrayOutputStream;
    private String host;
    private String password;
    private String user;

    public void cleanup(MessageContext msgContext) throws AxisFault {
    }

    public void finalizeSendWithOutputStreamFromIncomingConnection(MessageContext msgContext, OutputStream out) throws AxisFault {
    }

    public void finalizeSendWithToAddress(MessageContext msgContext, OutputStream out) throws AxisFault {
        try {
            TransportOutDescription transportOut = msgContext.getTransportOut();
            this.user = Utils.getParameterValue(transportOut.getParameter("transport.mail.smtp.user"));
            this.host = Utils.getParameterValue(transportOut.getParameter("transport.mail.smtp.host"));
            this.password = Utils.getParameterValue(transportOut.getParameter("transport.mail.smtp.password"));
            this.smtpPort = Utils.getParameterValue(transportOut.getParameter("transport.mail.smtp.port"));
            if (this.user != null && this.host != null && this.password != null && this.smtpPort != null) {
                EMailSender sender = new EMailSender(this.user, this.host, this.smtpPort, this.password);
                String eprAddress = msgContext.getTo().getAddress();
                String charSet = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
                if (charSet == null) {
                    charSet = "us-ascii";
                }
                int index = eprAddress.indexOf(47);
                String subject = "";
                String email = null;
                if (index >= 0) {
                    subject = eprAddress.substring(index + 1);
                    email = eprAddress.substring(0, index);
                } else {
                    email = eprAddress;
                }
                int emailColon = email.indexOf(":");
                if (emailColon >= 0) {
                    email = email.substring(emailColon + 1);
                }
                sender.send(subject, email, new String(this.byteArrayOutputStream.toByteArray()), charSet);
            } else {
                if (this.user == null) {
                    throw new AxisFault(Messages.getMessage("canNotBeNull", "User"));
                }
                if (this.smtpPort == null) {
                    throw new AxisFault(Messages.getMessage("canNotBeNull", "smtpPort"));
                }
                if (this.host == null) {
                    throw new AxisFault(Messages.getMessage("canNotBeNull", "Host"));
                }
                if (this.password == null) {
                    throw new AxisFault(Messages.getMessage("canNotBeNull", "password"));
                }
            }
        }
        catch (IOException e) {
            throw new AxisFault(e);
        }
    }

    protected OutputStream openTheConnection(EndpointReference epr, MessageContext msgContext) throws AxisFault {
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        return this.byteArrayOutputStream;
    }

    public OutputStream startSendWithOutputStreamFromIncomingConnection(MessageContext msgContext, OutputStream out) throws AxisFault {
        throw new UnsupportedOperationException();
    }

    public OutputStream startSendWithToAddress(MessageContext msgContext, OutputStream out) throws AxisFault {
        return out;
    }

    public void writeMessage(MessageContext msgContext, OutputStream out) throws AxisFault {
        SOAPEnvelope envelope;
        SOAPEnvelope outputMessage = envelope = msgContext.getEnvelope();
        if (envelope != null && msgContext.isDoingREST()) {
            outputMessage = envelope.getBody().getFirstElement();
        }
        if (outputMessage != null) {
            try {
                OMOutputFormat format = new OMOutputFormat();
                format.setDoOptimize(msgContext.isDoingMTOM());
                format.setCharSetEncoding(null);
                outputMessage.serializeAndConsume(out, format);
                out.flush();
            }
            catch (Exception e) {
                throw new AxisFault(e);
            }
        } else {
            throw new AxisFault(Messages.getMessage("outMessageNull"));
        }
    }

    public void stop() {
    }
}

