/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.jms.JMSConnector;
import org.apache.axis2.transport.jms.JMSConnectorFactory;
import org.apache.axis2.transport.jms.JMSEndpoint;
import org.apache.axis2.transport.jms.JMSURLHelper;
import org.apache.axis2.transport.jms.JMSVendorAdapter;
import org.apache.axis2.transport.jms.JMSVendorAdapterFactory;
import org.apache.axis2.transport.jms.SimpleJMSWorker;
import org.apache.axis2.util.OptionsParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleJMSListener
implements MessageListener,
TransportListener {
    private static final Log log = LogFactory.getLog((Class)SimpleJMSListener.class);
    private boolean doThreads = true;
    protected ConfigurationContext configurationContext;
    private JMSConnector connector;
    private String destination;
    private JMSEndpoint endpoint;
    private HashMap properties;
    private String user = null;
    private String password = null;

    public SimpleJMSListener() {
    }

    public SimpleJMSListener(String repositoryDirectory, HashMap connectorMap, HashMap cfMap, String destination, String username, String password, boolean doThreads) throws Exception {
        File repo = new File(repositoryDirectory);
        if (!repo.exists()) {
            throw new Exception("repository not found");
        }
        this.configurationContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem(repositoryDirectory, repositoryDirectory + "/conf/axis2.xml");
        ListenerManager listenerManager = this.configurationContext.getListenerManager();
        TransportInDescription trsIn = new TransportInDescription(new QName("jms"));
        trsIn.setReceiver(this);
        if (listenerManager == null) {
            listenerManager = new ListenerManager();
            listenerManager.init(this.configurationContext);
        }
        listenerManager.addListener(trsIn, true);
        this.doThreads = doThreads;
        this.properties = new HashMap(connectorMap);
        this.properties.putAll(cfMap);
        this.destination = destination;
    }

    public static final HashMap createCFMap(OptionsParser optionsParser) throws IOException {
        String cfFile = optionsParser.isValueSet('c');
        if (cfFile == null) {
            return null;
        }
        Properties cfProps = new Properties();
        cfProps.load(new BufferedInputStream(new FileInputStream(cfFile)));
        HashMap<Object, Object> cfMap = new HashMap<Object, Object>(cfProps);
        return cfMap;
    }

    public static final HashMap createConnectorMap(OptionsParser optionsParser) {
        HashMap<String, String> connectorMap = new HashMap<String, String>();
        if (optionsParser.isFlagSet('t') > 0) {
            connectorMap.put("transport.jms.domain", "TOPIC");
        }
        return connectorMap;
    }

    public void init(ConfigurationContext axisConf, TransportInDescription transprtIn) throws AxisFault {
        try {
            this.configurationContext = axisConf;
            HashMap<String, Object> params = new HashMap<String, Object>();
            Iterator iterator = transprtIn.getParameters().iterator();
            while (iterator.hasNext()) {
                Parameter param = (Parameter)iterator.next();
                params.put(param.getName(), param.getValue());
            }
            if (transprtIn.getParameter("transport.jms.User") != null) {
                this.user = (String)transprtIn.getParameter("transport.jms.User").getValue();
            }
            if (transprtIn.getParameter("transport.jms.Password") != null) {
                this.password = (String)transprtIn.getParameter("transport.jms.Password").getValue();
            }
            if (transprtIn.getParameter("transport.jms.Destination") != null) {
                this.destination = (String)transprtIn.getParameter("transport.jms.Destination").getValue();
            }
            this.properties = new HashMap(params);
        }
        catch (Exception e1) {
            throw new AxisFault(e1);
        }
    }

    private void startListener() throws Exception {
        try {
            JMSVendorAdapter adapter = JMSVendorAdapterFactory.getJMSVendorAdapter();
            this.connector = JMSConnectorFactory.createServerConnector(this.properties, this.properties, this.user, this.password, adapter);
        }
        catch (Exception e) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
            throw e;
        }
        this.endpoint = this.connector.createEndpoint(this.destination);
    }

    public static void main(String[] args) throws Exception {
        OptionsParser optionsParser = new OptionsParser(args);
        if (optionsParser.isFlagSet('?') > 0 || optionsParser.isFlagSet('h') > 0) {
            SimpleJMSListener.printUsage();
        }
        SimpleJMSListener listener = new SimpleJMSListener(optionsParser.isValueSet('r'), SimpleJMSListener.createConnectorMap(optionsParser), SimpleJMSListener.createCFMap(optionsParser), optionsParser.isValueSet('d'), optionsParser.getUser(), optionsParser.getPassword(), optionsParser.isFlagSet('s') > 0);
        listener.start();
    }

    public void onMessage(Message message) {
        try {
            SimpleJMSWorker worker = new SimpleJMSWorker(this.configurationContext, this, (BytesMessage)message);
            if (this.doThreads) {
                Thread t = new Thread(worker);
                t.start();
            } else {
                worker.run();
            }
        }
        catch (ClassCastException cce) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)cce);
            cce.printStackTrace();
            return;
        }
    }

    public static void printUsage() {
        System.out.println("Usage: SimpleJMSListener [options]");
        System.out.println(" Opts: -? this message");
        System.out.println();
        System.out.println("       -r repository directory location");
        System.out.println("       -c connection factory properties filename");
        System.out.println("       -d destination");
        System.out.println("       -t topic [absence of -t indicates queue]");
        System.out.println();
        System.out.println("       -u username");
        System.out.println("       -w password");
        System.out.println();
        System.out.println("       -s single-threaded listener");
        System.out.println("          [absence of option => multithreaded]");
        System.exit(1);
    }

    public void start() {
        try {
            this.startListener();
            this.endpoint.registerListener(this, this.properties);
            this.connector.start();
        }
        catch (Exception e) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
            e.printStackTrace();
        }
    }

    public void stop() throws AxisFault {
        try {
            this.endpoint.unregisterListener(this);
            this.connector.stop();
            this.connector.shutdown();
        }
        catch (Exception e) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
            e.printStackTrace();
        }
    }

    public ConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }

    protected JMSConnector getConnector() {
        return this.connector;
    }

    public HashMap getProperties() {
        return this.properties;
    }

    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        try {
            JMSURLHelper url = new JMSURLHelper("jms:/" + this.destination);
            if (url != null && url.getProperties() != null && this.properties != null) {
                url.getProperties().putAll(this.properties);
                return new EndpointReference(url.getURLString());
            }
            return null;
        }
        catch (Exception e) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
            return null;
        }
    }
}

