/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.io.IOException;
import org.apache.axis2.transport.http.server.HttpRequestHandler;
import org.apache.axis2.transport.http.server.SimpleHttpServerConnection;
import org.apache.axis2.transport.http.server.SimpleRequest;
import org.apache.axis2.transport.http.server.SimpleResponse;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.BasicScheme;

public class ProxyAuthRequestHandler
implements HttpRequestHandler {
    public static final String PROXY_AUTH_RESP = "Proxy-Authorization";
    private Credentials credentials = null;
    private String realm = null;
    private boolean keepalive = true;

    public ProxyAuthRequestHandler(Credentials creds) {
        this(creds, null, true);
    }

    public ProxyAuthRequestHandler(Credentials creds, String realm) {
        this(creds, realm, true);
    }

    public ProxyAuthRequestHandler(Credentials creds, String realm, boolean keepalive) {
        if (creds == null) {
            throw new IllegalArgumentException("Credentials may not be null");
        }
        this.credentials = creds;
        this.keepalive = keepalive;
        this.realm = realm != null ? realm : "test";
    }

    private boolean checkAuthorization(Header clientAuth) {
        String expectedAuthString = BasicScheme.authenticate((UsernamePasswordCredentials)((UsernamePasswordCredentials)this.credentials), (String)"ISO-8859-1");
        return expectedAuthString.equals(clientAuth.getValue());
    }

    private SimpleResponse performBasicHandshake(SimpleHttpServerConnection conn, SimpleRequest request) {
        SimpleResponse response = new SimpleResponse();
        response.setStatusLine(request.getRequestLine().getHttpVersion(), 407);
        if (!request.getRequestLine().getMethod().equalsIgnoreCase("HEAD")) {
            response.setBodyString("unauthorized");
        }
        response.addHeader(new Header("Proxy-Authenticate", "basic realm=\"" + this.realm + "\""));
        if (this.keepalive) {
            response.addHeader(new Header("Proxy-Connection", "keep-alive"));
            conn.setKeepAlive(true);
        } else {
            response.addHeader(new Header("Proxy-Connection", "close"));
            conn.setKeepAlive(false);
        }
        return response;
    }

    public boolean processRequest(SimpleHttpServerConnection conn, SimpleRequest request) throws IOException {
        Header clientAuth = request.getFirstHeader(PROXY_AUTH_RESP);
        if (clientAuth != null && this.checkAuthorization(clientAuth)) {
            return false;
        }
        SimpleResponse response = this.performBasicHandshake(conn, request);
        request.getBodyBytes();
        conn.writeResponse(response);
        return true;
    }
}

