/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.deployment.WarBasedAxisConfigurator;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.transport.http.ListingAgent;
import org.apache.axis2.transport.http.ServletBasedOutTransportInfo;
import org.apache.axis2.transport.http.TransportHeaders;
import org.apache.axis2.util.UUIDGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AxisServlet
extends HttpServlet
implements TransportListener {
    private static final Log log = LogFactory.getLog((Class)AxisServlet.class);
    private static final long serialVersionUID = -2085869393709833372L;
    public static final String CONFIGURATION_CONTEXT = "CONFIGURATION_CONTEXT";
    public static final String SESSION_ID = "SessionId";
    protected transient ConfigurationContext configContext;
    protected transient AxisConfiguration axisConfiguration;
    protected transient ServletConfig servletConfig;
    private transient ListingAgent agent;

    protected MessageContext createAndSetInitialParamsToMsgCtxt(MessageContext msgContext, HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest) throws AxisFault {
        msgContext = new MessageContext();
        msgContext.setConfigurationContext(this.configContext);
        msgContext.setTransportIn(this.axisConfiguration.getTransportIn(new QName("http")));
        msgContext.setTransportOut(this.axisConfiguration.getTransportOut(new QName("http")));
        msgContext.setProperty("OutTransportInfo", new ServletBasedOutTransportInfo(httpServletResponse));
        msgContext.setProperty("REMOTE_ADDR", httpServletRequest.getRemoteAddr());
        msgContext.setProperty("TRANSPORT_HEADERS", this.getTransportHeaders(httpServletRequest));
        msgContext.setProperty(SESSION_ID, httpServletRequest.getSession().getId());
        msgContext.setProperty("TransportInURL", httpServletRequest.getRequestURL().toString());
        msgContext.setIncomingTransportName("http");
        msgContext.setProperty("HttpServletRequest", httpServletRequest);
        return msgContext;
    }

    public void destroy() {
        super.destroy();
        try {
            this.configContext.getListenerManager().stop();
        }
        catch (AxisFault axisFault) {
            log.info((Object)axisFault.getMessage());
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            this.agent.handle(req, resp);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        MessageContext msgContext = null;
        ServletOutputStream out = null;
        try {
            msgContext = this.createAndSetInitialParamsToMsgCtxt(msgContext, res, req);
            msgContext.setProperty("servletContext", this.servletConfig.getServletContext());
            out = res.getOutputStream();
            HTTPTransportUtils.processHTTPPostRequest(msgContext, (InputStream)req.getInputStream(), (OutputStream)out, req.getContentType(), req.getHeader("SOAPAction"), req.getRequestURL().toString());
            Object contextWritten = msgContext.getOperationContext().getProperty("CONTENT_WRITTEN");
            res.setContentType("text/xml; charset=" + msgContext.getProperty("CHARACTER_SET_ENCODING"));
            if (contextWritten == null || !"true".equals(contextWritten)) {
                res.setStatus(202);
            }
        }
        catch (AxisFault e) {
            if (msgContext != null) {
                try {
                    res.setStatus(500);
                    this.handleFault(msgContext, (OutputStream)out, e);
                }
                catch (AxisFault e2) {
                    log.info((Object)e.getMessage());
                }
            }
            throw new ServletException((Throwable)e);
        }
    }

    protected void handleFault(MessageContext msgContext, OutputStream out, AxisFault e) throws AxisFault {
        msgContext.setProperty("TRANSPORT_OUT", out);
        AxisEngine engine = new AxisEngine(this.configContext);
        MessageContext faultContext = engine.createFaultMessageContext(msgContext, e);
        engine.sendFault(faultContext);
    }

    public void init(ServletConfig config) throws ServletException {
        try {
            this.servletConfig = config;
            this.configContext = this.initConfigContext(config);
            this.axisConfiguration = this.configContext.getAxisConfiguration();
            config.getServletContext().setAttribute(CONFIGURATION_CONTEXT, (Object)this.configContext);
            ListenerManager listenerManager = new ListenerManager();
            listenerManager.init(this.configContext);
            TransportInDescription transportInDescription = new TransportInDescription(new QName("http"));
            transportInDescription.setReceiver(this);
            listenerManager.addListener(transportInDescription, true);
            ListenerManager.defaultConfigurationContext = this.configContext;
            this.agent = new ListingAgent(this.configContext);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void init() throws ServletException {
        if (this.servletConfig != null) {
            this.init(this.servletConfig);
        }
    }

    protected ConfigurationContext initConfigContext(ServletConfig config) throws ServletException {
        try {
            ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContext(new WarBasedAxisConfigurator(config));
            configContext.setProperty("ContainerManaged", "true");
            return configContext;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected HashMap getHTTPParameters(HttpServletRequest httpServletRequest) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration enu = httpServletRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            String value = httpServletRequest.getParameter(name);
            map.put(name, value);
        }
        return map;
    }

    protected Object getSessionContext(HttpServletRequest httpServletRequest) {
        Object sessionContext = httpServletRequest.getSession(true).getAttribute("SessionContext");
        if (sessionContext == null) {
            sessionContext = new SessionContext(null);
            httpServletRequest.getSession().setAttribute("SessionContext", sessionContext);
        }
        return sessionContext;
    }

    protected Map getTransportHeaders(HttpServletRequest req) {
        return new TransportHeaders(req);
    }

    public void init(ConfigurationContext axisConf, TransportInDescription transprtIn) throws AxisFault {
    }

    public void start() throws AxisFault {
    }

    public void stop() throws AxisFault {
    }

    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        String port = (String)this.configContext.getProperty("RUNNING_PORT");
        if (port == null) {
            port = "8080";
        }
        return new EndpointReference("http://" + ip + ":" + port + "/axis2/services/" + serviceName);
    }

    protected MessageContext createMessageContext(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        MessageContext msgContext = new MessageContext();
        String trsPrefix = req.getRequestURL().toString();
        int sepindex = trsPrefix.indexOf(58);
        if (sepindex >= 0) {
            trsPrefix = trsPrefix.substring(0, sepindex);
            msgContext.setIncomingTransportName(trsPrefix);
        } else {
            msgContext.setIncomingTransportName("http");
        }
        msgContext.setConfigurationContext(this.configContext);
        msgContext.setTransportIn(this.configContext.getAxisConfiguration().getTransportIn(new QName("http")));
        TransportOutDescription transportOut = this.configContext.getAxisConfiguration().getTransportOut(new QName("http"));
        msgContext.setTransportOut(transportOut);
        msgContext.setServerSide(true);
        String requestURI = req.getRequestURI();
        requestURI = requestURI.replaceFirst("rest", "services");
        msgContext.setTo(new EndpointReference(requestURI));
        msgContext.setProperty("OutTransportInfo", new ServletBasedOutTransportInfo(resp));
        msgContext.setProperty("TRANSPORT_HEADERS", this.getHeaders(req));
        msgContext.setServiceGroupContextId(UUIDGenerator.getUUID());
        return msgContext;
    }

    protected Map getHeaders(HttpServletRequest request) {
        HashMap<String, Object> headerMap = new HashMap<String, Object>();
        Enumeration e = request.getAttributeNames();
        while (e.hasMoreElements()) {
            String field = (String)e.nextElement();
            headerMap.put(field, request.getAttribute(field));
        }
        return headerMap;
    }
}

