/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.DescriptionConstants;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.ParameterIncludeImpl;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.i18n.Messages;

public abstract class AxisDescription
implements ParameterInclude,
DescriptionConstants {
    private AxisDescription parent = null;
    private ParameterInclude parameterInclude = new ParameterIncludeImpl();
    private PolicyInclude policyInclude = new PolicyInclude(this);
    private HashMap children = new HashMap();

    public void addParameter(Parameter param) throws AxisFault {
        if (param == null) {
            return;
        }
        if (this.isParameterLocked(param.getName())) {
            throw new AxisFault(Messages.getMessage("paramterlockedbyparent", param.getName()));
        }
        this.parameterInclude.addParameter(param);
    }

    public void removeParameter(Parameter param) throws AxisFault {
        this.parameterInclude.removeParameter(param);
    }

    public void deserializeParameters(OMElement parameterElement) throws AxisFault {
        this.parameterInclude.deserializeParameters(parameterElement);
    }

    public Parameter getParameter(String name) {
        Parameter parameter = this.parameterInclude.getParameter(name);
        if (parameter == null && this.parent != null) {
            return this.parent.getParameter(name);
        }
        return parameter;
    }

    public ArrayList getParameters() {
        return this.parameterInclude.getParameters();
    }

    public boolean isParameterLocked(String parameterName) {
        if (this.getParent() != null && this.getParent().isParameterLocked(parameterName)) {
            return true;
        }
        return this.getParameter(parameterName) != null && this.getParameter(parameterName).isLocked();
    }

    public void setParent(AxisDescription parent) {
        this.parent = parent;
    }

    public AxisDescription getParent() {
        return this.parent;
    }

    public void setPolicyInclude(PolicyInclude policyInclude) {
        this.policyInclude = policyInclude;
    }

    public PolicyInclude getPolicyInclude() {
        return this.policyInclude;
    }

    public void addChild(AxisDescription child) {
        this.children.put(child.getKey(), child);
    }

    public void addChild(Object key, AxisDescription child) {
        this.children.put(key, child);
    }

    public Iterator getChildren() {
        return this.children.values().iterator();
    }

    public AxisDescription getChild(Object key) {
        return (AxisDescription)this.children.get(key);
    }

    public void removeChild(Object key) {
        this.children.remove(key);
    }

    public abstract Object getKey();
}

