/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.ModuleConfiguration;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisObserver;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.engine.Phase;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.phaseresolver.PhaseException;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.TransportSender;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AxisConfigBuilder
extends DescriptionBuilder {
    protected static final Log log = LogFactory.getLog((Class)AxisConfigBuilder.class);
    private DeploymentEngine engine;

    public AxisConfigBuilder(InputStream serviceInputStream, DeploymentEngine engine, AxisConfiguration axisConfiguration) {
        super(serviceInputStream, axisConfiguration);
        this.engine = engine;
    }

    public void populateConfig() throws DeploymentException {
        try {
            OMElement defaultModuleVerionElement;
            Iterator policyRefElements;
            OMElement config_element = this.buildOM();
            Iterator itr = config_element.getChildrenWithName(new QName("parameter"));
            this.processParameters(itr, this.axisConfig, this.axisConfig);
            OMElement messageReceiver = config_element.getFirstChildWithName(new QName("messageReceivers"));
            if (messageReceiver != null) {
                HashMap mrs = this.processMessageReceivers(messageReceiver);
                Iterator keys = mrs.keySet().iterator();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    this.axisConfig.addMessageReceiver(key, (MessageReceiver)mrs.get(key));
                }
            }
            Iterator moduleitr = config_element.getChildrenWithName(new QName("module"));
            this.processModuleRefs(moduleitr);
            Iterator trs_senders = config_element.getChildrenWithName(new QName("transportSender"));
            this.processTransportSenders(trs_senders);
            Iterator trs_Reivers = config_element.getChildrenWithName(new QName("transportReceiver"));
            this.processTransportReceivers(trs_Reivers);
            Iterator obs_ittr = config_element.getChildrenWithName(new QName("listener"));
            this.processObservers(obs_ittr);
            Iterator phaseorders = config_element.getChildrenWithName(new QName("phaseOrder"));
            this.processPhaseOrders(phaseorders);
            Iterator moduleConfigs = config_element.getChildrenWithName(new QName("moduleConfig"));
            this.processModuleConfig(moduleConfigs, this.axisConfig, this.axisConfig);
            Iterator policyElements = config_element.getChildrenWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "Policy"));
            if (policyElements != null) {
                this.processPolicyElements(1, policyElements, this.axisConfig.getPolicyInclude());
            }
            if ((policyRefElements = config_element.getChildrenWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "PolicyReference"))) != null) {
                this.processPolicyRefElements(1, policyElements, this.axisConfig.getPolicyInclude());
            }
            if ((defaultModuleVerionElement = config_element.getFirstChildWithName(new QName("defaultModuleVersions"))) != null) {
                this.processDefaultModuleVersions(defaultModuleVerionElement);
            }
        }
        catch (XMLStreamException e) {
            throw new DeploymentException(e);
        }
    }

    protected void processModuleConfig(Iterator moduleConfigs, ParameterInclude parent, AxisConfiguration config) throws DeploymentException {
        while (moduleConfigs.hasNext()) {
            OMElement moduleConfig = (OMElement)moduleConfigs.next();
            OMAttribute moduleName_att = moduleConfig.getAttribute(new QName("name"));
            if (moduleName_att == null) {
                throw new DeploymentException(Messages.getMessage("invalidmoduleconfig"));
            }
            String module = moduleName_att.getAttributeValue();
            ModuleConfiguration moduleConfiguration = new ModuleConfiguration(new QName(module), parent);
            Iterator parameters = moduleConfig.getChildrenWithName(new QName("parameter"));
            this.processParameters(parameters, moduleConfiguration, parent);
            config.addModuleConfig(moduleConfiguration);
        }
    }

    protected void processModuleRefs(Iterator moduleRefs) {
        while (moduleRefs.hasNext()) {
            OMElement moduleref = (OMElement)moduleRefs.next();
            OMAttribute moduleRefAttribute = moduleref.getAttribute(new QName("ref"));
            String refName = moduleRefAttribute.getAttributeValue();
            this.engine.addModule(new QName(refName));
        }
    }

    private void processObservers(Iterator oservers) {
        while (oservers.hasNext()) {
            try {
                OMElement observerelement = (OMElement)oservers.next();
                OMAttribute trsClas = observerelement.getAttribute(new QName("class"));
                if (trsClas == null) {
                    log.info((Object)Messages.getMessage("obsererror"));
                    return;
                }
                String clasName = trsClas.getAttributeValue();
                Class<?> observerclass = Class.forName(clasName, true, Thread.currentThread().getContextClassLoader());
                AxisObserver observer = (AxisObserver)observerclass.newInstance();
                Iterator itr = observerelement.getChildrenWithName(new QName("parameter"));
                this.processParameters(itr, observer, this.axisConfig);
                observer.init(this.axisConfig);
                this.axisConfig.addObservers(observer);
            }
            catch (Exception e) {
                log.info((Object)e.getMessage());
            }
        }
    }

    private ArrayList processPhaseList(OMElement phaseOrders) throws DeploymentException {
        ArrayList<Phase> phaselist = new ArrayList<Phase>();
        Iterator phases = phaseOrders.getChildrenWithName(new QName("phase"));
        while (phases.hasNext()) {
            Phase phase;
            OMElement phaseelement = (OMElement)phases.next();
            String phaseName = phaseelement.getAttribute(new QName("name")).getAttributeValue();
            String phaseClass = phaseelement.getAttributeValue(new QName("class"));
            try {
                phase = this.getPhase(phaseClass);
            }
            catch (Exception e) {
                throw new DeploymentException(Messages.getMessage("phaseclassnotfound", phaseClass, e.getMessage()));
            }
            phase.setName(phaseName);
            Iterator handlers = phaseelement.getChildrenWithName(new QName("handler"));
            while (handlers.hasNext()) {
                OMElement omElement = (OMElement)handlers.next();
                HandlerDescription handler = this.processHandler(omElement, this.axisConfig);
                handler.getRules().setPhaseName(phaseName);
                Utils.loadHandler(this.axisConfig.getSystemClassLoader(), handler);
                try {
                    phase.addHandler(handler);
                }
                catch (PhaseException e) {
                    throw new DeploymentException(e);
                }
            }
            phaselist.add(phase);
        }
        return phaselist;
    }

    private void processPhaseOrders(Iterator phaserders) throws DeploymentException {
        PhasesInfo info = this.engine.getPhasesinfo();
        while (phaserders.hasNext()) {
            OMElement phaseOrders = (OMElement)phaserders.next();
            String flowType = phaseOrders.getAttribute(new QName("type")).getAttributeValue();
            if ("inflow".equals(flowType)) {
                info.setINPhases(this.processPhaseList(phaseOrders));
                continue;
            }
            if ("INfaultflow".equals(flowType)) {
                info.setIN_FaultPhases(this.processPhaseList(phaseOrders));
                continue;
            }
            if ("outflow".equals(flowType)) {
                info.setOUTPhases(this.processPhaseList(phaseOrders));
                continue;
            }
            if (!"Outfaultflow".equals(flowType)) continue;
            info.setOUT_FaultPhases(this.processPhaseList(phaseOrders));
        }
    }

    private void processDefaultModuleVersions(OMElement defaultVersions) throws DeploymentException {
        Iterator moduleVersions = defaultVersions.getChildrenWithName(new QName("module"));
        while (moduleVersions.hasNext()) {
            OMElement omElement = (OMElement)moduleVersions.next();
            String name = omElement.getAttributeValue(new QName("name"));
            if (name == null) {
                throw new DeploymentException(Messages.getMessage("modulenamecannotnull"));
            }
            String defaultVeriosn = omElement.getAttributeValue(new QName("version"));
            if (defaultVeriosn == null) {
                throw new DeploymentException(Messages.getMessage("modulenamecannotnull"));
            }
            this.axisConfig.addDefaultModuleVersion(name, defaultVeriosn);
        }
    }

    private void processTransportReceivers(Iterator trs_senders) throws DeploymentException {
        while (trs_senders.hasNext()) {
            OMElement transport = (OMElement)trs_senders.next();
            OMAttribute trsName = transport.getAttribute(new QName("name"));
            if (trsName == null) continue;
            String name = trsName.getAttributeValue();
            TransportInDescription transportIN = new TransportInDescription(new QName(name));
            OMAttribute trsClas = transport.getAttribute(new QName("class"));
            if (trsClas != null) {
                try {
                    String clasName = trsClas.getAttributeValue();
                    Class<?> receiverClass = Class.forName(clasName, true, Thread.currentThread().getContextClassLoader());
                    TransportListener receiver = (TransportListener)receiverClass.newInstance();
                    transportIN.setReceiver(receiver);
                }
                catch (NoClassDefFoundError e) {
                    log.info((Object)Messages.getMessage("classnotfound", trsClas.getAttributeValue()));
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentException(e);
                }
                catch (IllegalAccessException e) {
                    throw new DeploymentException(e);
                }
                catch (InstantiationException e) {
                    throw new DeploymentException(e);
                }
            }
            try {
                Iterator itr = transport.getChildrenWithName(new QName("parameter"));
                this.processParameters(itr, transportIN, this.axisConfig);
                this.axisConfig.addTransportIn(transportIN);
            }
            catch (AxisFault axisFault) {
                throw new DeploymentException(axisFault);
            }
        }
    }

    private void processTransportSenders(Iterator trs_senders) throws DeploymentException {
        while (trs_senders.hasNext()) {
            OMElement transport = (OMElement)trs_senders.next();
            OMAttribute trsName = transport.getAttribute(new QName("name"));
            if (trsName == null) continue;
            String name = trsName.getAttributeValue();
            TransportOutDescription transportout = new TransportOutDescription(new QName(name));
            OMAttribute trsClas = transport.getAttribute(new QName("class"));
            if (trsClas == null) {
                throw new DeploymentException(Messages.getMessage("transportSenderError", name));
            }
            String clasName = trsClas.getAttributeValue();
            try {
                Class<?> sender = Class.forName(clasName, true, Thread.currentThread().getContextClassLoader());
                TransportSender transportSender = (TransportSender)sender.newInstance();
                transportout.setSender(transportSender);
                Iterator itr = transport.getChildrenWithName(new QName("parameter"));
                this.processParameters(itr, transportout, this.axisConfig);
                this.axisConfig.addTransportOut(transportout);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException(e);
            }
            catch (IllegalAccessException e) {
                throw new DeploymentException(e);
            }
            catch (InstantiationException e) {
                throw new DeploymentException(e);
            }
            catch (AxisFault axisFault) {
                throw new DeploymentException(axisFault);
            }
        }
    }

    private Phase getPhase(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (className == null) {
            return new Phase();
        }
        Class<?> phaseClass = this.axisConfig.getSystemClassLoader().loadClass(className);
        return (Phase)phaseClass.newInstance();
    }
}

