/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context;

import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.DependencyManager;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.SessionUtils;
import org.apache.axis2.util.UUIDGenerator;
import org.apache.axis2.util.threadpool.ThreadFactory;
import org.apache.axis2.util.threadpool.ThreadPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationContext
extends AbstractContext {
    private static final Log log = LogFactory.getLog((Class)ConfigurationContext.class);
    private final Map operationContextMap = new HashMap();
    private Hashtable serviceGroupContextMap = new Hashtable();
    private Hashtable applicationSessionServiceGroupContextTable = new Hashtable();
    private transient AxisConfiguration axisConfiguration;
    private File rootDir;
    private transient ThreadFactory threadPool;
    private ListenerManager listenerManager;
    private long serviceGroupContextTimoutInterval = 30000L;

    public ConfigurationContext(AxisConfiguration axisConfiguration) {
        super(null);
        this.axisConfiguration = axisConfiguration;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    /*
     * WARNING - void declaration
     */
    public void fillServiceContextAndServiceGroupContext(MessageContext messageContext) throws AxisFault {
        String serviceGroupContextId = messageContext.getServiceGroupContextId();
        SessionContext sessionContext = messageContext.getSessionContext();
        ServiceContext serviceContext = messageContext.getServiceContext();
        AxisService axisService = messageContext.getAxisService();
        if (serviceContext == null) {
            void var4_6;
            AxisServiceGroup axisServiceGroup;
            ServiceGroupContext serviceGroupContext;
            if ("application".equals(axisService.getScope())) {
                serviceGroupContext = (ServiceGroupContext)this.applicationSessionServiceGroupContextTable.get(((AxisServiceGroup)axisService.getParent()).getServiceGroupName());
                if (serviceGroupContext == null) {
                    axisServiceGroup = messageContext.getAxisServiceGroup();
                    if (axisServiceGroup == null) {
                        axisServiceGroup = (AxisServiceGroup)messageContext.getAxisService().getParent();
                    }
                    serviceGroupContext = new ServiceGroupContext(messageContext.getConfigurationContext(), axisServiceGroup);
                }
                serviceContext = serviceGroupContext.getServiceContext(axisService);
            } else if (!this.isNull(serviceGroupContextId) && this.getServiceGroupContext(serviceGroupContextId, messageContext) != null) {
                serviceGroupContext = this.getServiceGroupContext(serviceGroupContextId, messageContext);
                serviceContext = serviceGroupContext.getServiceContext(messageContext.getAxisService());
            } else {
                if (this.isNull(serviceGroupContextId)) {
                    serviceGroupContextId = UUIDGenerator.getUUID();
                    messageContext.setServiceGroupContextId(serviceGroupContextId);
                }
                if (messageContext.getAxisService() != null) {
                    axisServiceGroup = (AxisServiceGroup)messageContext.getAxisService().getParent();
                    serviceGroupContext = new ServiceGroupContext(this, axisServiceGroup);
                    serviceContext = serviceGroupContext.getServiceContext(messageContext.getAxisService());
                    serviceGroupContext.setId(serviceGroupContextId);
                } else {
                    throw new AxisFault(Messages.getMessage("servicenotfound"));
                }
            }
            String maxScope = SessionUtils.calculateMaxScopeForServiceGroup(var4_6.getDescription());
            if ("application".equals(maxScope)) {
                this.addServiceGroupContextintoApplicatoionScopeTable((ServiceGroupContext)var4_6);
            } else if ("soapsession".equals(maxScope)) {
                this.registerServiceGroupContext((ServiceGroupContext)var4_6);
            } else if ("transportsession".equals(maxScope)) {
                sessionContext.addServiceGroupContext((ServiceGroupContext)var4_6, serviceGroupContextId);
                sessionContext.addServiceContext(serviceContext);
            }
            messageContext.setServiceContext(serviceContext);
            if ("request".equals(maxScope)) {
                messageContext.setServiceGroupContextId(null);
            } else {
                messageContext.setServiceGroupContext((ServiceGroupContext)var4_6);
            }
        }
        if (sessionContext != null) {
            serviceContext.setProperty("Cookie", sessionContext.getCookieID());
        }
        messageContext.getOperationContext().setParent(serviceContext);
    }

    public synchronized void registerOperationContext(String messageID, OperationContext mepContext) {
        this.operationContextMap.put(messageID, mepContext);
    }

    public synchronized void registerServiceGroupContext(ServiceGroupContext serviceGroupContext) {
        String id = serviceGroupContext.getId();
        if (this.serviceGroupContextMap.get(id) == null) {
            this.serviceGroupContextMap.put(id, serviceGroupContext);
            serviceGroupContext.touch();
            serviceGroupContext.setParent(this);
        }
        this.cleanupServiceGroupContexts();
    }

    private synchronized void addServiceGroupContextintoApplicatoionScopeTable(ServiceGroupContext serviceGroupContext) {
        this.applicationSessionServiceGroupContextTable.put(serviceGroupContext.getDescription().getServiceGroupName(), serviceGroupContext);
    }

    public AxisConfiguration getAxisConfiguration() {
        return this.axisConfiguration;
    }

    public OperationContext getOperationContext(String messageID) {
        return (OperationContext)this.operationContextMap.get(messageID);
    }

    public Map getOperationContextMap() {
        return this.operationContextMap;
    }

    public File getRealPath(String path) {
        if (this.rootDir == null) {
            return new File(path);
        }
        return new File(this.rootDir, path);
    }

    public synchronized ServiceGroupContext getServiceGroupContext(String serviceGroupContextId, MessageContext msgContext) {
        AxisServiceGroup asg;
        AxisService axisService;
        ServiceGroupContext serviceGroupContext = null;
        if (this.serviceGroupContextMap != null && (serviceGroupContext = (ServiceGroupContext)this.serviceGroupContextMap.get(serviceGroupContextId)) != null) {
            serviceGroupContext.touch();
        }
        if (serviceGroupContext == null && msgContext != null && msgContext.getSessionContext() != null) {
            serviceGroupContext = msgContext.getSessionContext().getServiceGroupContext(serviceGroupContextId);
        }
        if (serviceGroupContext == null && msgContext != null && (axisService = msgContext.getAxisService()) != null && (asg = (AxisServiceGroup)axisService.getParent()) != null) {
            serviceGroupContext = (ServiceGroupContext)this.applicationSessionServiceGroupContextTable.get(asg.getServiceGroupName());
        }
        return serviceGroupContext;
    }

    public Hashtable getServiceGroupContexts() {
        return this.serviceGroupContextMap;
    }

    public ThreadFactory getThreadPool() {
        if (this.threadPool == null) {
            this.threadPool = new ThreadPool();
        }
        return this.threadPool;
    }

    private boolean isNull(String string) {
        return "".equals(string) || string == null;
    }

    public void setAxisConfiguration(AxisConfiguration configuration) {
        this.axisConfiguration = configuration;
    }

    public void setRootDir(File file) {
        this.rootDir = file;
    }

    public void setThreadPool(ThreadFactory pool) throws AxisFault {
        if (this.threadPool != null) {
            throw new AxisFault(Messages.getMessage("threadpoolset"));
        }
        this.threadPool = pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupServiceGroupContexts() {
        Hashtable hashtable = this.serviceGroupContextMap;
        synchronized (hashtable) {
            long currentTime = new Date().getTime();
            Iterator sgCtxtMapKeyIter = this.serviceGroupContextMap.keySet().iterator();
            while (sgCtxtMapKeyIter.hasNext()) {
                String sgCtxtId = (String)sgCtxtMapKeyIter.next();
                ServiceGroupContext serviceGroupContext = (ServiceGroupContext)this.serviceGroupContextMap.get(sgCtxtId);
                if (currentTime - serviceGroupContext.getLastTouchedTime() <= this.serviceGroupContextTimoutInterval) continue;
                sgCtxtMapKeyIter.remove();
                this.cleanupServiceContextes(serviceGroupContext);
            }
        }
    }

    public ListenerManager getListenerManager() {
        return this.listenerManager;
    }

    public void setTransportManager(ListenerManager listenerManager) {
        this.listenerManager = listenerManager;
    }

    private void cleanupServiceContextes(ServiceGroupContext serviceGroupContext) {
        Iterator serviceContecxtes = serviceGroupContext.getServiceContexts();
        while (serviceContecxtes.hasNext()) {
            ServiceContext serviceContext = (ServiceContext)serviceContecxtes.next();
            try {
                DependencyManager.destroyServiceClass(serviceContext);
            }
            catch (AxisFault axisFault) {
                log.info((Object)axisFault.getMessage());
            }
        }
    }

    public void cleanupContexts() {
        ServiceGroupContext serviceGroupContext;
        if (this.applicationSessionServiceGroupContextTable.size() > 0) {
            Iterator applicationScopeSgs = this.applicationSessionServiceGroupContextTable.values().iterator();
            while (applicationScopeSgs.hasNext()) {
                serviceGroupContext = (ServiceGroupContext)applicationScopeSgs.next();
                this.cleanupServiceContextes(serviceGroupContext);
            }
        }
        if (this.serviceGroupContextMap.size() > 0) {
            Iterator sopaSessionSgs = this.serviceGroupContextMap.values().iterator();
            while (sopaSessionSgs.hasNext()) {
                serviceGroupContext = (ServiceGroupContext)sopaSessionSgs.next();
                this.cleanupServiceContextes(serviceGroupContext);
            }
        }
    }
}

