/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.addressing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;

public class EndpointReference
implements Serializable {
    private static final long serialVersionUID = 5278892171162372439L;
    private String name;
    private String address;
    private ArrayList metaData;
    private Map referenceParameters;
    private ArrayList extensibleElements;
    private ArrayList attributes;

    public EndpointReference(String address) {
        this.address = address;
    }

    public void addReferenceParameter(OMElement omElement) {
        if (omElement == null) {
            return;
        }
        if (this.referenceParameters == null) {
            this.referenceParameters = new HashMap();
        }
        this.referenceParameters.put(omElement.getQName(), omElement);
    }

    public void addReferenceParameter(QName qname, String value) {
        if (qname == null) {
            return;
        }
        OMElement omElement = OMAbstractFactory.getOMFactory().createOMElement(qname, null);
        omElement.setText(value);
        this.addReferenceParameter(omElement);
    }

    public Map getAllReferenceParameters() {
        return this.referenceParameters;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void addAttribute(String localName, OMNamespace ns, String value) {
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        this.attributes.add(OMAbstractFactory.getOMFactory().createOMAttribute(localName, ns, value));
    }

    public ArrayList getAttributes() {
        return this.attributes;
    }

    public void addAttribute(OMAttribute omAttribute) {
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        this.attributes.add(omAttribute);
    }

    public ArrayList getExtensibleElements() {
        return this.extensibleElements;
    }

    public void setExtensibleElements(ArrayList extensibleElements) {
        this.extensibleElements = extensibleElements;
    }

    public void addExtensibleElement(OMElement extensibleElement) {
        if (extensibleElement != null) {
            if (this.extensibleElements == null) {
                this.extensibleElements = new ArrayList();
            }
            this.extensibleElements.add(extensibleElement);
        }
    }

    public ArrayList getMetaData() {
        return this.metaData;
    }

    public void addMetaData(OMNode metaData) {
        if (metaData != null) {
            if (this.metaData == null) {
                this.metaData = new ArrayList();
            }
            this.metaData.add(metaData);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReferenceParameters(Map referenceParameters) {
        this.referenceParameters = referenceParameters;
    }

    public void fromOM(OMElement eprOMElement) {
        this.setAddress(eprOMElement.getFirstChildWithName(new QName("Address")).getText());
        Iterator refParams = eprOMElement.getChildrenWithName(new QName("ReferenceParameters"));
        while (refParams.hasNext()) {
            OMElement omElement = (OMElement)refParams.next();
            this.addReferenceParameter(omElement);
        }
        OMElement metaDataElement = eprOMElement.getFirstChildWithName(new QName("MetaData"));
        if (metaDataElement != null) {
            Iterator children = metaDataElement.getChildren();
            while (children.hasNext()) {
                OMNode omNode = (OMNode)children.next();
                this.addMetaData(omNode);
            }
        }
        this.setName(eprOMElement.getLocalName());
        Iterator allAttributes = eprOMElement.getAllAttributes();
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        while (allAttributes.hasNext()) {
            OMAttribute attribute = (OMAttribute)allAttributes.next();
            this.attributes.add(attribute);
        }
    }

    public void toOM() {
        throw new UnsupportedOperationException("Yet to be implemented !!");
    }

    public OMElement toOM(String nsurl, String localName, String prefix) throws AxisFault {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        if (prefix != null) {
            OMNamespace wrapNs = fac.createOMNamespace(nsurl, prefix);
            OMElement epr = fac.createOMElement(localName, wrapNs);
            OMNamespace wsans = fac.createOMNamespace("http://www.w3.org/2005/08/addressing", "wsa");
            OMElement addressE = fac.createOMElement("Address", wsans, (OMContainer)epr);
            addressE.setText(this.address);
            OMElement metadataE = fac.createOMElement("Metadata", wsans, (OMContainer)epr);
            if (this.metaData != null) {
                Iterator metadata = this.metaData.iterator();
                while (metadata.hasNext()) {
                    metadataE.addChild((OMNode)metadata.next());
                }
            }
            if (this.referenceParameters != null) {
                Iterator refParms = this.referenceParameters.values().iterator();
                while (refParms.hasNext()) {
                    metadataE.addChild((OMNode)refParms.next());
                }
            }
            return epr;
        }
        throw new AxisFault("prefix must ne specified");
    }
}

