/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen.extension;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.codegen.extension.AbstractDBProcessingExtension;
import org.apache.axis2.wsdl.databinding.DefaultTypeMapper;
import org.apache.axis2.wsdl.databinding.JavaTypeMapper;
import org.apache.axis2.wsdl.databinding.TypeMapper;
import org.apache.axis2.wsdl.i18n.CodegenMessages;
import org.apache.axis2.wsdl.util.ConfigPropertyFileLoader;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.jaxme.generator.SchemaReader;
import org.apache.ws.jaxme.generator.impl.GeneratorImpl;
import org.apache.ws.jaxme.generator.sg.GroupSG;
import org.apache.ws.jaxme.generator.sg.ObjectSG;
import org.apache.ws.jaxme.generator.sg.SchemaSG;
import org.apache.ws.jaxme.generator.sg.TypeSG;
import org.apache.ws.jaxme.generator.sg.impl.JAXBSchemaReader;
import org.apache.ws.jaxme.js.JavaQName;
import org.apache.ws.jaxme.xs.xml.XsQName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class JaxMeExtension
extends AbstractDBProcessingExtension {
    public static final String SCHEMA_FOLDER = "schemas";
    public static String MAPPINGS = "mappings";
    public static String MAPPING = "mapping";
    public static String MESSAGE = "message";
    public static String JAVA_NAME = "javaclass";
    public static final String MAPPING_FOLDER = "Mapping";
    public static final String MAPPER_FILE_NAME = "mapper";
    public static final String SCHEMA_PATH = "/org/apache/axis2/wsdl/codegen/schema/";
    boolean debug = false;

    public void engage(CodeGenConfiguration configuration) {
        if (this.testFallThrough(configuration.getDatabindingType())) {
            return;
        }
        try {
            ArrayList typesList = configuration.getAxisService().getSchema();
            if (typesList == null || typesList.isEmpty()) {
                configuration.setTypeMapper(new DefaultTypeMapper());
                return;
            }
            Vector<InputSource> xmlObjectsVector = new Vector<InputSource>();
            TypeMapper mapper = configuration.getTypeMapper();
            if (mapper == null) {
                mapper = new JavaTypeMapper();
            }
            for (int i = 0; i < typesList.size(); ++i) {
                XmlSchema schema = (XmlSchema)typesList.get(i);
                xmlObjectsVector.add(new InputSource(new StringReader(this.getSchemaAsString(schema))));
            }
            File outputDir = new File(configuration.getOutputLocation(), configuration.getSourceLocation());
            JAXBSchemaReader reader = new JAXBSchemaReader();
            reader.setSupportingExtensions(true);
            GeneratorImpl generator = new GeneratorImpl();
            generator.setTargetDirectory(outputDir);
            generator.setForcingOverwrite(false);
            generator.setSchemaReader((SchemaReader)reader);
            for (int i = 0; i < xmlObjectsVector.size(); ++i) {
                SchemaSG sg = generator.generate((InputSource)xmlObjectsVector.elementAt(i));
                ObjectSG[] elements = sg.getElements();
                for (int j = 0; j < elements.length; ++j) {
                    XsQName qName = elements[j].getName();
                    JavaQName name = elements[j].getClassContext().getXMLInterfaceName();
                    mapper.addTypeMappingName(new QName(qName.getNamespaceURI(), qName.getLocalName()), name.getPackageName() + '.' + name.getClassName());
                }
                TypeSG[] types = sg.getTypes();
                for (int j = 0; j < types.length; ++j) {
                    XsQName qName = types[j].getName();
                    JavaQName name = types[j].getRuntimeType();
                    mapper.addTypeMappingName(new QName(qName.getNamespaceURI(), qName.getLocalName()), name.getPackageName() + '.' + name.getClassName());
                }
                GroupSG[] groups = sg.getGroups();
                for (int j = 0; j < groups.length; ++j) {
                    XsQName qName = groups[j].getName();
                    JavaQName name = groups[j].getClassContext().getXMLInterfaceName();
                    mapper.addTypeMappingName(new QName(qName.getNamespaceURI(), qName.getLocalName()), name.getPackageName() + '.' + name.getClassName());
                }
            }
            configuration.setTypeMapper(mapper);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Element[] loadAdditionalSchemas() {
        Element[] schemaElements;
        String[] schemaNames = ConfigPropertyFileLoader.getThirdPartySchemaNames();
        try {
            int i;
            ArrayList<Element> additionalSchemaElements = new ArrayList<Element>();
            DocumentBuilder documentBuilder = this.getNamespaceAwareDocumentBuilder();
            for (i = 0; i < schemaNames.length; ++i) {
                if ("".equals(schemaNames[i].trim())) continue;
                InputStream schemaStream = this.getClass().getResourceAsStream(SCHEMA_PATH + schemaNames[i]);
                Document doc = documentBuilder.parse(schemaStream);
                additionalSchemaElements.add(doc.getDocumentElement());
            }
            schemaElements = new Element[additionalSchemaElements.size()];
            for (i = 0; i < additionalSchemaElements.size(); ++i) {
                schemaElements[i] = (Element)additionalSchemaElements.get(i);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(CodegenMessages.getMessage("extension.additionalSchemaFailure"), e);
        }
        return schemaElements;
    }

    private DocumentBuilder getNamespaceAwareDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        return documentBuilderFactory.newDocumentBuilder();
    }

    private String getSchemaAsString(XmlSchema schema) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        schema.write((OutputStream)baos);
        return baos.toString();
    }
}

