/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen.extension;

import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.modules.Module;
import org.apache.axis2.modules.ModulePolicyExtension;
import org.apache.axis2.modules.PolicyExtension;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.codegen.extension.CodeGenExtension;
import org.apache.ws.policy.AndCompositeAssertion;
import org.apache.ws.policy.Assertion;
import org.apache.ws.policy.Policy;
import org.apache.ws.policy.PrimitiveAssertion;
import org.apache.ws.policy.XorCompositeAssertion;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PolicyEvaluator
implements CodeGenExtension {
    CodeGenConfiguration configuration;
    AxisService axisService;
    HashMap ns2Exts = new HashMap();
    Element rootElement;

    public void init(CodeGenConfiguration configuration) {
        this.configuration = configuration;
        this.axisService = configuration.getAxisService();
        this.ns2Exts.put("http://schemas.xmlsoap.org/ws/2004/09/policy/optimizedmimeserialization", new MTOMPolicyExtension());
        this.ns2Exts.put("http://schemas.xmlsoap.org/ws/2004/09/policy/encoding", new EncodePolicyExtension());
        configuration.putProperty("policyExtensionTemplate", "/org/apache/axis2/wsdl/template/java/PolicyExtensionTemplate.xsl");
        String repository = configuration.getRepositoryPath();
        if (repository == null) {
            return;
        }
        try {
            ConfigurationContext configurationCtx = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repository, null);
            AxisConfiguration axisConfiguration = configurationCtx.getAxisConfiguration();
            Iterator iterator = axisConfiguration.getModules().values().iterator();
            while (iterator.hasNext()) {
                Module module;
                AxisModule axisModule = (AxisModule)iterator.next();
                String[] namespaces = axisModule.getSupportedPolicyNamespaces();
                if (namespaces == null || !((module = axisModule.getModule()) instanceof ModulePolicyExtension)) continue;
                PolicyExtension ext = ((ModulePolicyExtension)module).getPolicyExtension();
                for (int i = 0; i < namespaces.length; ++i) {
                    this.ns2Exts.put(namespaces[i], ext);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("cannot create repository : policy will not be supported");
        }
    }

    public void engage() {
        Document document = this.getEmptyDocument();
        Element rootElement = document.createElement("stubMethods");
        Iterator a = this.axisService.getOperations();
        Iterator iterator = this.axisService.getOperations();
        while (iterator.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)iterator.next();
            QName opName = axisOperation.getName();
            PolicyInclude policyInclude = axisOperation.getPolicyInclude();
            Policy policy = policyInclude.getEffectivePolicy();
            if (policy == null) continue;
            this.processPolicies(document, rootElement, policy, opName);
        }
        this.configuration.putProperty("stubMethods", rootElement);
    }

    private void processPolicies(Document document, Element rootElement, Policy policy, QName opName) {
        if (!policy.isNormalized()) {
            policy = (Policy)policy.normalize();
        }
        HashMap<String, AndCompositeAssertion> map = new HashMap<String, AndCompositeAssertion>();
        XorCompositeAssertion XOR = (XorCompositeAssertion)policy.getTerms().get(0);
        AndCompositeAssertion AND = (AndCompositeAssertion)XOR.getTerms().get(0);
        Iterator<Object> iterator = AND.getTerms().iterator();
        while (iterator.hasNext()) {
            AndCompositeAssertion nAND = new AndCompositeAssertion();
            PrimitiveAssertion pa = (PrimitiveAssertion)iterator.next();
            String namespace = pa.getName().getNamespaceURI();
            nAND.addTerm((Assertion)pa);
            while (iterator.hasNext()) {
                pa = (PrimitiveAssertion)iterator.next();
                if (!namespace.equals(pa.getName().getNamespaceURI())) continue;
                nAND.addTerm((Assertion)pa);
            }
            map.put(namespace, nAND);
            AND.getTerms().removeAll(nAND.getTerms());
            iterator = AND.getTerms().iterator();
        }
        iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String namespace = (String)iterator.next();
            PolicyExtension policyExtension = (PolicyExtension)this.ns2Exts.get(namespace);
            if (policyExtension == null) {
                System.err.println("cannot find a PolicyExtension to process " + namespace + "type assertions");
                continue;
            }
            Policy nPolicy = new Policy();
            XorCompositeAssertion nXOR = new XorCompositeAssertion();
            nPolicy.addTerm((Assertion)nXOR);
            AndCompositeAssertion nAND = (AndCompositeAssertion)map.get(namespace);
            nXOR.addTerm((Assertion)nAND);
            policyExtension.addMethodsToStub(document, rootElement, opName, nPolicy);
        }
    }

    private Document getEmptyDocument() {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return documentBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    class EncodePolicyExtension
    implements PolicyExtension {
        EncodePolicyExtension() {
        }

        public void addMethodsToStub(Document document, Element element, QName operationName, Policy policy) {
        }
    }

    class MTOMPolicyExtension
    implements PolicyExtension {
        boolean setOnce = false;

        MTOMPolicyExtension() {
        }

        public void addMethodsToStub(Document document, Element element, QName operationName, Policy policy) {
            if (!this.setOnce) {
                Object plainBase64PropertyMap = PolicyEvaluator.this.configuration.getProperty("plainbase64map");
                PolicyEvaluator.this.configuration.putProperty("base64map", plainBase64PropertyMap);
                this.setOnce = true;
            }
            Element optimizeContent = document.createElement("optimizeContent");
            Element opNameElement = document.createElement("opName");
            opNameElement.setAttribute("ns-url", operationName.getNamespaceURI());
            opNameElement.setAttribute("localName", operationName.getLocalPart());
            optimizeContent.appendChild(opNameElement);
            element.appendChild(optimizeContent);
        }
    }
}

