/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.i18n.CodegenMessages;
import org.apache.axis2.wsdl.util.CommandLineOption;
import org.apache.axis2.wsdl.util.CommandLineOptionConstants;

class CodegenConfigLoader
implements CommandLineOptionConstants {
    CodegenConfigLoader() {
    }

    public static void loadConfig(CodeGenConfiguration config, Map optionMap) {
        String value;
        CommandLineOption ns2packageOption;
        CommandLineOption generateAllOption;
        CommandLineOption portNameOption;
        CommandLineOption unwrapClassesOption;
        CommandLineOption dataBindingOption;
        CommandLineOption langOption;
        CommandLineOption packageOption;
        boolean syncFlagPresent;
        String outputLocation = ".";
        CommandLineOption outputLocationOption = CodegenConfigLoader.loadOption("o", "output", optionMap);
        if (outputLocationOption != null) {
            outputLocation = outputLocationOption.getOptionValue();
        }
        File outputLocationFile = new File(outputLocation);
        config.setOutputLocation(outputLocationFile);
        if (outputLocationFile.exists()) {
            if (outputLocationFile.isFile()) {
                throw new RuntimeException(CodegenMessages.getMessage("options.notADirectoryException"));
            }
        } else {
            outputLocationFile.mkdirs();
        }
        config.setServerSide(CodegenConfigLoader.loadOption("ss", "server-side", optionMap) != null);
        config.setGenerateDeployementDescriptor(CodegenConfigLoader.loadOption("sd", "service-description", optionMap) != null);
        config.setWriteTestCase(CodegenConfigLoader.loadOption("t", "t", optionMap) != null);
        boolean asyncFlagPresent = CodegenConfigLoader.loadOption("a", "async", optionMap) != null;
        boolean bl = syncFlagPresent = CodegenConfigLoader.loadOption("s", "sync", optionMap) != null;
        if (asyncFlagPresent) {
            config.setAsyncOn(true);
            config.setSyncOn(false);
        }
        if (syncFlagPresent) {
            config.setAsyncOn(false);
            config.setSyncOn(true);
        }
        if ((packageOption = CodegenConfigLoader.loadOption("p", "package", optionMap)) != null) {
            config.setPackageName(packageOption.getOptionValue());
        }
        if ((langOption = CodegenConfigLoader.loadOption("l", "language", optionMap)) != null) {
            config.setOutputLanguage(langOption.getOptionValue());
        }
        if ((dataBindingOption = CodegenConfigLoader.loadOption("d", "databinding-method", optionMap)) != null) {
            config.setDatabindingType(dataBindingOption.getOptionValue());
        }
        if ((unwrapClassesOption = CodegenConfigLoader.loadOption("u", "unpack-classes", optionMap)) != null) {
            config.setPackClasses(false);
        }
        config.setPortName((portNameOption = CodegenConfigLoader.loadOption("pn", "port-name", optionMap)) != null ? portNameOption.getOptionValue() : null);
        CommandLineOption serviceNameOption = CodegenConfigLoader.loadOption("sn", "service-name", optionMap);
        config.setServiceName(serviceNameOption != null ? serviceNameOption.getOptionValue() : null);
        CommandLineOption repositoryPathOption = CodegenConfigLoader.loadOption("r", "repository-path", optionMap);
        config.setRepositoryPath(repositoryPathOption != null ? repositoryPathOption.getOptionValue() : null);
        CommandLineOption serverSideInterfaceOption = CodegenConfigLoader.loadOption("ssi", "server-side", optionMap);
        if (serverSideInterfaceOption != null) {
            config.setServerSideInterface(true);
        }
        if ((generateAllOption = CodegenConfigLoader.loadOption("g", "generate-all", optionMap)) != null) {
            config.setGenerateAll(true);
        }
        if ((ns2packageOption = CodegenConfigLoader.loadOption("ns2p", "namespace2package", optionMap)) != null && (value = ns2packageOption.getOptionValue()) != null) {
            if (value.indexOf(61) != -1) {
                String[] valuepairs = value.split(",");
                if (valuepairs.length > 0) {
                    HashMap<String, String> map = new HashMap<String, String>(valuepairs.length);
                    for (int i = 0; i < valuepairs.length; ++i) {
                        String[] values = valuepairs[i].split("=");
                        if (values.length != 2) continue;
                        map.put(values[0], values[1]);
                    }
                    config.setUri2PackageNameMap(map);
                }
            } else {
                try {
                    Properties p = new Properties();
                    p.load(new FileInputStream(value));
                    config.setUri2PackageNameMap(p);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to load file :" + value, e);
                }
            }
        }
        Iterator keyIterator = optionMap.keySet().iterator();
        while (keyIterator.hasNext()) {
            Object key = keyIterator.next();
            CommandLineOption option = (CommandLineOption)optionMap.get(key);
            if (!key.toString().startsWith("E")) continue;
            config.getProperties().put(key.toString().replaceFirst("E", ""), option.getOptionValue());
        }
    }

    private static CommandLineOption loadOption(String shortOption, String longOption, Map options) {
        CommandLineOption option = null;
        if (longOption != null && (option = (CommandLineOption)options.get(longOption)) != null) {
            return option;
        }
        if (shortOption != null) {
            option = (CommandLineOption)options.get(shortOption);
        }
        return option;
    }
}

