/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.WSDL2AxisServiceBuilder;
import org.apache.axis2.util.XMLUtils;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.codegen.CodeGenerationException;
import org.apache.axis2.wsdl.codegen.emitter.Emitter;
import org.apache.axis2.wsdl.codegen.extension.CodeGenExtension;
import org.apache.axis2.wsdl.databinding.TypeMapper;
import org.apache.axis2.wsdl.i18n.CodegenMessages;
import org.apache.axis2.wsdl.util.CommandLineOption;
import org.apache.axis2.wsdl.util.CommandLineOptionParser;
import org.apache.axis2.wsdl.util.ConfigPropertyFileLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class CodeGenerationEngine {
    private static final Log log = LogFactory.getLog((Class)CodeGenerationEngine.class);
    private List extensions = new ArrayList();
    private CodeGenConfiguration configuration;

    public CodeGenerationEngine(CodeGenConfiguration configuration) throws CodeGenerationException {
        this.configuration = configuration;
        this.loadExtensions();
    }

    public CodeGenerationEngine(CommandLineOptionParser parser) throws CodeGenerationException {
        String wsdlUri;
        Map allOptions = parser.getAllOptions();
        try {
            CommandLineOption option = (CommandLineOption)allOptions.get("uri");
            wsdlUri = option.getOptionValue();
            this.configuration = new CodeGenConfiguration(allOptions);
            Definition wsdl4jDef = this.readInTheWSDLFile(wsdlUri);
            QName serviceQname = null;
            if (this.configuration.getServiceName() != null) {
                serviceQname = new QName(wsdl4jDef.getTargetNamespace(), this.configuration.getServiceName());
            }
            this.configuration.setAxisService(new WSDL2AxisServiceBuilder(wsdl4jDef, serviceQname, this.configuration.getPortName()).populateService());
        }
        catch (AxisFault axisFault) {
            throw new CodeGenerationException(CodegenMessages.getMessage("engine.wsdlParsingException"), axisFault);
        }
        catch (WSDLException e) {
            throw new CodeGenerationException(CodegenMessages.getMessage("engine.wsdlParsingException"), e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CodeGenerationException(CodegenMessages.getMessage("engine.wsdlParsingException"), e);
        }
        this.configuration.setBaseURI(this.getBaseURI(wsdlUri));
        this.loadExtensions();
    }

    private void loadExtensions() throws CodeGenerationException {
        String[] extensions = ConfigPropertyFileLoader.getExtensionClassNames();
        for (int i = 0; i < extensions.length; ++i) {
            this.addExtension((CodeGenExtension)this.getObjectFromClassName(extensions[i]));
        }
    }

    private void addExtension(CodeGenExtension ext) {
        if (ext != null) {
            ext.init(this.configuration);
            this.extensions.add(ext);
        }
    }

    public void generate() throws CodeGenerationException {
        try {
            for (int i = 0; i < this.extensions.size(); ++i) {
                ((CodeGenExtension)this.extensions.get(i)).engage();
            }
            TypeMapper mapper = this.configuration.getTypeMapper();
            if (mapper == null) {
                throw new CodeGenerationException(CodegenMessages.getMessage("engine.noProperDatabindingException"));
            }
            Map emitterMap = ConfigPropertyFileLoader.getLanguageEmitterMap();
            String className = (String)emitterMap.get(this.configuration.getOutputLanguage());
            if (className == null) {
                throw new Exception(CodegenMessages.getMessage("engine.emitterMissing"));
            }
            Emitter emitter = (Emitter)this.getObjectFromClassName(className);
            emitter.setCodeGenConfiguration(this.configuration);
            emitter.setMapper(mapper);
            if (this.configuration.isServerSide()) {
                emitter.emitSkeleton();
                if (this.configuration.isGenerateAll()) {
                    emitter.emitStub();
                }
            } else {
                emitter.emitStub();
            }
        }
        catch (ClassCastException e) {
            throw new CodeGenerationException(CodegenMessages.getMessage("engine.wrongEmitter"), e);
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
    }

    private Definition readInTheWSDLFile(String uri) throws WSDLException {
        Document doc;
        String baseURI;
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        reader.setFeature("javax.wsdl.importDocuments", true);
        File file = new File(uri);
        if (uri.startsWith("http://")) {
            baseURI = uri;
        } else if (file.getParentFile() == null) {
            try {
                baseURI = new File(".").getCanonicalFile().toURI().toString();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            baseURI = file.getParentFile().toURI().toString();
        }
        try {
            doc = XMLUtils.newDocument((String)uri);
        }
        catch (ParserConfigurationException e) {
            throw new WSDLException("PARSER_ERROR", "Parser Configuration Error", (Throwable)e);
        }
        catch (SAXException e) {
            throw new WSDLException("PARSER_ERROR", "Parser SAX Error", (Throwable)e);
        }
        catch (IOException e) {
            throw new WSDLException("INVALID_WSDL", "IO Error", (Throwable)e);
        }
        return reader.readWSDL(baseURI, doc);
    }

    private Object getObjectFromClassName(String className) throws CodeGenerationException {
        try {
            Class<?> extensionClass = this.getClass().getClassLoader().loadClass(className);
            return extensionClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)CodegenMessages.getMessage("engine.extensionLoadProblem"), (Throwable)e);
            return null;
        }
        catch (InstantiationException e) {
            throw new CodeGenerationException(CodegenMessages.getMessage("engine.extensionInstantiationProblem"), e);
        }
        catch (IllegalAccessException e) {
            throw new CodeGenerationException(CodegenMessages.getMessage("engine.illegalExtension"), e);
        }
        catch (NoClassDefFoundError e) {
            log.debug((Object)CodegenMessages.getMessage("engine.extensionLoadProblem"), (Throwable)e);
            return null;
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
    }

    private String getBaseURI(String currentURI) {
        String baseURI = null;
        if (!currentURI.startsWith("http://")) {
            try {
                currentURI = new File(currentURI).toURL().toString();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Cannot find baseuri for :" + currentURI);
            }
        }
        String uriFragment = currentURI.substring(0, currentURI.lastIndexOf("/"));
        baseURI = uriFragment + (uriFragment.endsWith("/") ? "" : "/");
        return baseURI;
    }
}

