/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.schema.BeanWriterMetaInfoHolder;
import org.apache.axis2.schema.CompilerOptions;
import org.apache.axis2.schema.SchemaCompilationException;
import org.apache.axis2.schema.SchemaConstants;
import org.apache.axis2.schema.i18n.SchemaCompilerMessages;
import org.apache.axis2.schema.util.SchemaPropertyLoader;
import org.apache.axis2.schema.writer.BeanWriter;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAll;
import org.apache.ws.commons.schema.XmlSchemaAny;
import org.apache.ws.commons.schema.XmlSchemaAnyAttribute;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaChoice;
import org.apache.ws.commons.schema.XmlSchemaComplexContent;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexContentRestriction;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaContent;
import org.apache.ws.commons.schema.XmlSchemaContentModel;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaInclude;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaObjectTable;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSimpleContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentExtension;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentRestriction;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeList;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeUnion;
import org.apache.ws.commons.schema.XmlSchemaType;

public class SchemaCompiler {
    private CompilerOptions options;
    private HashMap processedTypemap;
    private HashMap processedElementMap;
    private HashMap processedAnonymousComplexTypesMap;
    private HashMap processedElementRefMap;
    private HashMap simpleTypesMap;
    private HashMap changedTypeMap;
    private HashMap processedTypeMetaInfoMap;
    private ArrayList processedElementList;
    private List nillableElementList;
    private BeanWriter writer = null;
    private Map baseSchemaTypeMap = null;
    public static final String ANY_ELEMENT_FIELD_NAME = "extraElement";
    public static final String EXTRA_ATTRIBUTE_FIELD_NAME = "extraAttributes";
    public static final String DEFAULT_CLASS_NAME = OMElement.class.getName();
    public static final String DEFAULT_CLASS_ARRAY_NAME = "org.apache.axiom.om.OMElement[]";
    public static final String DEFAULT_ATTRIB_CLASS_NAME = OMAttribute.class.getName();
    public static final String DEFAULT_ATTRIB_ARRAY_CLASS_NAME = "org.apache.axiom.om.OMAttribute[]";
    private static int typeCounter = 0;

    public HashMap getProcessedElementMap() {
        return this.processedElementMap;
    }

    public Map getProcessedModelMap() {
        return this.writer.getModelMap();
    }

    public SchemaCompiler(CompilerOptions options) throws SchemaCompilationException {
        this.options = options == null ? new CompilerOptions() : options;
        this.processedTypemap = new HashMap();
        this.processedElementMap = new HashMap();
        this.simpleTypesMap = new HashMap();
        this.processedElementList = new ArrayList();
        this.processedAnonymousComplexTypesMap = new HashMap();
        this.changedTypeMap = new HashMap();
        this.processedTypeMetaInfoMap = new HashMap();
        this.processedElementRefMap = new HashMap();
        this.nillableElementList = new ArrayList();
        this.writer = SchemaPropertyLoader.getBeanWriterInstance();
        this.writer.init(this.options);
        this.baseSchemaTypeMap = SchemaPropertyLoader.getTypeMapperInstance().getTypeMap();
    }

    public void compile(List schemalist) throws SchemaCompilationException {
        try {
            for (int i = 0; i < schemalist.size(); ++i) {
                XmlSchema schema = (XmlSchema)schemalist.get(i);
                this.compile(schema);
            }
        }
        catch (SchemaCompilationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaCompilationException(e);
        }
    }

    public void compile(XmlSchema schema) throws SchemaCompilationException {
        XmlSchemaObjectCollection includes = schema.getIncludes();
        if (includes != null) {
            Iterator tempIterator = includes.getIterator();
            while (tempIterator.hasNext()) {
                XmlSchema schema1;
                Object o = tempIterator.next();
                if (o instanceof XmlSchemaImport && (schema1 = ((XmlSchemaImport)o).getSchema()) != null) {
                    this.compile(schema1);
                }
                if (!(o instanceof XmlSchemaInclude) || (schema1 = ((XmlSchemaInclude)o).getSchema()) == null) continue;
                this.compile(schema1);
            }
        }
        XmlSchemaObjectTable elements = schema.getElements();
        Iterator xmlSchemaElement1Iterator = elements.getValues();
        while (xmlSchemaElement1Iterator.hasNext()) {
            this.processElement((XmlSchemaElement)xmlSchemaElement1Iterator.next(), schema);
        }
        Iterator xmlSchemaElement2Iterator = elements.getValues();
        while (xmlSchemaElement2Iterator.hasNext()) {
            this.writeElement((XmlSchemaElement)xmlSchemaElement2Iterator.next());
        }
        if (this.options.isWrapClasses()) {
            this.writer.writeBatch();
        }
    }

    public Properties getCompilerProperties() {
        return SchemaPropertyLoader.getPropertyMap();
    }

    private void writeElement(XmlSchemaElement xsElt) throws SchemaCompilationException {
        QName qName;
        if (this.processedElementMap.containsKey(xsElt.getQName())) {
            return;
        }
        XmlSchemaType schemaType = xsElt.getSchemaType();
        BeanWriterMetaInfoHolder metainf = new BeanWriterMetaInfoHolder();
        if (schemaType != null && schemaType.getName() != null) {
            qName = schemaType.getQName();
            String className = this.findClassName(qName, this.isArray((XmlSchemaParticle)xsElt));
            if (this.changedTypeMap.containsKey(qName)) {
                metainf.registerMapping(xsElt.getQName(), (QName)this.changedTypeMap.get(qName), className);
            } else {
                metainf.registerMapping(xsElt.getQName(), qName, className);
            }
        } else if (xsElt.getRefName() == null) {
            if (xsElt.getSchemaTypeName() != null) {
                qName = xsElt.getSchemaTypeName();
                String className = this.findClassName(qName, this.isArray((XmlSchemaParticle)xsElt));
                metainf.registerMapping(xsElt.getQName(), qName, className);
            } else if (schemaType != null) {
                metainf = (BeanWriterMetaInfoHolder)this.processedAnonymousComplexTypesMap.get(xsElt);
                metainf.setAnonymous(true);
            } else {
                throw new SchemaCompilationException("no type!!");
            }
        }
        if (this.nillableElementList.contains(xsElt.getQName())) {
            metainf.registerNillableQName(xsElt.getQName());
        }
        String writtenClassName = this.writer.write(xsElt, (Map)this.processedTypemap, metainf);
        this.processedElementMap.put(xsElt.getQName(), writtenClassName);
    }

    private void processElement(XmlSchemaElement xsElt, Map innerElementMap, List localNillableList, XmlSchema parentSchema) throws SchemaCompilationException {
        this.processElement(xsElt, false, innerElementMap, localNillableList, parentSchema);
    }

    private void processElement(XmlSchemaElement xsElt, XmlSchema parentSchema) throws SchemaCompilationException {
        this.processElement(xsElt, true, null, null, parentSchema);
    }

    private void processElement(XmlSchemaElement xsElt, boolean isOuter, Map innerElementMap, List localNillableList, XmlSchema parentSchema) throws SchemaCompilationException {
        if (isOuter && this.processedElementList.contains(xsElt.getQName())) {
            return;
        }
        XmlSchemaType schemaType = xsElt.getSchemaType();
        if (schemaType != null) {
            this.processSchema(xsElt, schemaType, parentSchema);
            if (!isOuter) {
                if (schemaType.getName() != null) {
                    innerElementMap.put(xsElt.getQName(), this.findClassName(schemaType.getQName(), this.isArray((XmlSchemaParticle)xsElt)));
                } else {
                    QName generatedTypeName = this.generateTypeQName(xsElt.getQName(), parentSchema);
                    if (schemaType instanceof XmlSchemaComplexType) {
                        schemaType.setName(generatedTypeName.getLocalPart());
                        this.writeComplexType((XmlSchemaComplexType)schemaType, (BeanWriterMetaInfoHolder)this.processedAnonymousComplexTypesMap.get(xsElt), null);
                        this.processedAnonymousComplexTypesMap.remove(xsElt);
                        innerElementMap.put(xsElt.getQName(), this.findClassName(schemaType.getQName(), this.isArray((XmlSchemaParticle)xsElt)));
                    }
                }
            } else {
                this.processedElementList.add(xsElt.getQName());
            }
        } else if (xsElt.getRefName() != null) {
            XmlSchemaElement referencedElement = parentSchema.getElementByName(xsElt.getRefName());
            this.processElement(referencedElement, parentSchema);
            QName referenceEltQName = referencedElement.getQName();
            if (referencedElement.getSchemaTypeName() != null) {
                String className = this.findClassName(referencedElement.getSchemaTypeName(), this.isArray((XmlSchemaParticle)xsElt));
                this.processedElementRefMap.put(referenceEltQName, className);
            } else {
                QName generatedTypeName = this.generateTypeQName(referenceEltQName, parentSchema);
                XmlSchemaType referenceSchemaType = referencedElement.getSchemaType();
                if (referenceSchemaType instanceof XmlSchemaComplexType) {
                    referenceSchemaType.setName(generatedTypeName.getLocalPart());
                    this.writeComplexType((XmlSchemaComplexType)referenceSchemaType, (BeanWriterMetaInfoHolder)this.processedAnonymousComplexTypesMap.get(referencedElement), null);
                    this.processedAnonymousComplexTypesMap.remove(referencedElement);
                    this.processedElementRefMap.put(referenceEltQName, this.findClassName(referenceSchemaType.getQName(), this.isArray((XmlSchemaParticle)referencedElement)));
                }
            }
        } else if (xsElt.getSchemaTypeName() != null) {
            QName schemaTypeName = xsElt.getSchemaTypeName();
            XmlSchemaType typeByName = parentSchema.getTypeByName(schemaTypeName);
            if (typeByName != null) {
                this.processSchema(xsElt, typeByName, parentSchema);
                if (!isOuter) {
                    String className = this.findClassName(schemaTypeName, this.isArray((XmlSchemaParticle)xsElt));
                    innerElementMap.put(xsElt.getQName(), className);
                } else {
                    this.processedElementList.add(xsElt.getQName());
                }
            } else if (!isOuter) {
                String className = this.findClassName(schemaTypeName, this.isArray((XmlSchemaParticle)xsElt));
                innerElementMap.put(xsElt.getQName(), className);
            } else {
                this.processedElementList.add(xsElt.getQName());
            }
        }
        if (xsElt.isNillable()) {
            if (isOuter) {
                this.nillableElementList.add(xsElt.getQName());
            } else {
                localNillableList.add(xsElt.getQName());
            }
        }
    }

    private QName generateTypeQName(QName referenceEltQName, XmlSchema parentSchema) {
        QName generatedTypeName = new QName(referenceEltQName.getNamespaceURI(), referenceEltQName.getLocalPart() + this.getNextTypeSuffix());
        while (parentSchema.getTypeByName(generatedTypeName) != null) {
            generatedTypeName = new QName(referenceEltQName.getNamespaceURI(), referenceEltQName.getLocalPart() + this.getNextTypeSuffix());
        }
        return generatedTypeName;
    }

    private boolean isAlreadyProcessed(QName qName) {
        return this.processedTypemap.containsKey(qName) || this.simpleTypesMap.containsKey(qName) || this.baseSchemaTypeMap.containsKey(qName);
    }

    private String findRefClassName(QName name, boolean isArray) {
        String className = null;
        if (this.processedElementRefMap.get(name) != null) {
            className = (String)this.processedElementRefMap.get(name);
            if (isArray) {
                className = className + "[]";
            }
        }
        return className;
    }

    private String findClassName(QName qName, boolean isArray) {
        String className = this.processedTypemap.containsKey(qName) ? (String)this.processedTypemap.get(qName) : (this.simpleTypesMap.containsKey(qName) ? (String)this.simpleTypesMap.get(qName) : (this.baseSchemaTypeMap.containsKey(qName) ? (String)this.baseSchemaTypeMap.get(qName) : DEFAULT_CLASS_NAME));
        if (isArray) {
            className = className + "[]";
        }
        return className;
    }

    private void processSchema(XmlSchemaElement xsElt, XmlSchemaType schemaType, XmlSchema parentSchema) throws SchemaCompilationException {
        if (schemaType instanceof XmlSchemaComplexType) {
            XmlSchemaComplexType complexType = (XmlSchemaComplexType)schemaType;
            if (complexType.getName() != null) {
                this.processNamedComplexSchemaType(complexType, parentSchema);
            } else {
                this.processAnonymousComplexSchemaType(xsElt, complexType, parentSchema);
            }
        } else if (schemaType instanceof XmlSchemaSimpleType) {
            this.processSimpleSchemaType((XmlSchemaSimpleType)schemaType);
        }
    }

    private void processAnonymousComplexSchemaType(XmlSchemaElement elt, XmlSchemaComplexType complexType, XmlSchema parentSchema) throws SchemaCompilationException {
        BeanWriterMetaInfoHolder metaInfHolder = this.processComplexType(complexType, parentSchema);
        this.processedAnonymousComplexTypesMap.put(elt, metaInfHolder);
    }

    private void processNamedComplexSchemaType(XmlSchemaComplexType complexType, XmlSchema parentSchema) throws SchemaCompilationException {
        if (this.processedTypemap.containsKey(complexType.getQName()) || this.baseSchemaTypeMap.containsKey(complexType.getQName())) {
            return;
        }
        String fullyQualifiedClassName = this.writer.makeFullyQualifiedClassName(complexType.getQName());
        this.processedTypemap.put(complexType.getQName(), fullyQualifiedClassName);
        BeanWriterMetaInfoHolder metaInfHolder = this.processComplexType(complexType, parentSchema);
        this.writeComplexType(complexType, metaInfHolder, fullyQualifiedClassName);
    }

    private void writeComplexType(XmlSchemaComplexType complexType, BeanWriterMetaInfoHolder metaInfHolder, String fullyQualifiedClassName) throws SchemaCompilationException {
        this.writer.write(complexType, this.processedTypemap, metaInfHolder, fullyQualifiedClassName);
        this.processedTypeMetaInfoMap.put(complexType.getQName(), metaInfHolder);
    }

    private BeanWriterMetaInfoHolder processComplexType(XmlSchemaComplexType complexType, XmlSchema parentSchema) throws SchemaCompilationException {
        XmlSchemaParticle particle = complexType.getParticle();
        BeanWriterMetaInfoHolder metaInfHolder = new BeanWriterMetaInfoHolder();
        if (particle != null) {
            this.processParticle(particle, metaInfHolder, parentSchema);
        }
        XmlSchemaObjectCollection attribs = complexType.getAttributes();
        Iterator attribIterator = attribs.getIterator();
        while (attribIterator.hasNext()) {
            Object o = attribIterator.next();
            if (!(o instanceof XmlSchemaAttribute)) continue;
            this.processAttribute((XmlSchemaAttribute)o, metaInfHolder);
        }
        XmlSchemaAnyAttribute anyAtt = complexType.getAnyAttribute();
        if (anyAtt != null) {
            this.processAnyAttribute(metaInfHolder, anyAtt);
        }
        if (complexType.getContentModel() != null) {
            this.processContentModel(complexType.getContentModel(), metaInfHolder, parentSchema);
        }
        return metaInfHolder;
    }

    private void processContentModel(XmlSchemaContentModel content, BeanWriterMetaInfoHolder metaInfHolder, XmlSchema parentSchema) throws SchemaCompilationException {
        if (content instanceof XmlSchemaComplexContent) {
            this.processComplexContent((XmlSchemaComplexContent)content, metaInfHolder, parentSchema);
        } else if (content instanceof XmlSchemaSimpleContent) {
            this.processSimpleContent((XmlSchemaSimpleContent)content, metaInfHolder);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processComplexContent(XmlSchemaComplexContent complexContent, BeanWriterMetaInfoHolder metaInfHolder, XmlSchema parentSchema) throws SchemaCompilationException {
        XmlSchemaContent content = complexContent.getContent();
        if (content instanceof XmlSchemaComplexContentExtension) {
            XmlSchemaComplexContentExtension extension = (XmlSchemaComplexContentExtension)content;
            if (!this.isAlreadyProcessed(extension.getBaseTypeName())) {
                XmlSchemaType type = parentSchema.getTypeByName(extension.getBaseTypeName());
                if (type instanceof XmlSchemaComplexType) {
                    XmlSchemaComplexType complexType = (XmlSchemaComplexType)type;
                    if (complexType.getName() == null) throw new SchemaCompilationException("Unnamed complex type used in extension");
                    this.processNamedComplexSchemaType(complexType, parentSchema);
                } else if (type instanceof XmlSchemaSimpleType) {
                    this.processSimpleSchemaType((XmlSchemaSimpleType)type);
                }
            }
            this.copyMetaInfoHierarchy(metaInfHolder, extension.getBaseTypeName(), parentSchema);
            this.processParticle(extension.getParticle(), metaInfHolder, parentSchema);
            metaInfHolder.setExtension(true);
            metaInfHolder.setExtensionClassName(this.findClassName(extension.getBaseTypeName(), false));
            return;
        } else {
            if (!(content instanceof XmlSchemaComplexContentRestriction)) return;
            throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.unsupportedcontenterror", "Complex Content"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyMetaInfoHierarchy(BeanWriterMetaInfoHolder metaInfHolder, QName baseTypeName, XmlSchema parentSchema) throws SchemaCompilationException {
        XmlSchemaType type = parentSchema.getTypeByName(baseTypeName);
        BeanWriterMetaInfoHolder baseMetaInfoHolder = (BeanWriterMetaInfoHolder)this.processedTypeMetaInfoMap.get(baseTypeName);
        if (baseMetaInfoHolder == null || !(type instanceof XmlSchemaComplexType)) return;
        XmlSchemaComplexType complexType = (XmlSchemaComplexType)type;
        if (complexType.getContentModel() != null) {
            XmlSchemaContentModel content = complexType.getContentModel();
            if (content instanceof XmlSchemaComplexContent) {
                XmlSchemaComplexContent complexContent = (XmlSchemaComplexContent)content;
                if (complexContent.getContent() instanceof XmlSchemaComplexContentExtension) {
                    XmlSchemaComplexContentExtension extension = (XmlSchemaComplexContentExtension)complexContent.getContent();
                    this.copyMetaInfoHierarchy(baseMetaInfoHolder, extension.getBaseTypeName(), parentSchema);
                } else {
                    if (!(complexContent.getContent() instanceof XmlSchemaComplexContentRestriction)) throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.unknowncontenterror"));
                    XmlSchemaComplexContentRestriction restriction = (XmlSchemaComplexContentRestriction)complexContent.getContent();
                    this.copyMetaInfoHierarchy(baseMetaInfoHolder, restriction.getBaseTypeName(), parentSchema);
                }
            } else {
                if (!(content instanceof XmlSchemaSimpleContent)) throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.unknowncontenterror"));
                throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.unsupportedcontenterror", "Simple Content"));
            }
        }
        metaInfHolder.setAsParent(baseMetaInfoHolder);
    }

    private void processSimpleContent(XmlSchemaSimpleContent simpleContent, BeanWriterMetaInfoHolder metaInfHolder) throws SchemaCompilationException {
        XmlSchemaContent content = simpleContent.getContent();
        if (content instanceof XmlSchemaSimpleContentExtension) {
            throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.unsupportedcontenterror", "Simple Content Extension"));
        }
        if (content instanceof XmlSchemaSimpleContentRestriction) {
            throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.unsupportedcontenterror", "Simple Content Restriction"));
        }
    }

    private void processAnyAttribute(BeanWriterMetaInfoHolder metainf, XmlSchemaAnyAttribute anyAtt) {
        QName qName = new QName(EXTRA_ATTRIBUTE_FIELD_NAME);
        metainf.registerMapping(qName, null, DEFAULT_ATTRIB_ARRAY_CLASS_NAME, 8);
        metainf.addtStatus(qName, 1);
        metainf.addtStatus(qName, 4);
    }

    public void processAttribute(XmlSchemaAttribute att, BeanWriterMetaInfoHolder metainf) {
        QName schemaTypeName = att.getSchemaTypeName();
        if (this.baseSchemaTypeMap.containsKey(schemaTypeName)) {
            metainf.registerMapping(att.getQName(), schemaTypeName, this.baseSchemaTypeMap.get(schemaTypeName).toString(), 1);
        }
    }

    private void processParticle(XmlSchemaParticle particle, BeanWriterMetaInfoHolder metainfHolder, XmlSchema parentSchema) throws SchemaCompilationException {
        if (particle instanceof XmlSchemaSequence) {
            XmlSchemaObjectCollection items = ((XmlSchemaSequence)particle).getItems();
            this.process(items, metainfHolder, true, parentSchema);
        } else if (particle instanceof XmlSchemaAll) {
            XmlSchemaObjectCollection items = ((XmlSchemaAll)particle).getItems();
            this.process(items, metainfHolder, false, parentSchema);
        } else if (particle instanceof XmlSchemaChoice) {
            XmlSchemaObjectCollection items = ((XmlSchemaChoice)particle).getItems();
            metainfHolder.setChoice(true);
            this.process(items, metainfHolder, false, parentSchema);
        }
    }

    private void process(XmlSchemaObjectCollection items, BeanWriterMetaInfoHolder metainfHolder, boolean order, XmlSchema parentSchema) throws SchemaCompilationException {
        int count = items.getCount();
        HashMap<Object, Boolean> processedElementArrayStatusMap = new HashMap<Object, Boolean>();
        HashMap<QName, XmlSchemaAny> processedElementTypeMap = new HashMap<QName, XmlSchemaAny>();
        ArrayList localNillableList = new ArrayList();
        HashMap<Object, Integer> elementOrderMap = new HashMap<Object, Integer>();
        for (int i = 0; i < count; ++i) {
            XmlSchemaObject item = items.getItem(i);
            if (item instanceof XmlSchemaElement) {
                XmlSchemaElement xsElt = (XmlSchemaElement)item;
                boolean isArray = this.isArray((XmlSchemaParticle)xsElt);
                this.processElement(xsElt, processedElementTypeMap, localNillableList, parentSchema);
                processedElementArrayStatusMap.put(xsElt, isArray ? Boolean.TRUE : Boolean.FALSE);
                if (!order) continue;
                elementOrderMap.put(xsElt, new Integer(i));
                continue;
            }
            if (!(item instanceof XmlSchemaAny)) continue;
            XmlSchemaAny any = (XmlSchemaAny)item;
            processedElementTypeMap.put(new QName(ANY_ELEMENT_FIELD_NAME), any);
            if (order) {
                elementOrderMap.put(any, new Integer(i));
            }
            processedElementArrayStatusMap.put(any, this.isArray((XmlSchemaParticle)any) ? Boolean.TRUE : Boolean.FALSE);
        }
        Iterator processedElementsIterator = processedElementArrayStatusMap.keySet().iterator();
        int startingItemNumberOrder = metainfHolder.getOrderStartPoint();
        while (processedElementsIterator.hasNext()) {
            Object child = processedElementsIterator.next();
            if (child instanceof XmlSchemaElement) {
                QName referencedQName;
                String clazzName;
                XmlSchemaElement elt = (XmlSchemaElement)child;
                if (elt.getQName() != null) {
                    clazzName = (String)processedElementTypeMap.get(elt.getQName());
                    referencedQName = elt.getQName();
                    metainfHolder.registerMapping(referencedQName, elt.getSchemaType() != null ? elt.getSchemaType().getQName() : elt.getSchemaTypeName(), clazzName, (Boolean)processedElementArrayStatusMap.get(elt) != false ? 4 : 2);
                } else {
                    referencedQName = elt.getRefName();
                    boolean arrayStatus = (Boolean)processedElementArrayStatusMap.get(elt);
                    clazzName = this.findRefClassName(referencedQName, arrayStatus);
                    metainfHolder.registerMapping(referencedQName, parentSchema.getElementByName(referencedQName).getSchemaTypeName(), clazzName, arrayStatus ? 4 : 2);
                }
                metainfHolder.addMaxOccurs(referencedQName, elt.getMaxOccurs());
                metainfHolder.addMinOccurs(referencedQName, elt.getMinOccurs());
                if (order) {
                    Integer integer = (Integer)elementOrderMap.get(elt);
                    metainfHolder.registerQNameIndex(referencedQName, startingItemNumberOrder + integer);
                }
                if (localNillableList.contains(elt.getQName())) {
                    metainfHolder.registerNillableQName(elt.getQName());
                }
                if (!this.isBinary(elt)) continue;
                metainfHolder.addtStatus(elt.getQName(), 16);
                continue;
            }
            if (!(child instanceof XmlSchemaAny)) continue;
            XmlSchemaAny any = (XmlSchemaAny)child;
            QName anyElementFieldName = new QName(ANY_ELEMENT_FIELD_NAME);
            boolean isArray = (Boolean)processedElementArrayStatusMap.get(any);
            metainfHolder.registerMapping(anyElementFieldName, null, isArray ? DEFAULT_CLASS_ARRAY_NAME : DEFAULT_CLASS_NAME, 8);
            if (isArray) {
                metainfHolder.addtStatus(anyElementFieldName, 4);
            }
            metainfHolder.addMaxOccurs(anyElementFieldName, any.getMaxOccurs());
            metainfHolder.addMinOccurs(anyElementFieldName, any.getMinOccurs());
            if (!order) continue;
            Integer integer = (Integer)elementOrderMap.get(any);
            metainfHolder.registerQNameIndex(anyElementFieldName, startingItemNumberOrder + integer);
        }
        metainfHolder.setOrdered(order);
    }

    private boolean isBinary(XmlSchemaElement elt) {
        return elt.getSchemaType() != null && SchemaConstants.XSD_BASE64.equals(elt.getSchemaType().getQName());
    }

    private void processSimpleSchemaType(XmlSchemaSimpleType simpleType) throws SchemaCompilationException {
        XmlSchemaSimpleTypeContent content = simpleType.getContent();
        if (content != null) {
            if (content instanceof XmlSchemaSimpleTypeRestriction) {
                XmlSchemaSimpleTypeRestriction restriction = (XmlSchemaSimpleTypeRestriction)content;
                QName baseTypeName = restriction.getBaseTypeName();
                if (this.baseSchemaTypeMap.containsKey(baseTypeName)) {
                    String className = (String)this.baseSchemaTypeMap.get(baseTypeName);
                    this.simpleTypesMap.put(simpleType.getQName(), className);
                    this.changedTypeMap.put(simpleType.getQName(), baseTypeName);
                } else if (restriction.getBaseType() != null) {
                    this.processSimpleSchemaType(restriction.getBaseType());
                }
            } else {
                if (content instanceof XmlSchemaSimpleTypeUnion) {
                    throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.unsupportedcontenterror", "Simple Type Uniont"));
                }
                if (content instanceof XmlSchemaSimpleTypeList) {
                    throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.unsupportedcontenterror", "Simple Type List"));
                }
            }
        }
    }

    private boolean isArray(XmlSchemaParticle particle) throws SchemaCompilationException {
        long minOccurs = particle.getMinOccurs();
        long maxOccurs = particle.getMaxOccurs();
        if (maxOccurs < minOccurs) {
            throw new SchemaCompilationException();
        }
        return maxOccurs > 1L;
    }

    private String getNextTypeSuffix() {
        if (typeCounter == Integer.MAX_VALUE) {
            typeCounter = 0;
        }
        return "_type" + typeCounter++;
    }
}

