/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class BeanWriterMetaInfoHolder {
    protected boolean ordered = false;
    protected boolean anonymous = false;
    protected boolean choice = false;
    protected boolean extension = false;
    private String extensionClassName = "";
    protected Map elementToSchemaQNameMap = new HashMap();
    protected Map elementToJavaClassMap = new HashMap();
    protected Map specialTypeFlagMap = new HashMap();
    protected Map qNameMaxOccursCountMap = new HashMap();
    protected Map qNameMinOccursCountMap = new HashMap();
    protected Map qNameOrderMap = new HashMap();
    protected List nillableQNameList = new ArrayList();
    protected BeanWriterMetaInfoHolder parent = null;

    public boolean isChoice() {
        return this.choice;
    }

    public void setChoice(boolean choice) {
        this.choice = choice;
    }

    public BeanWriterMetaInfoHolder getParent() {
        return this.parent;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public String getExtensionClassName() {
        return this.extensionClassName;
    }

    public void setExtensionClassName(String extensionClassName) {
        this.extensionClassName = extensionClassName;
    }

    public boolean isExtension() {
        return this.extension;
    }

    public void setExtension(boolean extension) {
        this.extension = extension;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public void registerMapping(QName qName, QName schemaName, String javaClassName) {
        this.registerMapping(qName, schemaName, javaClassName, 2);
    }

    public void registerNillableQName(QName eltQName) {
        this.nillableQNameList.add(eltQName);
    }

    public boolean isNillable(QName eltQName) {
        return this.nillableQNameList.contains(eltQName);
    }

    public void registerMapping(QName qName, QName schemaName, String javaClassName, int type) {
        this.elementToJavaClassMap.put(qName, javaClassName);
        this.elementToSchemaQNameMap.put(qName, schemaName);
        this.addtStatus(qName, type);
    }

    public QName getSchemaQNameForQName(QName eltQName) {
        return (QName)this.elementToSchemaQNameMap.get(eltQName);
    }

    public String getClassNameForQName(QName eltQName) {
        return (String)this.elementToJavaClassMap.get(eltQName);
    }

    public boolean getAttributeStatusForQName(QName qName) {
        Integer state = (Integer)this.specialTypeFlagMap.get(qName);
        return state != null && this.getStatus(state, 1);
    }

    public boolean getAnyStatusForQName(QName qName) {
        Integer state = (Integer)this.specialTypeFlagMap.get(qName);
        return state != null && this.getStatus(state, 8);
    }

    public boolean getArrayStatusForQName(QName qName) {
        Integer state = (Integer)this.specialTypeFlagMap.get(qName);
        return state != null && this.getStatus(state, 4);
    }

    public boolean getBinaryStatusForQName(QName qName) {
        Integer state = (Integer)this.specialTypeFlagMap.get(qName);
        return state != null && this.getStatus(state, 16);
    }

    public boolean getAnyAttributeStatusForQName(QName qName) {
        return this.getArrayStatusForQName(qName) && this.getAnyStatusForQName(qName);
    }

    public void clearTables() {
        this.elementToJavaClassMap.clear();
        this.elementToSchemaQNameMap.clear();
        this.elementToSchemaQNameMap.clear();
        this.elementToJavaClassMap.clear();
        this.specialTypeFlagMap.clear();
        this.qNameMaxOccursCountMap.clear();
        this.qNameMinOccursCountMap.clear();
        this.qNameOrderMap.clear();
    }

    public void addMinOccurs(QName qName, long minOccurs) {
        this.qNameMinOccursCountMap.put(qName, new Long(minOccurs));
    }

    public void registerQNameIndex(QName qName, int index) {
        this.qNameOrderMap.put(new Integer(index), qName);
    }

    public long getMinOccurs(QName qName) {
        Long l = (Long)this.qNameMinOccursCountMap.get(qName);
        return l != null ? l : 1L;
    }

    public long getMaxOccurs(QName qName) {
        Long l = (Long)this.qNameMaxOccursCountMap.get(qName);
        return l != null ? l : 1L;
    }

    public void addMaxOccurs(QName qName, long maxOccurs) {
        this.qNameMaxOccursCountMap.put(qName, new Long(maxOccurs));
    }

    public Iterator getElementQNameIterator() {
        return this.elementToJavaClassMap.keySet().iterator();
    }

    public QName[] getQNameArray() {
        Set keySet = this.elementToJavaClassMap.keySet();
        return keySet.toArray(new QName[keySet.size()]);
    }

    public QName[] getOrderedQNameArray() {
        Set set = this.qNameOrderMap.keySet();
        int count = set.size();
        Object[] keys = set.toArray(new Integer[count]);
        Arrays.sort(keys);
        ArrayList<Object> returnQNames = new ArrayList<Object>();
        for (int i = 0; i < keys.length; ++i) {
            returnQNames.add(this.qNameOrderMap.get(keys[i]));
        }
        QName[] allNames = this.getQNameArray();
        for (int i = 0; i < allNames.length; ++i) {
            if (!this.getAttributeStatusForQName(allNames[i])) continue;
            returnQNames.add(allNames[i]);
        }
        return returnQNames.toArray(new QName[returnQNames.size()]);
    }

    public int getOrderStartPoint() {
        return this.qNameOrderMap.size();
    }

    public void setAsParent(BeanWriterMetaInfoHolder metaInfo) {
        this.parent = metaInfo;
    }

    public void addtStatus(QName type, int mask) {
        Object obj = this.specialTypeFlagMap.get(type);
        if (obj != null) {
            int preValue = (Integer)obj;
            this.specialTypeFlagMap.put(type, new Integer(preValue | mask));
        } else {
            this.specialTypeFlagMap.put(type, new Integer(mask));
        }
    }

    private boolean getStatus(int storedStatus, int mask) {
        return mask == (mask & storedStatus);
    }
}

