/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.rpc.receivers;

import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.llom.factory.OMXMLBuilderFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.databinding.typemapping.SimpleTypeMapper;
import org.apache.axis2.databinding.utils.BeanUtil;
import org.apache.axis2.util.StreamWrapper;

public class RPCUtil {
    private static String RETURN_WRAPPER = "return";

    public static void processResponse(SOAPFactory fac, Object resObject, OMElement bodyContent, OMNamespace ns, SOAPEnvelope envelope, Method method) {
        if (resObject != null) {
            if (resObject instanceof OMElement) {
                OMElement result = (OMElement)resObject;
                bodyContent = fac.createOMElement(method.getName() + "Response", ns);
                OMElement resWrapper = fac.createOMElement(RETURN_WRAPPER, null);
                resWrapper.addChild((OMNode)result);
                bodyContent.addChild((OMNode)resWrapper);
            } else if (SimpleTypeMapper.isSimpleType((Object)resObject)) {
                bodyContent = fac.createOMElement(method.getName() + "Response", ns);
                OMElement child = fac.createOMElement(RETURN_WRAPPER, null);
                child.addChild((OMNode)fac.createOMText(child, SimpleTypeMapper.getStringValue((Object)resObject)));
                bodyContent.addChild((OMNode)child);
            } else {
                bodyContent = fac.createOMElement(method.getName() + "Response", ns);
                XMLStreamReader xr = BeanUtil.getPullParser((Object)resObject, (QName)new QName(RETURN_WRAPPER));
                StAXOMBuilder stAXOMBuilder = OMXMLBuilderFactory.createStAXOMBuilder((OMFactory)OMAbstractFactory.getOMFactory(), (XMLStreamReader)new StreamWrapper(xr));
                OMElement documentElement = stAXOMBuilder.getDocumentElement();
                if (documentElement != null) {
                    bodyContent.addChild((OMNode)documentElement);
                }
            }
        }
        if (bodyContent != null) {
            envelope.getBody().addChild((OMNode)bodyContent);
        }
    }

    public static Object[] processRequest(OMElement methodElement, Method method) throws AxisFault {
        Object[] parameters = method.getParameterTypes();
        return BeanUtil.deserialize((OMElement)methodElement, (Object[])parameters);
    }

    public static OMElement getResponseElement(QName resname, Object[] objs) {
        return BeanUtil.getOMElement((QName)resname, (Object[])objs, (String)RETURN_WRAPPER);
    }
}

