/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.rpc.receivers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.databinding.utils.BeanUtil;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.java2wsdl.TypeTable;
import org.apache.axis2.receivers.AbstractInOutMessageReceiver;
import org.apache.axis2.rpc.receivers.RPCUtil;
import org.apache.axis2.util.StreamWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RPCMessageReceiver
extends AbstractInOutMessageReceiver {
    private static Log log = LogFactory.getLog(RPCMessageReceiver.class);

    public void invokeBusinessLogic(MessageContext inMessage, MessageContext outMessage) throws AxisFault {
        Method method = null;
        try {
            Object obj = this.getTheImplementationObject(inMessage);
            Class<?> implClass = obj.getClass();
            AxisOperation op = inMessage.getOperationContext().getAxisOperation();
            method = (Method)op.getParameterValue("myMethod");
            if (method != null && method.getDeclaringClass() != implClass) {
                method = null;
            }
            AxisService service = inMessage.getAxisService();
            SOAPBody body = inMessage.getEnvelope().getBody();
            if (body == null) {
                throw new AxisFault("SOAP body is missing in the request");
            }
            OMElement methodElement = body.getFirstElement();
            AxisMessage inAxisMessage = op.getMessage("In");
            String messageNameSpace = null;
            if (method == null) {
                Method[] methods;
                String methodName = op.getName().getLocalPart();
                for (Method method1 : methods = implClass.getMethods()) {
                    if (method1.isBridge() || !method1.getName().equals(methodName)) continue;
                    method = method1;
                    op.addParameter("myMethod", (Object)method);
                    break;
                }
                if (method == null) {
                    throw new AxisFault("No such method '" + methodName + "' in class " + implClass.getName());
                }
            }
            Object resObject = null;
            if (inAxisMessage != null) {
                resObject = RPCUtil.invokeServiceClass(inAxisMessage, method, obj, messageNameSpace, methodElement, inMessage);
            }
            SOAPFactory fac = this.getSOAPFactory(inMessage);
            AxisMessage outaxisMessage = op.getMessage("Out");
            messageNameSpace = outaxisMessage != null && outaxisMessage.getElementQName() != null ? outaxisMessage.getElementQName().getNamespaceURI() : service.getTargetNamespace();
            OMNamespace ns = fac.createOMNamespace(messageNameSpace, service.getSchemaTargetNamespacePrefix());
            SOAPEnvelope envelope = fac.getDefaultEnvelope();
            OMElement bodyContent = null;
            if ("http://www.w3.org/ns/wsdl/robust-in-only".equals(op.getMessageExchangePattern())) {
                if (outMessage.getAxisMessage().getName() != null) {
                    OMElement bodyChild = fac.createOMElement(outMessage.getAxisMessage().getName(), ns);
                    envelope.getBody().addChild((OMNode)bodyChild);
                }
                outMessage.setEnvelope(envelope);
                return;
            }
            Parameter generateBare = service.getParameter("doclitBare");
            if (generateBare != null && "true".equals(generateBare.getValue())) {
                RPCUtil.processResonseAsDocLitBare(resObject, service, envelope, fac, ns, bodyContent, outMessage);
            } else {
                RPCUtil.processResponseAsDocLitWrapped(resObject, service, method, envelope, fac, ns, bodyContent, outMessage);
            }
            outMessage.setEnvelope(envelope);
        }
        catch (InvocationTargetException e) {
            Class<?>[] exceptionTypes;
            String msg = null;
            Throwable cause = e.getCause();
            if (cause != null) {
                msg = cause.getMessage();
            }
            if (msg == null) {
                msg = "Exception occurred while trying to invoke service method " + (method != null ? method.getName() : "null");
            }
            if (cause instanceof AxisFault) {
                log.debug((Object)msg, cause);
                throw (AxisFault)cause;
            }
            for (Class<?> exceptionType : exceptionTypes = method.getExceptionTypes()) {
                if (!exceptionType.getName().equals(cause.getClass().getName())) continue;
                String partQName = inMessage.getAxisService().getName() + this.getSimpleClassName(exceptionType);
                TypeTable typeTable = inMessage.getAxisService().getTypeTable();
                QName elementQName = typeTable.getQNamefortheType(partQName);
                SOAPFactory fac = this.getSOAPFactory(inMessage);
                OMElement exceptionElement = fac.createOMElement(elementQName);
                if (exceptionType.getName().equals(Exception.class.getName())) {
                    OMElement innterExceptionElement = fac.createOMElement(elementQName);
                    OMElement messageElement = fac.createOMElement("Message", inMessage.getAxisService().getTargetNamespace(), null);
                    messageElement.setText(cause.getMessage());
                    innterExceptionElement.addChild((OMNode)messageElement);
                    exceptionElement.addChild((OMNode)innterExceptionElement);
                } else {
                    QName innerElementQName = new QName(elementQName.getNamespaceURI(), this.getSimpleClassName(exceptionType));
                    XMLStreamReader xr = BeanUtil.getPullParser(cause, innerElementQName, typeTable, true, false);
                    StAXOMBuilder stAXOMBuilder = new StAXOMBuilder(OMAbstractFactory.getOMFactory(), (XMLStreamReader)new StreamWrapper(xr));
                    OMElement documentElement = stAXOMBuilder.getDocumentElement();
                    exceptionElement.addChild((OMNode)documentElement);
                }
                AxisFault axisFault = new AxisFault(cause.getMessage());
                axisFault.setDetail(exceptionElement);
                throw axisFault;
            }
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        catch (RuntimeException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (Exception e) {
            String msg = "Exception occurred while trying to invoke service method " + (method != null ? method.getName() : "null");
            log.error((Object)msg, (Throwable)e);
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    private String getSimpleClassName(Class type) {
        String simpleClassName = type.getName();
        int idx = simpleClassName.lastIndexOf(46);
        if (idx != -1 && idx < simpleClassName.length() - 1) {
            simpleClassName = simpleClassName.substring(idx + 1);
        }
        return simpleClassName.replace('$', '_');
    }
}

