/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webapp;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.server.api.ApplicationContext;
import org.apache.hadoop.yarn.server.webapp.dao.AppAttemptInfo;
import org.apache.hadoop.yarn.server.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerInfo;
import org.apache.hadoop.yarn.util.Apps;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet.HamletImpl;
import org.apache.hadoop.yarn.webapp.hamlet.HamletSpec;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

public class AppBlock
extends HtmlBlock {
    protected ApplicationContext appContext;

    @Inject
    AppBlock(ApplicationContext appContext, View.ViewContext ctx) {
        super(ctx);
        this.appContext = appContext;
    }

    @Override
    protected void render(HtmlBlock.Block html) {
        Collection<ApplicationAttemptReport> attempts;
        ApplicationReport appReport;
        String aid = this.$("app.id");
        if (aid.isEmpty()) {
            this.puts("Bad request: requires Application ID");
            return;
        }
        ApplicationId appID = null;
        try {
            appID = Apps.toAppID(aid);
        }
        catch (Exception e) {
            this.puts("Invalid Application ID: " + aid);
            return;
        }
        try {
            appReport = this.appContext.getApplication(appID);
        }
        catch (IOException e) {
            String message = "Failed to read the application " + appID + ".";
            LOG.error(message, e);
            ((HamletImpl.EImp)((Object)((Hamlet.P)html.p())._(new Object[]{message})))._();
            return;
        }
        if (appReport == null) {
            this.puts("Application not found: " + aid);
            return;
        }
        AppInfo app = new AppInfo(appReport);
        this.setTitle(StringHelper.join("Application ", aid));
        this.info("Application Overview")._("User:", app.getUser())._("Name:", app.getName())._("Application Type:", app.getType())._("State:", (Object)app.getAppState())._("FinalStatus:", (Object)app.getFinalAppStatus())._("Started:", Times.format(app.getStartedTime()))._("Elapsed:", StringUtils.formatTime(Times.elapsed(app.getStartedTime(), app.getFinishedTime())))._("Tracking URL:", app.getTrackingUrl() == null ? "#" : this.root_url(app.getTrackingUrl()), "History")._("Diagnostics:", app.getDiagnosticsInfo());
        html._(InfoBlock.class);
        try {
            attempts = this.appContext.getApplicationAttempts(appID).values();
        }
        catch (IOException e) {
            String message = "Failed to read the attempts of the application " + appID + ".";
            LOG.error(message, e);
            ((HamletImpl.EImp)((Object)((Hamlet.P)html.p())._(new Object[]{message})))._();
            return;
        }
        HamletSpec.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)((HamletImpl.EImp)((Object)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.THEAD)((Hamlet.TABLE)html.table("#attempts")).thead()).tr()).th(".id", "Attempt ID")).th(".started", "Started")).th(".node", "Node")).th(".logs", "Logs")))._())._()).tbody();
        StringBuilder attemptsTableData = new StringBuilder("[\n");
        for (ApplicationAttemptReport appAttemptReport : attempts) {
            ContainerReport containerReport;
            AppAttemptInfo appAttempt = new AppAttemptInfo(appAttemptReport);
            try {
                containerReport = this.appContext.getAMContainer(appAttemptReport.getApplicationAttemptId());
            }
            catch (IOException e) {
                String message = "Failed to read the AM container of the application attempt " + appAttemptReport.getApplicationAttemptId() + ".";
                LOG.error(message, e);
                ((HamletImpl.EImp)((Object)((Hamlet.P)html.p())._(new Object[]{message})))._();
                return;
            }
            long startTime = Long.MAX_VALUE;
            String logsLink = null;
            if (containerReport != null) {
                ContainerInfo container = new ContainerInfo(containerReport);
                startTime = container.getStartedTime();
                logsLink = containerReport.getLogUrl();
            }
            String nodeLink = null;
            if (appAttempt.getHost() != null && appAttempt.getRpcPort() >= 0 && appAttempt.getRpcPort() < 65536) {
                nodeLink = appAttempt.getHost() + ":" + appAttempt.getRpcPort();
            }
            attemptsTableData.append("[\"<a href='").append(this.url("appattempt", appAttempt.getAppAttemptId())).append("'>").append(appAttempt.getAppAttemptId()).append("</a>\",\"").append(startTime).append("\",\"<a href='").append(nodeLink == null ? "#" : this.url("//", nodeLink)).append("'>").append(nodeLink == null ? "N/A" : StringEscapeUtils.escapeJavaScript(StringEscapeUtils.escapeHtml(nodeLink))).append("</a>\",\"<a href='").append(logsLink == null ? "#" : logsLink).append("'>").append(logsLink == null ? "N/A" : "Logs").append("</a>\"],\n");
        }
        if (attemptsTableData.charAt(attemptsTableData.length() - 2) == ',') {
            attemptsTableData.delete(attemptsTableData.length() - 2, attemptsTableData.length() - 1);
        }
        attemptsTableData.append("]");
        ((HamletImpl.EImp)((Object)((Hamlet.SCRIPT)((Hamlet.SCRIPT)html.script()).$type("text/javascript"))._(new Object[]{"var attemptsTableData=" + attemptsTableData})))._();
        ((Hamlet.TABLE)((HamletImpl.EImp)((Object)tbody))._())._();
    }
}

