/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIsNotDirectoryException;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.AclException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.FSLimitException;
import org.apache.hadoop.hdfs.protocol.FsAclPermission;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsLocatedFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.protocol.SnapshotAccessControlException;
import org.apache.hadoop.hdfs.protocol.SnapshotException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.AclStorage;
import org.apache.hadoop.hdfs.server.namenode.AclTransformation;
import org.apache.hadoop.hdfs.server.namenode.CacheManager;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryComputationContext;
import org.apache.hadoop.hdfs.server.namenode.DirectoryWithQuotaFeature;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeMap;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.NameCache;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.hadoop.hdfs.server.namenode.XAttrStorage;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeDirectorySnapshottable;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.util.ByteArray;
import org.apache.hadoop.hdfs.util.ChunkedArrayList;
import org.apache.hadoop.hdfs.util.ReadOnlyList;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
public class FSDirectory
implements Closeable {
    @VisibleForTesting
    static boolean CHECK_RESERVED_FILE_NAMES = true;
    public static final String DOT_RESERVED_STRING = ".reserved";
    public static final String DOT_RESERVED_PATH_PREFIX = "/.reserved";
    public static final byte[] DOT_RESERVED = DFSUtil.string2Bytes(".reserved");
    public static final String DOT_INODES_STRING = ".inodes";
    public static final byte[] DOT_INODES = DFSUtil.string2Bytes(".inodes");
    INodeDirectory rootDir;
    private final FSNamesystem namesystem;
    private volatile boolean skipQuotaCheck = false;
    private final int maxComponentLength;
    private final int maxDirItems;
    private final int lsLimit;
    private final int contentCountLimit;
    private final INodeMap inodeMap;
    private long yieldCount = 0L;
    private final int inodeXAttrsLimit;
    private final ReentrantReadWriteLock dirLock = new ReentrantReadWriteLock(true);
    private final NameCache<ByteArray> nameCache;

    private static INodeDirectorySnapshottable createRoot(FSNamesystem namesystem) {
        INodeDirectory r = new INodeDirectory(16385L, INodeDirectory.ROOT_NAME, namesystem.createFsOwnerPermissions(new FsPermission(493)), 0L);
        r.addDirectoryWithQuotaFeature(Long.MAX_VALUE, -1L);
        INodeDirectorySnapshottable s = new INodeDirectorySnapshottable(r);
        s.setSnapshotQuota(0);
        return s;
    }

    void readLock() {
        this.dirLock.readLock().lock();
    }

    void readUnlock() {
        this.dirLock.readLock().unlock();
    }

    void writeLock() {
        this.dirLock.writeLock().lock();
    }

    void writeUnlock() {
        this.dirLock.writeLock().unlock();
    }

    boolean hasWriteLock() {
        return this.dirLock.isWriteLockedByCurrentThread();
    }

    boolean hasReadLock() {
        return this.dirLock.getReadHoldCount() > 0;
    }

    public int getReadHoldCount() {
        return this.dirLock.getReadHoldCount();
    }

    public int getWriteHoldCount() {
        return this.dirLock.getWriteHoldCount();
    }

    FSDirectory(FSNamesystem ns, Configuration conf) {
        this.rootDir = FSDirectory.createRoot(ns);
        this.inodeMap = INodeMap.newInstance(this.rootDir);
        int configuredLimit = conf.getInt("dfs.ls.limit", 1000);
        this.lsLimit = configuredLimit > 0 ? configuredLimit : 1000;
        this.contentCountLimit = conf.getInt("dfs.content-summary.limit", 0);
        this.maxComponentLength = conf.getInt("dfs.namenode.fs-limits.max-component-length", 255);
        this.maxDirItems = conf.getInt("dfs.namenode.fs-limits.max-directory-items", 0x100000);
        this.inodeXAttrsLimit = conf.getInt("dfs.namenode.fs-limits.max-xattrs-per-inode", 32);
        Preconditions.checkArgument(this.inodeXAttrsLimit >= 0, "Cannot set a negative limit on the number of xattrs per inode (%s).", "dfs.namenode.fs-limits.max-xattrs-per-inode");
        int MAX_DIR_ITEMS = 6400000;
        Preconditions.checkArgument(this.maxDirItems > 0 && this.maxDirItems <= 6400000, "Cannot set dfs.namenode.fs-limits.max-directory-items to a value less than 0 or greater than 6400000");
        int threshold = conf.getInt("dfs.namenode.name.cache.threshold", 10);
        NameNode.LOG.info("Caching file names occuring more than " + threshold + " times");
        this.nameCache = new NameCache(threshold);
        this.namesystem = ns;
    }

    private FSNamesystem getFSNamesystem() {
        return this.namesystem;
    }

    private BlockManager getBlockManager() {
        return this.getFSNamesystem().getBlockManager();
    }

    public INodeDirectory getRoot() {
        return this.rootDir;
    }

    @Override
    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markNameCacheInitialized() {
        this.writeLock();
        try {
            this.nameCache.initialized();
        }
        finally {
            this.writeUnlock();
        }
    }

    void enableQuotaChecks() {
        this.skipQuotaCheck = false;
    }

    void disableQuotaChecks() {
        this.skipQuotaCheck = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INodeFile addFile(String path, PermissionStatus permissions, short replication, long preferredBlockSize, String clientName, String clientMachine) throws FileAlreadyExistsException, QuotaExceededException, UnresolvedLinkException, SnapshotAccessControlException, AclException {
        long modTime = Time.now();
        INodeFile newNode = new INodeFile(this.namesystem.allocateNewInodeId(), null, permissions, modTime, modTime, BlockInfo.EMPTY_ARRAY, replication, preferredBlockSize);
        newNode.toUnderConstruction(clientName, clientMachine);
        boolean added = false;
        this.writeLock();
        try {
            added = this.addINode(path, newNode);
        }
        finally {
            this.writeUnlock();
        }
        if (!added) {
            NameNode.stateChangeLog.info("DIR* addFile: failed to add " + path);
            return null;
        }
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* addFile: " + path + " is added");
        }
        return newNode;
    }

    INodeFile unprotectedAddFile(long id, String path, PermissionStatus permissions, List<AclEntry> aclEntries, List<XAttr> xAttrs, short replication, long modificationTime, long atime, long preferredBlockSize, boolean underConstruction, String clientName, String clientMachine) {
        block8: {
            INodeFile newNode;
            assert (this.hasWriteLock());
            if (underConstruction) {
                newNode = new INodeFile(id, null, permissions, modificationTime, modificationTime, BlockInfo.EMPTY_ARRAY, replication, preferredBlockSize);
                newNode.toUnderConstruction(clientName, clientMachine);
            } else {
                newNode = new INodeFile(id, null, permissions, modificationTime, atime, BlockInfo.EMPTY_ARRAY, replication, preferredBlockSize);
            }
            try {
                if (this.addINode(path, newNode)) {
                    if (aclEntries != null) {
                        AclStorage.updateINodeAcl(newNode, aclEntries, 0x7FFFFFFE);
                    }
                    if (xAttrs != null) {
                        XAttrStorage.updateINodeXAttrs(newNode, xAttrs, 0x7FFFFFFE);
                    }
                    return newNode;
                }
            }
            catch (IOException e) {
                if (!NameNode.stateChangeLog.isDebugEnabled()) break block8;
                NameNode.stateChangeLog.debug("DIR* FSDirectory.unprotectedAddFile: exception when add " + path + " to the file system", e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BlockInfo addBlock(String path, INodesInPath inodesInPath, Block block, DatanodeStorageInfo[] targets) throws IOException {
        this.writeLock();
        try {
            INodeFile fileINode = inodesInPath.getLastINode().asFile();
            Preconditions.checkState(fileINode.isUnderConstruction());
            this.updateCount(inodesInPath, 0L, fileINode.getBlockDiskspace(), true);
            BlockInfoUnderConstruction blockInfo = new BlockInfoUnderConstruction(block, fileINode.getFileReplication(), HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION, targets);
            this.getBlockManager().addBlockCollection(blockInfo, fileINode);
            fileINode.addBlock(blockInfo);
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug("DIR* FSDirectory.addBlock: " + path + " with " + block + " block is added to the in-memory " + "file system");
            }
            BlockInfoUnderConstruction blockInfoUnderConstruction = blockInfo;
            return blockInfoUnderConstruction;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeBlock(String path, INodeFile fileNode, Block block) throws IOException {
        Preconditions.checkArgument(fileNode.isUnderConstruction());
        this.writeLock();
        try {
            boolean bl = this.unprotectedRemoveBlock(path, fileNode, block);
            return bl;
        }
        finally {
            this.writeUnlock();
        }
    }

    boolean unprotectedRemoveBlock(String path, INodeFile fileNode, Block block) throws IOException {
        boolean removed = fileNode.removeLastBlock(block);
        if (!removed) {
            return false;
        }
        this.getBlockManager().removeBlockFromMap(block);
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* FSDirectory.removeBlock: " + path + " with " + block + " block is removed from the file system");
        }
        INodesInPath iip = this.getINodesInPath4Write(path, true);
        this.updateCount(iip, 0L, -fileNode.getBlockDiskspace(), true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    boolean renameTo(String src, String dst, long mtime) throws QuotaExceededException, UnresolvedLinkException, FileAlreadyExistsException, SnapshotAccessControlException, IOException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* FSDirectory.renameTo: " + src + " to " + dst);
        }
        this.writeLock();
        try {
            if (!this.unprotectedRenameTo(src, dst, mtime)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.writeUnlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renameTo(String src, String dst, long mtime, Options.Rename ... options) throws FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, QuotaExceededException, UnresolvedLinkException, IOException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* FSDirectory.renameTo: " + src + " to " + dst);
        }
        this.writeLock();
        try {
            if (this.unprotectedRenameTo(src, dst, mtime, options)) {
                this.namesystem.incrDeletedFileCount(1L);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    boolean unprotectedRenameTo(String src, String dst, long timestamp) throws QuotaExceededException, UnresolvedLinkException, FileAlreadyExistsException, SnapshotAccessControlException, IOException {
        assert (this.hasWriteLock());
        INodesInPath srcIIP = this.getINodesInPath4Write(src, false);
        INode srcInode = srcIIP.getLastINode();
        try {
            FSDirectory.validateRenameSource(src, srcIIP);
        }
        catch (SnapshotException e) {
            throw e;
        }
        catch (IOException ignored) {
            return false;
        }
        if (this.isDir(dst)) {
            dst = dst + "/" + new Path(src).getName();
        }
        if (dst.equals(src)) {
            return true;
        }
        try {
            FSDirectory.validateRenameDestination(src, dst, srcInode);
        }
        catch (IOException ignored) {
            return false;
        }
        INodesInPath dstIIP = this.getINodesInPath4Write(dst, false);
        if (dstIIP.getLastINode() != null) {
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because destination exists");
            return false;
        }
        INode dstParent = dstIIP.getINode(-2);
        if (dstParent == null) {
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because destination's parent does not exist");
            return false;
        }
        this.verifyFsLimitsForRename(srcIIP, dstIIP);
        this.verifyQuotaForRename(srcIIP.getINodes(), dstIIP.getINodes());
        RenameOperation tx = new RenameOperation(src, dst, srcIIP, dstIIP);
        boolean added = false;
        try {
            long removedSrc = this.removeLastINode(srcIIP);
            if (removedSrc == -1L) {
                NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because the source can not be removed");
                boolean bl = false;
                return bl;
            }
            added = tx.addSourceToDestination();
            if (added) {
                if (NameNode.stateChangeLog.isDebugEnabled()) {
                    NameNode.stateChangeLog.debug("DIR* FSDirectory.unprotectedRenameTo: " + src + " is renamed to " + dst);
                }
                tx.updateMtimeAndLease(timestamp);
                tx.updateQuotasInSourceTree();
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (!added) {
                tx.restoreSource();
            }
        }
        NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean unprotectedRenameTo(String src, String dst, long timestamp, Options.Rename ... options) throws FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, QuotaExceededException, UnresolvedLinkException, IOException {
        INode dstParent;
        assert (this.hasWriteLock());
        boolean overwrite = options != null && Arrays.asList(options).contains((Object)Options.Rename.OVERWRITE);
        INodesInPath srcIIP = this.getINodesInPath4Write(src, false);
        INode srcInode = srcIIP.getLastINode();
        FSDirectory.validateRenameSource(src, srcIIP);
        if (dst.equals(src)) {
            throw new FileAlreadyExistsException("The source " + src + " and destination " + dst + " are the same");
        }
        FSDirectory.validateRenameDestination(src, dst, srcInode);
        INodesInPath dstIIP = this.getINodesInPath4Write(dst, false);
        if (dstIIP.getINodes().length == 1) {
            String error = "rename destination cannot be the root";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new IOException(error);
        }
        INode dstInode = dstIIP.getLastINode();
        ArrayList<INodeDirectorySnapshottable> snapshottableDirs = new ArrayList<INodeDirectorySnapshottable>();
        if (dstInode != null) {
            FSDirectory.validateRenameOverwrite(src, dst, overwrite, srcInode, dstInode);
            FSDirectory.checkSnapshot(dstInode, snapshottableDirs);
        }
        if ((dstParent = dstIIP.getINode(-2)) == null) {
            String error = "rename destination parent " + dst + " not found.";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new FileNotFoundException(error);
        }
        if (!dstParent.isDirectory()) {
            String error = "rename destination parent " + dst + " is a file.";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new ParentNotDirectoryException(error);
        }
        this.verifyFsLimitsForRename(srcIIP, dstIIP);
        this.verifyQuotaForRename(srcIIP.getINodes(), dstIIP.getINodes());
        RenameOperation tx = new RenameOperation(src, dst, srcIIP, dstIIP);
        boolean undoRemoveSrc = true;
        long removedSrc = this.removeLastINode(srcIIP);
        if (removedSrc == -1L) {
            String error = "Failed to rename " + src + " to " + dst + " because the source can not be removed";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new IOException(error);
        }
        boolean undoRemoveDst = false;
        INode removedDst = null;
        long removedNum = 0L;
        try {
            if (dstInode != null && (removedNum = this.removeLastINode(dstIIP)) != -1L) {
                removedDst = dstIIP.getLastINode();
                undoRemoveDst = true;
            }
            if (tx.addSourceToDestination()) {
                undoRemoveSrc = false;
                if (NameNode.stateChangeLog.isDebugEnabled()) {
                    NameNode.stateChangeLog.debug("DIR* FSDirectory.unprotectedRenameTo: " + src + " is renamed to " + dst);
                }
                tx.updateMtimeAndLease(timestamp);
                long filesDeleted = -1L;
                if (removedDst != null) {
                    undoRemoveDst = false;
                    if (removedNum > 0L) {
                        INode.BlocksMapUpdateInfo collectedBlocks = new INode.BlocksMapUpdateInfo();
                        ChunkedArrayList<INode> removedINodes = new ChunkedArrayList<INode>();
                        filesDeleted = removedDst.cleanSubtree(0x7FFFFFFE, dstIIP.getLatestSnapshotId(), collectedBlocks, removedINodes, true).get(Quota.NAMESPACE);
                        this.getFSNamesystem().removePathAndBlocks(src, collectedBlocks, removedINodes, false);
                    }
                }
                if (snapshottableDirs.size() > 0) {
                    this.namesystem.removeSnapshottableDirs(snapshottableDirs);
                }
                tx.updateQuotasInSourceTree();
                boolean bl = filesDeleted >= 0L;
                return bl;
            }
        }
        finally {
            if (undoRemoveSrc) {
                tx.restoreSource();
            }
            if (undoRemoveDst) {
                if (dstParent.isDirectory() && dstParent.asDirectory().isWithSnapshot()) {
                    dstParent.asDirectory().undoRename4DstParent(removedDst, dstIIP.getLatestSnapshotId());
                } else {
                    this.addLastINodeNoQuotaCheck(dstIIP, removedDst);
                }
                if (removedDst.isReference()) {
                    INodeReference removedDstRef = removedDst.asReference();
                    INodeReference.WithCount wc = (INodeReference.WithCount)removedDstRef.getReferredINode().asReference();
                    wc.addReference(removedDstRef);
                }
            }
        }
        NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst);
        throw new IOException("rename from " + src + " to " + dst + " failed.");
    }

    private static void validateRenameOverwrite(String src, String dst, boolean overwrite, INode srcInode, INode dstInode) throws IOException {
        ReadOnlyList<INode> children;
        if (dstInode.isDirectory() != srcInode.isDirectory()) {
            String error = "Source " + src + " and destination " + dst + " must both be directories";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new IOException(error);
        }
        if (!overwrite) {
            String error = "rename destination " + dst + " already exists";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new FileAlreadyExistsException(error);
        }
        if (dstInode.isDirectory() && !(children = dstInode.asDirectory().getChildrenList(0x7FFFFFFE)).isEmpty()) {
            String error = "rename destination directory is not empty: " + dst;
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new IOException(error);
        }
    }

    private static void validateRenameDestination(String src, String dst, INode srcInode) throws IOException {
        if (srcInode.isSymlink() && dst.equals(srcInode.asSymlink().getSymlinkString())) {
            throw new FileAlreadyExistsException("Cannot rename symlink " + src + " to its target " + dst);
        }
        if (dst.startsWith(src) && dst.charAt(src.length()) == '/') {
            String error = "Rename destination " + dst + " is a directory or file under source " + src;
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new IOException(error);
        }
    }

    private static void validateRenameSource(String src, INodesInPath srcIIP) throws IOException {
        INode srcInode = srcIIP.getLastINode();
        if (srcInode == null) {
            String error = "rename source " + src + " is not found.";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new FileNotFoundException(error);
        }
        if (srcIIP.getINodes().length == 1) {
            String error = "rename source cannot be the root";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new IOException(error);
        }
        FSDirectory.checkSnapshot(srcInode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Block[] setReplication(String src, short replication, short[] blockRepls) throws QuotaExceededException, UnresolvedLinkException, SnapshotAccessControlException {
        this.writeLock();
        try {
            Block[] blockArray = this.unprotectedSetReplication(src, replication, blockRepls);
            return blockArray;
        }
        finally {
            this.writeUnlock();
        }
    }

    Block[] unprotectedSetReplication(String src, short replication, short[] blockRepls) throws QuotaExceededException, UnresolvedLinkException, SnapshotAccessControlException {
        short newBR;
        assert (this.hasWriteLock());
        INodesInPath iip = this.getINodesInPath4Write(src, true);
        INode inode = iip.getLastINode();
        if (inode == null || !inode.isFile()) {
            return null;
        }
        INodeFile file = inode.asFile();
        short oldBR = file.getBlockReplication();
        if (replication > oldBR) {
            long dsDelta = (long)(replication - oldBR) * (file.diskspaceConsumed() / (long)oldBR);
            this.updateCount(iip, 0L, dsDelta, true);
        }
        if ((newBR = (file = file.setFileReplication(replication, iip.getLatestSnapshotId(), this.inodeMap)).getBlockReplication()) < oldBR) {
            long dsDelta = (long)(newBR - oldBR) * (file.diskspaceConsumed() / (long)newBR);
            this.updateCount(iip, 0L, dsDelta, true);
        }
        if (blockRepls != null) {
            blockRepls[0] = oldBR;
            blockRepls[1] = newBR;
        }
        return file.getBlocks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getPreferredBlockSize(String path) throws UnresolvedLinkException, FileNotFoundException, IOException {
        this.readLock();
        try {
            long l = INodeFile.valueOf(this.getNode(path, false), path).getPreferredBlockSize();
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPermission(String src, FsPermission permission) throws FileNotFoundException, UnresolvedLinkException, QuotaExceededException, SnapshotAccessControlException {
        this.writeLock();
        try {
            this.unprotectedSetPermission(src, permission);
        }
        finally {
            this.writeUnlock();
        }
    }

    void unprotectedSetPermission(String src, FsPermission permissions) throws FileNotFoundException, UnresolvedLinkException, QuotaExceededException, SnapshotAccessControlException {
        assert (this.hasWriteLock());
        INodesInPath inodesInPath = this.getINodesInPath4Write(src, true);
        INode inode = inodesInPath.getLastINode();
        if (inode == null) {
            throw new FileNotFoundException("File does not exist: " + src);
        }
        int snapshotId = inodesInPath.getLatestSnapshotId();
        inode.setPermission(permissions, snapshotId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOwner(String src, String username, String groupname) throws FileNotFoundException, UnresolvedLinkException, QuotaExceededException, SnapshotAccessControlException {
        this.writeLock();
        try {
            this.unprotectedSetOwner(src, username, groupname);
        }
        finally {
            this.writeUnlock();
        }
    }

    void unprotectedSetOwner(String src, String username, String groupname) throws FileNotFoundException, UnresolvedLinkException, QuotaExceededException, SnapshotAccessControlException {
        assert (this.hasWriteLock());
        INodesInPath inodesInPath = this.getINodesInPath4Write(src, true);
        INode inode = inodesInPath.getLastINode();
        if (inode == null) {
            throw new FileNotFoundException("File does not exist: " + src);
        }
        if (username != null) {
            inode = inode.setUser(username, inodesInPath.getLatestSnapshotId());
        }
        if (groupname != null) {
            inode.setGroup(groupname, inodesInPath.getLatestSnapshotId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void concat(String target, String[] srcs, long timestamp) throws UnresolvedLinkException, QuotaExceededException, SnapshotAccessControlException, SnapshotException {
        this.writeLock();
        try {
            this.unprotectedConcat(target, srcs, timestamp);
        }
        finally {
            this.writeUnlock();
        }
    }

    void unprotectedConcat(String target, String[] srcs, long timestamp) throws UnresolvedLinkException, QuotaExceededException, SnapshotAccessControlException, SnapshotException {
        assert (this.hasWriteLock());
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* FSNamesystem.concat to " + target);
        }
        INodesInPath trgIIP = this.getINodesInPath4Write(target, true);
        INode[] trgINodes = trgIIP.getINodes();
        INodeFile trgInode = trgIIP.getLastINode().asFile();
        INodeDirectory trgParent = trgINodes[trgINodes.length - 2].asDirectory();
        int trgLatestSnapshot = trgIIP.getLatestSnapshotId();
        INodeFile[] allSrcInodes = new INodeFile[srcs.length];
        for (int i = 0; i < srcs.length; ++i) {
            INodesInPath iip = this.getINodesInPath4Write(srcs[i]);
            int latest = iip.getLatestSnapshotId();
            INode inode = iip.getLastINode();
            if (inode.isInLatestSnapshot(latest)) {
                throw new SnapshotException("Concat: the source file " + srcs[i] + " is in snapshot " + latest);
            }
            if (inode.isReference() && ((INodeReference.WithCount)inode.asReference().getReferredINode()).getReferenceCount() > 1) {
                throw new SnapshotException("Concat: the source file " + srcs[i] + " is referred by some other reference in some snapshot.");
            }
            allSrcInodes[i] = inode.asFile();
        }
        trgInode.concatBlocks(allSrcInodes);
        int count = 0;
        for (INodeFile nodeToRemove : allSrcInodes) {
            if (nodeToRemove == null) continue;
            nodeToRemove.setBlocks(null);
            trgParent.removeChild(nodeToRemove, trgLatestSnapshot);
            this.inodeMap.remove(nodeToRemove);
            ++count;
        }
        this.removeFromInodeMap(Arrays.asList(allSrcInodes));
        trgInode.setModificationTime(timestamp, trgLatestSnapshot);
        trgParent.updateModificationTime(timestamp, trgLatestSnapshot);
        FSDirectory.unprotectedUpdateCount(trgIIP, trgINodes.length - 1, -count, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long delete(String src, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes, long mtime) throws IOException {
        long filesRemoved;
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* FSDirectory.delete: " + src);
        }
        this.writeLock();
        try {
            INodesInPath inodesInPath = this.getINodesInPath4Write(FSDirectory.normalizePath(src), false);
            if (!FSDirectory.deleteAllowed(inodesInPath, src)) {
                filesRemoved = -1L;
            } else {
                ArrayList<INodeDirectorySnapshottable> snapshottableDirs = new ArrayList<INodeDirectorySnapshottable>();
                FSDirectory.checkSnapshot(inodesInPath.getLastINode(), snapshottableDirs);
                filesRemoved = this.unprotectedDelete(inodesInPath, collectedBlocks, removedINodes, mtime);
                this.namesystem.removeSnapshottableDirs(snapshottableDirs);
            }
        }
        finally {
            this.writeUnlock();
        }
        return filesRemoved;
    }

    private static boolean deleteAllowed(INodesInPath iip, String src) {
        INode[] inodes = iip.getINodes();
        if (inodes == null || inodes.length == 0 || inodes[inodes.length - 1] == null) {
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug("DIR* FSDirectory.unprotectedDelete: failed to remove " + src + " because it does not exist");
            }
            return false;
        }
        if (inodes.length == 1) {
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedDelete: failed to remove " + src + " because the root is not allowed to be deleted");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isNonEmptyDirectory(String path) throws UnresolvedLinkException {
        this.readLock();
        try {
            INodesInPath inodesInPath = this.getLastINodeInPath(path, false);
            INode inode = inodesInPath.getINode(0);
            if (inode == null || !inode.isDirectory()) {
                boolean bl = false;
                return bl;
            }
            int s = inodesInPath.getPathSnapshotId();
            boolean bl = !inode.asDirectory().getChildrenList(s).isEmpty();
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    void unprotectedDelete(String src, long mtime) throws UnresolvedLinkException, QuotaExceededException, SnapshotAccessControlException, IOException {
        assert (this.hasWriteLock());
        INode.BlocksMapUpdateInfo collectedBlocks = new INode.BlocksMapUpdateInfo();
        ChunkedArrayList<INode> removedINodes = new ChunkedArrayList<INode>();
        INodesInPath inodesInPath = this.getINodesInPath4Write(FSDirectory.normalizePath(src), false);
        long filesRemoved = -1L;
        if (FSDirectory.deleteAllowed(inodesInPath, src)) {
            ArrayList<INodeDirectorySnapshottable> snapshottableDirs = new ArrayList<INodeDirectorySnapshottable>();
            FSDirectory.checkSnapshot(inodesInPath.getLastINode(), snapshottableDirs);
            filesRemoved = this.unprotectedDelete(inodesInPath, collectedBlocks, removedINodes, mtime);
            this.namesystem.removeSnapshottableDirs(snapshottableDirs);
        }
        if (filesRemoved >= 0L) {
            this.getFSNamesystem().removePathAndBlocks(src, collectedBlocks, removedINodes, false);
        }
    }

    long unprotectedDelete(INodesInPath iip, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes, long mtime) throws QuotaExceededException {
        assert (this.hasWriteLock());
        INode targetNode = iip.getLastINode();
        if (targetNode == null) {
            return -1L;
        }
        int latestSnapshot = iip.getLatestSnapshotId();
        targetNode = targetNode.recordModification(latestSnapshot);
        iip.setLastINode(targetNode);
        long removed = this.removeLastINode(iip);
        if (removed == -1L) {
            return -1L;
        }
        INodeDirectory parent = targetNode.getParent();
        parent.updateModificationTime(mtime, latestSnapshot);
        if (removed == 0L) {
            return 0L;
        }
        if (!targetNode.isInLatestSnapshot(latestSnapshot)) {
            targetNode.destroyAndCollectBlocks(collectedBlocks, removedINodes);
        } else {
            Quota.Counts counts = targetNode.cleanSubtree(0x7FFFFFFE, latestSnapshot, collectedBlocks, removedINodes, true);
            parent.addSpaceConsumed(-counts.get(Quota.NAMESPACE), -counts.get(Quota.DISKSPACE), true);
            removed = counts.get(Quota.NAMESPACE);
        }
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* FSDirectory.unprotectedDelete: " + targetNode.getFullPathName() + " is removed");
        }
        return removed;
    }

    private static void checkSnapshot(INode target, List<INodeDirectorySnapshottable> snapshottableDirs) throws SnapshotException {
        if (target.isDirectory()) {
            INodeDirectory targetDir = target.asDirectory();
            if (targetDir.isSnapshottable()) {
                INodeDirectorySnapshottable ssTargetDir = (INodeDirectorySnapshottable)targetDir;
                if (ssTargetDir.getNumSnapshots() > 0) {
                    throw new SnapshotException("The directory " + ssTargetDir.getFullPathName() + " cannot be deleted since " + ssTargetDir.getFullPathName() + " is snapshottable and already has snapshots");
                }
                if (snapshottableDirs != null) {
                    snapshottableDirs.add(ssTargetDir);
                }
            }
            for (INode child : targetDir.getChildrenList(0x7FFFFFFE)) {
                FSDirectory.checkSnapshot(child, snapshottableDirs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DirectoryListing getListing(String src, byte[] startAfter, boolean needLocation) throws UnresolvedLinkException, IOException {
        String srcs = FSDirectory.normalizePath(src);
        this.readLock();
        try {
            if (srcs.endsWith("/.snapshot")) {
                DirectoryListing directoryListing = this.getSnapshotsListing(srcs, startAfter);
                return directoryListing;
            }
            INodesInPath inodesInPath = this.getLastINodeInPath(srcs, true);
            int snapshot = inodesInPath.getPathSnapshotId();
            INode targetNode = inodesInPath.getINode(0);
            if (targetNode == null) {
                DirectoryListing directoryListing = null;
                return directoryListing;
            }
            if (!targetNode.isDirectory()) {
                DirectoryListing directoryListing = new DirectoryListing(new HdfsFileStatus[]{this.createFileStatus(HdfsFileStatus.EMPTY_NAME, targetNode, needLocation, snapshot)}, 0);
                return directoryListing;
            }
            INodeDirectory dirInode = targetNode.asDirectory();
            ReadOnlyList<INode> contents = dirInode.getChildrenList(snapshot);
            int startChild = INodeDirectory.nextChild(contents, startAfter);
            int totalNumChildren = contents.size();
            int numOfListing = Math.min(totalNumChildren - startChild, this.lsLimit);
            int locationBudget = this.lsLimit;
            int listingCnt = 0;
            HdfsFileStatus[] listing = new HdfsFileStatus[numOfListing];
            for (int i = 0; i < numOfListing && locationBudget > 0; ++i) {
                INode cur = contents.get(startChild + i);
                listing[i] = this.createFileStatus(cur.getLocalNameBytes(), cur, needLocation, snapshot);
                ++listingCnt;
                if (!needLocation) continue;
                LocatedBlocks blks = ((HdfsLocatedFileStatus)listing[i]).getBlockLocations();
                locationBudget -= blks == null ? 0 : blks.locatedBlockCount() * listing[i].getReplication();
            }
            if (listingCnt < numOfListing) {
                listing = Arrays.copyOf(listing, listingCnt);
            }
            DirectoryListing directoryListing = new DirectoryListing(listing, totalNumChildren - startChild - listingCnt);
            return directoryListing;
        }
        finally {
            this.readUnlock();
        }
    }

    private DirectoryListing getSnapshotsListing(String src, byte[] startAfter) throws UnresolvedLinkException, IOException {
        Preconditions.checkState(this.hasReadLock());
        Preconditions.checkArgument(src.endsWith("/.snapshot"), "%s does not end with %s", src, "/.snapshot");
        String dirPath = FSDirectory.normalizePath(src.substring(0, src.length() - ".snapshot".length()));
        INode node = this.getINode(dirPath);
        INodeDirectorySnapshottable dirNode = INodeDirectorySnapshottable.valueOf(node, dirPath);
        ReadOnlyList<Snapshot> snapshots = dirNode.getSnapshotList();
        int skipSize = ReadOnlyList.Util.binarySearch(snapshots, startAfter);
        skipSize = skipSize < 0 ? -skipSize - 1 : skipSize + 1;
        int numOfListing = Math.min(snapshots.size() - skipSize, this.lsLimit);
        HdfsFileStatus[] listing = new HdfsFileStatus[numOfListing];
        for (int i = 0; i < numOfListing; ++i) {
            Snapshot.Root sRoot = snapshots.get(i + skipSize).getRoot();
            listing[i] = this.createFileStatus(sRoot.getLocalNameBytes(), sRoot, 0x7FFFFFFE);
        }
        return new DirectoryListing(listing, snapshots.size() - skipSize - numOfListing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HdfsFileStatus getFileInfo(String src, boolean resolveLink) throws UnresolvedLinkException {
        String srcs = FSDirectory.normalizePath(src);
        this.readLock();
        try {
            if (srcs.endsWith("/.snapshot")) {
                HdfsFileStatus hdfsFileStatus = this.getFileInfo4DotSnapshot(srcs);
                return hdfsFileStatus;
            }
            INodesInPath inodesInPath = this.getLastINodeInPath(srcs, resolveLink);
            INode i = inodesInPath.getINode(0);
            HdfsFileStatus hdfsFileStatus = i == null ? null : this.createFileStatus(HdfsFileStatus.EMPTY_NAME, i, inodesInPath.getPathSnapshotId());
            return hdfsFileStatus;
        }
        finally {
            this.readUnlock();
        }
    }

    private HdfsFileStatus getFileInfo4DotSnapshot(String src) throws UnresolvedLinkException {
        if (this.getINode4DotSnapshot(src) != null) {
            return new HdfsFileStatus(0L, true, 0, 0L, 0L, 0L, null, null, null, null, HdfsFileStatus.EMPTY_NAME, -1L, 0);
        }
        return null;
    }

    private INode getINode4DotSnapshot(String src) throws UnresolvedLinkException {
        Preconditions.checkArgument(src.endsWith("/.snapshot"), "%s does not end with %s", src, "/.snapshot");
        String dirPath = FSDirectory.normalizePath(src.substring(0, src.length() - ".snapshot".length()));
        INode node = this.getINode(dirPath);
        if (node != null && node.isDirectory() && node.asDirectory() instanceof INodeDirectorySnapshottable) {
            return node;
        }
        return null;
    }

    INodesInPath getExistingPathINodes(byte[][] components) throws UnresolvedLinkException {
        return INodesInPath.resolve(this.rootDir, components);
    }

    public INode getINode(String src) throws UnresolvedLinkException {
        return this.getLastINodeInPath(src).getINode(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INodesInPath getLastINodeInPath(String src) throws UnresolvedLinkException {
        this.readLock();
        try {
            INodesInPath iNodesInPath = this.getLastINodeInPath(src, true);
            return iNodesInPath;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INodesInPath getINodesInPath4Write(String src) throws UnresolvedLinkException, SnapshotAccessControlException {
        this.readLock();
        try {
            INodesInPath iNodesInPath = this.getINodesInPath4Write(src, true);
            return iNodesInPath;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INode getINode4Write(String src) throws UnresolvedLinkException, SnapshotAccessControlException {
        this.readLock();
        try {
            INode iNode = this.getINode4Write(src, true);
            return iNode;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isValidToCreate(String src) throws UnresolvedLinkException, SnapshotAccessControlException {
        String srcs = FSDirectory.normalizePath(src);
        this.readLock();
        try {
            boolean bl = srcs.startsWith("/") && !srcs.endsWith("/") && this.getINode4Write(srcs, false) == null;
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDir(String src) throws UnresolvedLinkException {
        src = FSDirectory.normalizePath(src);
        this.readLock();
        try {
            INode node = this.getNode(src, false);
            boolean bl = node != null && node.isDirectory();
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDirMutable(String src) throws UnresolvedLinkException, SnapshotAccessControlException {
        src = FSDirectory.normalizePath(src);
        this.readLock();
        try {
            INode node = this.getINode4Write(src, false);
            boolean bl = node != null && node.isDirectory();
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSpaceConsumed(String path, long nsDelta, long dsDelta) throws QuotaExceededException, FileNotFoundException, UnresolvedLinkException, SnapshotAccessControlException {
        this.writeLock();
        try {
            INodesInPath iip = this.getINodesInPath4Write(path, false);
            if (iip.getLastINode() == null) {
                throw new FileNotFoundException("Path not found: " + path);
            }
            this.updateCount(iip, nsDelta, dsDelta, true);
        }
        finally {
            this.writeUnlock();
        }
    }

    private void updateCount(INodesInPath iip, long nsDelta, long dsDelta, boolean checkQuota) throws QuotaExceededException {
        this.updateCount(iip, iip.getINodes().length - 1, nsDelta, dsDelta, checkQuota);
    }

    private void updateCount(INodesInPath iip, int numOfINodes, long nsDelta, long dsDelta, boolean checkQuota) throws QuotaExceededException {
        assert (this.hasWriteLock());
        if (!this.namesystem.isImageLoaded()) {
            return;
        }
        INode[] inodes = iip.getINodes();
        if (numOfINodes > inodes.length) {
            numOfINodes = inodes.length;
        }
        if (checkQuota && !this.skipQuotaCheck) {
            FSDirectory.verifyQuota(inodes, numOfINodes, nsDelta, dsDelta, null);
        }
        FSDirectory.unprotectedUpdateCount(iip, numOfINodes, nsDelta, dsDelta);
    }

    private void updateCountNoQuotaCheck(INodesInPath inodesInPath, int numOfINodes, long nsDelta, long dsDelta) {
        assert (this.hasWriteLock());
        try {
            this.updateCount(inodesInPath, numOfINodes, nsDelta, dsDelta, false);
        }
        catch (QuotaExceededException e) {
            NameNode.LOG.error("BUG: unexpected exception ", e);
        }
    }

    private static void unprotectedUpdateCount(INodesInPath inodesInPath, int numOfINodes, long nsDelta, long dsDelta) {
        INode[] inodes = inodesInPath.getINodes();
        for (int i = 0; i < numOfINodes; ++i) {
            if (!inodes[i].isQuotaSet()) continue;
            inodes[i].asDirectory().getDirectoryWithQuotaFeature().addSpaceConsumed2Cache(nsDelta, dsDelta);
        }
    }

    static String getFullPathName(INode[] inodes, int pos) {
        StringBuilder fullPathName = new StringBuilder();
        if (inodes[0].isRoot()) {
            if (pos == 0) {
                return "/";
            }
        } else {
            fullPathName.append(inodes[0].getLocalName());
        }
        for (int i = 1; i <= pos; ++i) {
            fullPathName.append('/').append(inodes[i].getLocalName());
        }
        return fullPathName.toString();
    }

    private static INode[] getRelativePathINodes(INode inode, INode ancestor) {
        int depth = 0;
        for (INode i = inode; i != null && !i.equals(ancestor); i = i.getParent()) {
            ++depth;
        }
        INode[] inodes = new INode[depth];
        for (int i = 0; i < depth; ++i) {
            if (inode == null) {
                NameNode.stateChangeLog.warn("Could not get full path. Corresponding file might have deleted already.");
                return null;
            }
            inodes[depth - i - 1] = inode;
            inode = inode.getParent();
        }
        return inodes;
    }

    private static INode[] getFullPathINodes(INode inode) {
        return FSDirectory.getRelativePathINodes(inode, null);
    }

    static String getFullPathName(INode inode) {
        INode[] inodes = FSDirectory.getFullPathINodes(inode);
        return inodes == null ? "" : FSDirectory.getFullPathName(inodes, inodes.length - 1);
    }

    INode unprotectedMkdir(long inodeId, String src, PermissionStatus permissions, List<AclEntry> aclEntries, long timestamp) throws QuotaExceededException, UnresolvedLinkException, AclException {
        assert (this.hasWriteLock());
        byte[][] components = INode.getPathComponents(src);
        INodesInPath iip = this.getExistingPathINodes(components);
        INode[] inodes = iip.getINodes();
        int pos = inodes.length - 1;
        this.unprotectedMkdir(inodeId, iip, pos, components[pos], permissions, aclEntries, timestamp);
        return inodes[pos];
    }

    void unprotectedMkdir(long inodeId, INodesInPath inodesInPath, int pos, byte[] name, PermissionStatus permission, List<AclEntry> aclEntries, long timestamp) throws QuotaExceededException, AclException {
        assert (this.hasWriteLock());
        INodeDirectory dir = new INodeDirectory(inodeId, name, permission, timestamp);
        if (this.addChild(inodesInPath, pos, dir, true)) {
            if (aclEntries != null) {
                AclStorage.updateINodeAcl(dir, aclEntries, 0x7FFFFFFE);
            }
            inodesInPath.setINode(pos, dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addINode(String src, INode child) throws QuotaExceededException, UnresolvedLinkException {
        byte[][] components = INode.getPathComponents(src);
        child.setLocalName(components[components.length - 1]);
        this.cacheName(child);
        this.writeLock();
        try {
            boolean bl = this.addLastINode(this.getExistingPathINodes(components), child, true);
            return bl;
        }
        finally {
            this.writeUnlock();
        }
    }

    private static void verifyQuota(INode[] inodes, int pos, long nsDelta, long dsDelta, INode commonAncestor) throws QuotaExceededException {
        if (nsDelta <= 0L && dsDelta <= 0L) {
            return;
        }
        for (int i = (pos > inodes.length ? inodes.length : pos) - 1; i >= 0; --i) {
            if (commonAncestor == inodes[i]) {
                return;
            }
            DirectoryWithQuotaFeature q = inodes[i].asDirectory().getDirectoryWithQuotaFeature();
            if (q == null) continue;
            try {
                q.verifyQuota(nsDelta, dsDelta);
                continue;
            }
            catch (QuotaExceededException e) {
                e.setPathName(FSDirectory.getFullPathName(inodes, i));
                throw e;
            }
        }
    }

    private void verifyQuotaForRename(INode[] src, INode[] dst) throws QuotaExceededException {
        if (!this.namesystem.isImageLoaded() || this.skipQuotaCheck) {
            return;
        }
        int i = 0;
        while (src[i] == dst[i]) {
            ++i;
        }
        Quota.Counts delta = src[src.length - 1].computeQuotaUsage();
        int dstIndex = dst.length - 1;
        if (dst[dstIndex] != null) {
            delta.subtract(dst[dstIndex].computeQuotaUsage());
        }
        FSDirectory.verifyQuota(dst, dstIndex, delta.get(Quota.NAMESPACE), delta.get(Quota.DISKSPACE), src[i - 1]);
    }

    private void verifyFsLimitsForRename(INodesInPath srcIIP, INodesInPath dstIIP) throws FSLimitException.PathComponentTooLongException, FSLimitException.MaxDirectoryItemsExceededException {
        byte[] dstChildName = dstIIP.getLastLocalName();
        INode[] dstInodes = dstIIP.getINodes();
        int pos = dstInodes.length - 1;
        this.verifyMaxComponentLength(dstChildName, dstInodes, pos);
        if (srcIIP.getINode(-2) != dstIIP.getINode(-2)) {
            this.verifyMaxDirItems(dstInodes, pos);
        }
    }

    void verifySnapshotName(String snapshotName, String path) throws FSLimitException.PathComponentTooLongException {
        if (snapshotName.contains("/")) {
            throw new HadoopIllegalArgumentException("Snapshot name cannot contain \"/\"");
        }
        byte[] bytes = DFSUtil.string2Bytes(snapshotName);
        this.verifyINodeName(bytes);
        this.verifyMaxComponentLength(bytes, path, 0);
    }

    void verifyINodeName(byte[] childName) throws HadoopIllegalArgumentException {
        if (Arrays.equals(HdfsConstants.DOT_SNAPSHOT_DIR_BYTES, childName)) {
            String s = "\".snapshot\" is a reserved name.";
            if (!this.namesystem.isImageLoaded()) {
                s = s + "  Please rename it before upgrade.";
            }
            throw new HadoopIllegalArgumentException(s);
        }
    }

    private void verifyMaxComponentLength(byte[] childName, Object parentPath, int pos) throws FSLimitException.PathComponentTooLongException {
        if (this.maxComponentLength == 0) {
            return;
        }
        int length = childName.length;
        if (length > this.maxComponentLength) {
            String p = parentPath instanceof INode[] ? FSDirectory.getFullPathName((INode[])parentPath, pos - 1) : (String)parentPath;
            FSLimitException.PathComponentTooLongException e = new FSLimitException.PathComponentTooLongException(this.maxComponentLength, length, p, DFSUtil.bytes2String(childName));
            if (this.namesystem.isImageLoaded()) {
                throw e;
            }
            NameNode.LOG.error("ERROR in FSDirectory.verifyINodeName", e);
        }
    }

    private void verifyMaxDirItems(INode[] pathComponents, int pos) throws FSLimitException.MaxDirectoryItemsExceededException {
        INodeDirectory parent = pathComponents[pos - 1].asDirectory();
        int count = parent.getChildrenList(0x7FFFFFFE).size();
        if (count >= this.maxDirItems) {
            FSLimitException.MaxDirectoryItemsExceededException e = new FSLimitException.MaxDirectoryItemsExceededException(this.maxDirItems, count);
            if (this.namesystem.isImageLoaded()) {
                e.setPathName(FSDirectory.getFullPathName(pathComponents, pos - 1));
                throw e;
            }
            NameNode.LOG.error("FSDirectory.verifyMaxDirItems: " + e.getLocalizedMessage());
        }
    }

    private boolean addLastINode(INodesInPath inodesInPath, INode inode, boolean checkQuota) throws QuotaExceededException {
        int pos = inodesInPath.getINodes().length - 1;
        return this.addChild(inodesInPath, pos, inode, checkQuota);
    }

    private boolean addChild(INodesInPath iip, int pos, INode child, boolean checkQuota) throws QuotaExceededException {
        boolean added;
        INode[] inodes = iip.getINodes();
        if (pos == 1 && inodes[0] == this.rootDir && FSDirectory.isReservedName(child)) {
            throw new HadoopIllegalArgumentException("File name \"" + child.getLocalName() + "\" is reserved and cannot " + "be created. If this is during upgrade change the name of the " + "existing file or directory to another name before upgrading " + "to the new release.");
        }
        if (checkQuota) {
            this.verifyMaxComponentLength(child.getLocalNameBytes(), inodes, pos);
            this.verifyMaxDirItems(inodes, pos);
        }
        this.verifyINodeName(child.getLocalNameBytes());
        Quota.Counts counts = child.computeQuotaUsage();
        this.updateCount(iip, pos, counts.get(Quota.NAMESPACE), counts.get(Quota.DISKSPACE), checkQuota);
        boolean isRename = child.getParent() != null;
        INodeDirectory parent = inodes[pos - 1].asDirectory();
        try {
            added = parent.addChild(child, true, iip.getLatestSnapshotId());
        }
        catch (QuotaExceededException e) {
            this.updateCountNoQuotaCheck(iip, pos, -counts.get(Quota.NAMESPACE), -counts.get(Quota.DISKSPACE));
            throw e;
        }
        if (!added) {
            this.updateCountNoQuotaCheck(iip, pos, -counts.get(Quota.NAMESPACE), -counts.get(Quota.DISKSPACE));
        } else {
            iip.setINode(pos - 1, child.getParent());
            if (!isRename) {
                AclStorage.copyINodeDefaultAcl(child);
            }
            this.addToInodeMap(child);
        }
        return added;
    }

    private boolean addLastINodeNoQuotaCheck(INodesInPath inodesInPath, INode i) {
        try {
            return this.addLastINode(inodesInPath, i, false);
        }
        catch (QuotaExceededException e) {
            NameNode.LOG.warn("FSDirectory.addChildNoQuotaCheck - unexpected", e);
            return false;
        }
    }

    private long removeLastINode(INodesInPath iip) throws QuotaExceededException {
        int latestSnapshot = iip.getLatestSnapshotId();
        INode last = iip.getLastINode();
        INodeDirectory parent = iip.getINode(-2).asDirectory();
        if (!parent.removeChild(last, latestSnapshot)) {
            return -1L;
        }
        if (!last.isInLatestSnapshot(latestSnapshot)) {
            Quota.Counts counts = last.computeQuotaUsage();
            this.updateCountNoQuotaCheck(iip, iip.getINodes().length - 1, -counts.get(Quota.NAMESPACE), -counts.get(Quota.DISKSPACE));
            if (INodeReference.tryRemoveReference(last) > 0) {
                return 0L;
            }
            return counts.get(Quota.NAMESPACE);
        }
        return 1L;
    }

    static String normalizePath(String src) {
        if (src.length() > 1 && src.endsWith("/")) {
            src = src.substring(0, src.length() - 1);
        }
        return src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ContentSummary getContentSummary(String src) throws FileNotFoundException, UnresolvedLinkException {
        String srcs = FSDirectory.normalizePath(src);
        this.readLock();
        try {
            INode targetNode = this.getNode(srcs, false);
            if (targetNode == null) {
                throw new FileNotFoundException("File does not exist: " + srcs);
            }
            ContentSummaryComputationContext cscc = new ContentSummaryComputationContext(this, this.getFSNamesystem(), this.contentCountLimit);
            ContentSummary cs = targetNode.computeAndConvertContentSummary(cscc);
            this.yieldCount += cscc.getYieldCount();
            ContentSummary contentSummary = cs;
            return contentSummary;
        }
        finally {
            this.readUnlock();
        }
    }

    @VisibleForTesting
    public long getYieldCount() {
        return this.yieldCount;
    }

    public INodeMap getINodeMap() {
        return this.inodeMap;
    }

    public final void addToInodeMap(INode inode) {
        if (inode instanceof INodeWithAdditionalFields) {
            this.inodeMap.put(inode);
        }
    }

    public final void removeFromInodeMap(List<? extends INode> inodes) {
        if (inodes != null) {
            for (INode iNode : inodes) {
                if (iNode == null || !(iNode instanceof INodeWithAdditionalFields)) continue;
                this.inodeMap.remove(iNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INode getInode(long id) {
        this.readLock();
        try {
            INode iNode = this.inodeMap.get(id);
            return iNode;
        }
        finally {
            this.readUnlock();
        }
    }

    @VisibleForTesting
    int getInodeMapSize() {
        return this.inodeMap.size();
    }

    INodeDirectory unprotectedSetQuota(String src, long nsQuota, long dsQuota) throws FileNotFoundException, PathIsNotDirectoryException, QuotaExceededException, UnresolvedLinkException, SnapshotAccessControlException {
        assert (this.hasWriteLock());
        if (nsQuota < 0L && nsQuota != Long.MAX_VALUE && nsQuota < -1L || dsQuota < 0L && dsQuota != Long.MAX_VALUE && dsQuota < -1L) {
            throw new IllegalArgumentException("Illegal value for nsQuota or dsQuota : " + nsQuota + " and " + dsQuota);
        }
        String srcs = FSDirectory.normalizePath(src);
        INodesInPath iip = this.getINodesInPath4Write(srcs, true);
        INodeDirectory dirNode = INodeDirectory.valueOf(iip.getLastINode(), srcs);
        if (dirNode.isRoot() && nsQuota == -1L) {
            throw new IllegalArgumentException("Cannot clear namespace quota on root.");
        }
        Quota.Counts oldQuota = dirNode.getQuotaCounts();
        long oldNsQuota = oldQuota.get(Quota.NAMESPACE);
        long oldDsQuota = oldQuota.get(Quota.DISKSPACE);
        if (nsQuota == Long.MAX_VALUE) {
            nsQuota = oldNsQuota;
        }
        if (dsQuota == Long.MAX_VALUE) {
            dsQuota = oldDsQuota;
        }
        if (oldNsQuota == nsQuota && oldDsQuota == dsQuota) {
            return null;
        }
        int latest = iip.getLatestSnapshotId();
        dirNode = dirNode.recordModification(latest);
        dirNode.setQuota(nsQuota, dsQuota);
        return dirNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INodeDirectory setQuota(String src, long nsQuota, long dsQuota) throws FileNotFoundException, PathIsNotDirectoryException, QuotaExceededException, UnresolvedLinkException, SnapshotAccessControlException {
        this.writeLock();
        try {
            INodeDirectory iNodeDirectory = this.unprotectedSetQuota(src, nsQuota, dsQuota);
            return iNodeDirectory;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long totalInodes() {
        this.readLock();
        try {
            long l = this.rootDir.getDirectoryWithQuotaFeature().getSpaceConsumed().get(Quota.NAMESPACE);
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setTimes(INode inode, long mtime, long atime, boolean force, int latestSnapshotId) throws QuotaExceededException {
        this.writeLock();
        try {
            boolean bl = this.unprotectedSetTimes(inode, mtime, atime, force, latestSnapshotId);
            return bl;
        }
        finally {
            this.writeUnlock();
        }
    }

    boolean unprotectedSetTimes(String src, long mtime, long atime, boolean force) throws UnresolvedLinkException, QuotaExceededException {
        assert (this.hasWriteLock());
        INodesInPath i = this.getLastINodeInPath(src);
        return this.unprotectedSetTimes(i.getLastINode(), mtime, atime, force, i.getLatestSnapshotId());
    }

    private boolean unprotectedSetTimes(INode inode, long mtime, long atime, boolean force, int latest) throws QuotaExceededException {
        assert (this.hasWriteLock());
        boolean status = false;
        if (mtime != -1L) {
            inode = inode.setModificationTime(mtime, latest);
            status = true;
        }
        if (atime != -1L) {
            long inodeTime = inode.getAccessTime();
            if (atime <= inodeTime + this.getFSNamesystem().getAccessTimePrecision() && !force) {
                status = false;
            } else {
                inode.setAccessTime(atime, latest);
                status = true;
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        this.writeLock();
        try {
            this.rootDir = FSDirectory.createRoot(this.getFSNamesystem());
            this.inodeMap.clear();
            this.addToInodeMap(this.rootDir);
            this.nameCache.reset();
        }
        finally {
            this.writeUnlock();
        }
    }

    private HdfsFileStatus createFileStatus(byte[] path, INode node, boolean needLocation, int snapshot) throws IOException {
        if (needLocation) {
            return this.createLocatedFileStatus(path, node, snapshot);
        }
        return this.createFileStatus(path, node, snapshot);
    }

    HdfsFileStatus createFileStatus(byte[] path, INode node, int snapshot) {
        long size = 0L;
        short replication = 0;
        long blocksize = 0L;
        if (node.isFile()) {
            INodeFile fileNode = node.asFile();
            size = fileNode.computeFileSize(snapshot);
            replication = fileNode.getFileReplication(snapshot);
            blocksize = fileNode.getPreferredBlockSize();
        }
        int childrenNum = node.isDirectory() ? node.asDirectory().getChildrenNum(snapshot) : 0;
        return new HdfsFileStatus(size, node.isDirectory(), replication, blocksize, node.getModificationTime(snapshot), node.getAccessTime(snapshot), FSDirectory.getPermissionForFileStatus(node, snapshot), node.getUserName(snapshot), node.getGroupName(snapshot), node.isSymlink() ? node.asSymlink().getSymlink() : null, path, node.getId(), childrenNum);
    }

    private HdfsLocatedFileStatus createLocatedFileStatus(byte[] path, INode node, int snapshot) throws IOException {
        assert (this.hasReadLock());
        long size = 0L;
        short replication = 0;
        long blocksize = 0L;
        LocatedBlocks loc = null;
        if (node.isFile()) {
            INodeFile fileNode = node.asFile();
            size = fileNode.computeFileSize(snapshot);
            replication = fileNode.getFileReplication(snapshot);
            blocksize = fileNode.getPreferredBlockSize();
            boolean inSnapshot = snapshot != 0x7FFFFFFE;
            boolean isUc = !inSnapshot && fileNode.isUnderConstruction();
            long fileSize = !inSnapshot && isUc ? fileNode.computeFileSizeNotIncludingLastUcBlock() : size;
            loc = this.getFSNamesystem().getBlockManager().createLocatedBlocks(fileNode.getBlocks(), fileSize, isUc, 0L, size, false, inSnapshot);
            if (loc == null) {
                loc = new LocatedBlocks();
            }
        }
        int childrenNum = node.isDirectory() ? node.asDirectory().getChildrenNum(snapshot) : 0;
        HdfsLocatedFileStatus status = new HdfsLocatedFileStatus(size, node.isDirectory(), replication, blocksize, node.getModificationTime(snapshot), node.getAccessTime(snapshot), FSDirectory.getPermissionForFileStatus(node, snapshot), node.getUserName(snapshot), node.getGroupName(snapshot), node.isSymlink() ? node.asSymlink().getSymlink() : null, path, node.getId(), loc, childrenNum);
        if (loc != null) {
            CacheManager cacheManager = this.namesystem.getCacheManager();
            for (LocatedBlock lb : loc.getLocatedBlocks()) {
                cacheManager.setCachedLocations(lb);
            }
        }
        return status;
    }

    private static FsPermission getPermissionForFileStatus(INode node, int snapshot) {
        FsPermission perm = node.getFsPermission(snapshot);
        if (node.getAclFeature(snapshot) != null) {
            perm = new FsAclPermission(perm);
        }
        return perm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INodeSymlink addSymlink(long id, String path, String target, long mtime, long atime, PermissionStatus perm) throws UnresolvedLinkException, QuotaExceededException {
        this.writeLock();
        try {
            INodeSymlink iNodeSymlink = this.unprotectedAddSymlink(id, path, target, mtime, atime, perm);
            return iNodeSymlink;
        }
        finally {
            this.writeUnlock();
        }
    }

    INodeSymlink unprotectedAddSymlink(long id, String path, String target, long mtime, long atime, PermissionStatus perm) throws UnresolvedLinkException, QuotaExceededException {
        assert (this.hasWriteLock());
        INodeSymlink symlink = new INodeSymlink(id, null, perm, mtime, atime, target);
        return this.addINode(path, symlink) ? symlink : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<AclEntry> modifyAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        this.writeLock();
        try {
            List<AclEntry> list = this.unprotectedModifyAclEntries(src, aclSpec);
            return list;
        }
        finally {
            this.writeUnlock();
        }
    }

    private List<AclEntry> unprotectedModifyAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        assert (this.hasWriteLock());
        INodesInPath iip = this.getINodesInPath4Write(FSDirectory.normalizePath(src), true);
        INode inode = FSDirectory.resolveLastINode(src, iip);
        int snapshotId = iip.getLatestSnapshotId();
        List<AclEntry> existingAcl = AclStorage.readINodeLogicalAcl(inode);
        List<AclEntry> newAcl = AclTransformation.mergeAclEntries(existingAcl, aclSpec);
        AclStorage.updateINodeAcl(inode, newAcl, snapshotId);
        return newAcl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<AclEntry> removeAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        this.writeLock();
        try {
            List<AclEntry> list = this.unprotectedRemoveAclEntries(src, aclSpec);
            return list;
        }
        finally {
            this.writeUnlock();
        }
    }

    private List<AclEntry> unprotectedRemoveAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        assert (this.hasWriteLock());
        INodesInPath iip = this.getINodesInPath4Write(FSDirectory.normalizePath(src), true);
        INode inode = FSDirectory.resolveLastINode(src, iip);
        int snapshotId = iip.getLatestSnapshotId();
        List<AclEntry> existingAcl = AclStorage.readINodeLogicalAcl(inode);
        List<AclEntry> newAcl = AclTransformation.filterAclEntriesByAclSpec(existingAcl, aclSpec);
        AclStorage.updateINodeAcl(inode, newAcl, snapshotId);
        return newAcl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<AclEntry> removeDefaultAcl(String src) throws IOException {
        this.writeLock();
        try {
            List<AclEntry> list = this.unprotectedRemoveDefaultAcl(src);
            return list;
        }
        finally {
            this.writeUnlock();
        }
    }

    private List<AclEntry> unprotectedRemoveDefaultAcl(String src) throws IOException {
        assert (this.hasWriteLock());
        INodesInPath iip = this.getINodesInPath4Write(FSDirectory.normalizePath(src), true);
        INode inode = FSDirectory.resolveLastINode(src, iip);
        int snapshotId = iip.getLatestSnapshotId();
        List<AclEntry> existingAcl = AclStorage.readINodeLogicalAcl(inode);
        List<AclEntry> newAcl = AclTransformation.filterDefaultAclEntries(existingAcl);
        AclStorage.updateINodeAcl(inode, newAcl, snapshotId);
        return newAcl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAcl(String src) throws IOException {
        this.writeLock();
        try {
            this.unprotectedRemoveAcl(src);
        }
        finally {
            this.writeUnlock();
        }
    }

    private void unprotectedRemoveAcl(String src) throws IOException {
        assert (this.hasWriteLock());
        INodesInPath iip = this.getINodesInPath4Write(FSDirectory.normalizePath(src), true);
        INode inode = FSDirectory.resolveLastINode(src, iip);
        int snapshotId = iip.getLatestSnapshotId();
        AclStorage.removeINodeAcl(inode, snapshotId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<AclEntry> setAcl(String src, List<AclEntry> aclSpec) throws IOException {
        this.writeLock();
        try {
            List<AclEntry> list = this.unprotectedSetAcl(src, aclSpec);
            return list;
        }
        finally {
            this.writeUnlock();
        }
    }

    List<AclEntry> unprotectedSetAcl(String src, List<AclEntry> aclSpec) throws IOException {
        if (aclSpec.isEmpty()) {
            this.unprotectedRemoveAcl(src);
            return AclFeature.EMPTY_ENTRY_LIST;
        }
        assert (this.hasWriteLock());
        INodesInPath iip = this.getINodesInPath4Write(FSDirectory.normalizePath(src), true);
        INode inode = FSDirectory.resolveLastINode(src, iip);
        int snapshotId = iip.getLatestSnapshotId();
        List<AclEntry> existingAcl = AclStorage.readINodeLogicalAcl(inode);
        List<AclEntry> newAcl = AclTransformation.replaceAclEntries(existingAcl, aclSpec);
        AclStorage.updateINodeAcl(inode, newAcl, snapshotId);
        return newAcl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AclStatus getAclStatus(String src) throws IOException {
        String srcs = FSDirectory.normalizePath(src);
        this.readLock();
        try {
            if (srcs.endsWith("/.snapshot") && this.getINode4DotSnapshot(srcs) != null) {
                AclStatus aclStatus = new AclStatus.Builder().owner("").group("").build();
                return aclStatus;
            }
            INodesInPath iip = this.getLastINodeInPath(srcs, true);
            INode inode = FSDirectory.resolveLastINode(src, iip);
            int snapshotId = iip.getPathSnapshotId();
            List<AclEntry> acl = AclStorage.readINodeAcl(inode, snapshotId);
            AclStatus aclStatus = new AclStatus.Builder().owner(inode.getUserName()).group(inode.getGroupName()).stickyBit(inode.getFsPermission(snapshotId).getStickyBit()).addEntries(acl).build();
            return aclStatus;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<XAttr> removeXAttrs(String src, List<XAttr> toRemove) throws IOException {
        this.writeLock();
        try {
            List<XAttr> list = this.unprotectedRemoveXAttrs(src, toRemove);
            return list;
        }
        finally {
            this.writeUnlock();
        }
    }

    List<XAttr> unprotectedRemoveXAttrs(String src, List<XAttr> toRemove) throws IOException {
        assert (this.hasWriteLock());
        INodesInPath iip = this.getINodesInPath4Write(FSDirectory.normalizePath(src), true);
        INode inode = FSDirectory.resolveLastINode(src, iip);
        int snapshotId = iip.getLatestSnapshotId();
        List<XAttr> existingXAttrs = XAttrStorage.readINodeXAttrs(inode);
        ArrayList<XAttr> removedXAttrs = Lists.newArrayListWithCapacity(toRemove.size());
        List<XAttr> newXAttrs = this.filterINodeXAttrs(existingXAttrs, toRemove, removedXAttrs);
        if (existingXAttrs.size() != newXAttrs.size()) {
            XAttrStorage.updateINodeXAttrs(inode, newXAttrs, snapshotId);
            return removedXAttrs;
        }
        return null;
    }

    @VisibleForTesting
    List<XAttr> filterINodeXAttrs(List<XAttr> existingXAttrs, List<XAttr> toFilter, List<XAttr> filtered) {
        if (existingXAttrs == null || existingXAttrs.isEmpty() || toFilter == null || toFilter.isEmpty()) {
            return existingXAttrs;
        }
        ArrayList<XAttr> newXAttrs = Lists.newArrayListWithCapacity(existingXAttrs.size());
        for (XAttr a : existingXAttrs) {
            boolean add = true;
            ListIterator<XAttr> it = toFilter.listIterator();
            while (it.hasNext()) {
                XAttr filter = it.next();
                if (!a.equalsIgnoreValue(filter)) continue;
                add = false;
                it.remove();
                filtered.add(filter);
                break;
            }
            if (!add) continue;
            newXAttrs.add(a);
        }
        return newXAttrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setXAttrs(String src, List<XAttr> xAttrs, EnumSet<XAttrSetFlag> flag) throws IOException {
        this.writeLock();
        try {
            this.unprotectedSetXAttrs(src, xAttrs, flag);
        }
        finally {
            this.writeUnlock();
        }
    }

    void unprotectedSetXAttrs(String src, List<XAttr> xAttrs, EnumSet<XAttrSetFlag> flag) throws QuotaExceededException, IOException {
        assert (this.hasWriteLock());
        INodesInPath iip = this.getINodesInPath4Write(FSDirectory.normalizePath(src), true);
        INode inode = FSDirectory.resolveLastINode(src, iip);
        int snapshotId = iip.getLatestSnapshotId();
        List<XAttr> existingXAttrs = XAttrStorage.readINodeXAttrs(inode);
        List<XAttr> newXAttrs = this.setINodeXAttrs(existingXAttrs, xAttrs, flag);
        XAttrStorage.updateINodeXAttrs(inode, newXAttrs, snapshotId);
    }

    List<XAttr> setINodeXAttrs(List<XAttr> existingXAttrs, List<XAttr> toSet, EnumSet<XAttrSetFlag> flag) throws IOException {
        for (int i = 0; i < toSet.size(); ++i) {
            for (int j = i + 1; j < toSet.size(); ++j) {
                if (!toSet.get(i).equalsIgnoreValue(toSet.get(j))) continue;
                throw new IOException("Cannot specify the same XAttr to be set more than once");
            }
        }
        int userVisibleXAttrsNum = 0;
        int newSize = existingXAttrs != null ? existingXAttrs.size() : 0;
        ArrayList<XAttr> xAttrs = Lists.newArrayListWithCapacity(newSize += toSet.size());
        for (XAttr xAttr : toSet) {
            boolean exist = false;
            if (existingXAttrs != null) {
                for (XAttr a : existingXAttrs) {
                    if (!a.equalsIgnoreValue(xAttr)) continue;
                    exist = true;
                    break;
                }
            }
            XAttrSetFlag.validate(xAttr.getName(), exist, flag);
            xAttrs.add(xAttr);
            if (!this.isUserVisible(xAttr)) continue;
            ++userVisibleXAttrsNum;
        }
        if (existingXAttrs != null) {
            for (XAttr existing : existingXAttrs) {
                boolean alreadySet = false;
                for (XAttr set : toSet) {
                    if (!set.equalsIgnoreValue(existing)) continue;
                    alreadySet = true;
                    break;
                }
                if (alreadySet) continue;
                xAttrs.add(existing);
                if (!this.isUserVisible(existing)) continue;
                ++userVisibleXAttrsNum;
            }
        }
        if (userVisibleXAttrsNum > this.inodeXAttrsLimit) {
            throw new IOException("Cannot add additional XAttr to inode, would exceed limit of " + this.inodeXAttrsLimit);
        }
        return xAttrs;
    }

    private boolean isUserVisible(XAttr xAttr) {
        return xAttr.getNameSpace() == XAttr.NameSpace.USER || xAttr.getNameSpace() == XAttr.NameSpace.TRUSTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<XAttr> getXAttrs(String src) throws IOException {
        String srcs = FSDirectory.normalizePath(src);
        this.readLock();
        try {
            INodesInPath iip = this.getLastINodeInPath(srcs, true);
            INode inode = FSDirectory.resolveLastINode(src, iip);
            int snapshotId = iip.getPathSnapshotId();
            List<XAttr> list = XAttrStorage.readINodeXAttrs(inode, snapshotId);
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    private static INode resolveLastINode(String src, INodesInPath iip) throws FileNotFoundException {
        INode inode = iip.getLastINode();
        if (inode == null) {
            throw new FileNotFoundException("cannot find " + src);
        }
        return inode;
    }

    void cacheName(INode inode) {
        if (!inode.isFile()) {
            return;
        }
        ByteArray name = new ByteArray(inode.getLocalNameBytes());
        if ((name = this.nameCache.put(name)) != null) {
            inode.setLocalName(name.getBytes());
        }
    }

    void shutdown() {
        this.nameCache.reset();
        this.inodeMap.clear();
    }

    public static byte[][] getPathComponents(INode inode) {
        ArrayList<byte[]> components = new ArrayList<byte[]>();
        components.add(0, inode.getLocalNameBytes());
        while (inode.getParent() != null) {
            components.add(0, inode.getParent().getLocalNameBytes());
            inode = inode.getParent();
        }
        return (byte[][])components.toArray((T[])new byte[components.size()][]);
    }

    static byte[][] getPathComponentsForReservedPath(String src) {
        return !FSDirectory.isReservedName(src) ? (byte[][])null : INode.getPathComponents(src);
    }

    public static boolean isReservedName(INode inode) {
        return CHECK_RESERVED_FILE_NAMES && Arrays.equals(inode.getLocalNameBytes(), DOT_RESERVED);
    }

    public static boolean isReservedName(String src) {
        return src.startsWith(DOT_RESERVED_PATH_PREFIX);
    }

    static String resolvePath(String src, byte[][] pathComponents, FSDirectory fsd) throws FileNotFoundException {
        long id;
        if (pathComponents == null || pathComponents.length <= 3) {
            return src;
        }
        if (!Arrays.equals(DOT_RESERVED, pathComponents[1]) || !Arrays.equals(DOT_INODES, pathComponents[2])) {
            return src;
        }
        String inodeId = DFSUtil.bytes2String(pathComponents[3]);
        try {
            id = Long.parseLong(inodeId);
        }
        catch (NumberFormatException e) {
            throw new FileNotFoundException("Invalid inode path: " + src);
        }
        if (id == 16385L && pathComponents.length == 4) {
            return "/";
        }
        INode inode = fsd.getInode(id);
        if (inode == null) {
            throw new FileNotFoundException("File for given inode path does not exist: " + src);
        }
        if (pathComponents.length > 4 && DFSUtil.bytes2String(pathComponents[4]).equals("..")) {
            INodeDirectory parent = inode.getParent();
            if (parent == null || ((INode)parent).getId() == 16385L) {
                return "/";
            }
            return parent.getFullPathName();
        }
        StringBuilder path = id == 16385L ? new StringBuilder() : new StringBuilder(inode.getFullPathName());
        for (int i = 4; i < pathComponents.length; ++i) {
            path.append("/").append(DFSUtil.bytes2String(pathComponents[i]));
        }
        if (NameNode.LOG.isDebugEnabled()) {
            NameNode.LOG.debug("Resolved path is " + path);
        }
        return path.toString();
    }

    private INodesInPath getLastINodeInPath(String path, boolean resolveLink) throws UnresolvedLinkException {
        return INodesInPath.resolve(this.rootDir, INode.getPathComponents(path), 1, resolveLink);
    }

    INodesInPath getINodesInPath(String path, boolean resolveLink) throws UnresolvedLinkException {
        byte[][] components = INode.getPathComponents(path);
        return INodesInPath.resolve(this.rootDir, components, components.length, resolveLink);
    }

    INode getNode(String path, boolean resolveLink) throws UnresolvedLinkException {
        return this.getLastINodeInPath(path, resolveLink).getINode(0);
    }

    private INode getINode4Write(String src, boolean resolveLink) throws UnresolvedLinkException, SnapshotAccessControlException {
        return this.getINodesInPath4Write(src, resolveLink).getLastINode();
    }

    private INodesInPath getINodesInPath4Write(String src, boolean resolveLink) throws UnresolvedLinkException, SnapshotAccessControlException {
        byte[][] components = INode.getPathComponents(src);
        INodesInPath inodesInPath = INodesInPath.resolve(this.rootDir, components, components.length, resolveLink);
        if (inodesInPath.isSnapshot()) {
            throw new SnapshotAccessControlException("Modification on a read-only snapshot is disallowed");
        }
        return inodesInPath;
    }

    private class RenameOperation {
        private final INodesInPath srcIIP;
        private final INodesInPath dstIIP;
        private final String src;
        private final String dst;
        private INode srcChild;
        private final INodeReference.WithCount withCount;
        private final int srcRefDstSnapshot;
        private final INodeDirectory srcParent;
        private final byte[] srcChildName;
        private final boolean isSrcInSnapshot;
        private final boolean srcChildIsReference;
        private final Quota.Counts oldSrcCounts;

        private RenameOperation(String src, String dst, INodesInPath srcIIP, INodesInPath dstIIP) throws QuotaExceededException {
            this.srcIIP = srcIIP;
            this.dstIIP = dstIIP;
            this.src = src;
            this.dst = dst;
            this.srcChild = srcIIP.getLastINode();
            this.srcChildName = this.srcChild.getLocalNameBytes();
            this.isSrcInSnapshot = this.srcChild.isInLatestSnapshot(srcIIP.getLatestSnapshotId());
            this.srcChildIsReference = this.srcChild.isReference();
            this.srcParent = srcIIP.getINode(-2).asDirectory();
            if (this.isSrcInSnapshot) {
                this.srcChild = this.srcChild.recordModification(srcIIP.getLatestSnapshotId());
            }
            this.srcRefDstSnapshot = this.srcChildIsReference ? this.srcChild.asReference().getDstSnapshotId() : 0x7FFFFFFE;
            this.oldSrcCounts = Quota.Counts.newInstance();
            if (this.isSrcInSnapshot) {
                INodeReference.WithName withName = srcIIP.getINode(-2).asDirectory().replaceChild4ReferenceWithName(this.srcChild, srcIIP.getLatestSnapshotId());
                this.withCount = (INodeReference.WithCount)withName.getReferredINode();
                this.srcChild = withName;
                srcIIP.setLastINode(this.srcChild);
                this.withCount.getReferredINode().computeQuotaUsage(this.oldSrcCounts, true);
            } else {
                this.withCount = this.srcChildIsReference ? (INodeReference.WithCount)this.srcChild.asReference().getReferredINode() : null;
            }
        }

        boolean addSourceToDestination() {
            INode toDst;
            INode dstParent = this.dstIIP.getINode(-2);
            this.srcChild = this.srcIIP.getLastINode();
            byte[] dstChildName = this.dstIIP.getLastLocalName();
            if (this.withCount == null) {
                this.srcChild.setLocalName(dstChildName);
                toDst = this.srcChild;
            } else {
                this.withCount.getReferredINode().setLocalName(dstChildName);
                int dstSnapshotId = this.dstIIP.getLatestSnapshotId();
                toDst = new INodeReference.DstReference(dstParent.asDirectory(), this.withCount, dstSnapshotId);
            }
            return FSDirectory.this.addLastINodeNoQuotaCheck(this.dstIIP, toDst);
        }

        void updateMtimeAndLease(long timestamp) throws QuotaExceededException {
            this.srcParent.updateModificationTime(timestamp, this.srcIIP.getLatestSnapshotId());
            INode dstParent = this.dstIIP.getINode(-2);
            dstParent.updateModificationTime(timestamp, this.dstIIP.getLatestSnapshotId());
            FSDirectory.this.getFSNamesystem().unprotectedChangeLease(this.src, this.dst);
        }

        void restoreSource() throws QuotaExceededException {
            INode oldSrcChild = this.srcChild;
            if (this.withCount == null) {
                this.srcChild.setLocalName(this.srcChildName);
            } else if (!this.srcChildIsReference) {
                this.srcChild = this.withCount.getReferredINode();
                this.srcChild.setLocalName(this.srcChildName);
            } else {
                this.withCount.removeReference(oldSrcChild.asReference());
                this.srcChild = new INodeReference.DstReference(this.srcParent, this.withCount, this.srcRefDstSnapshot);
                this.withCount.getReferredINode().setLocalName(this.srcChildName);
            }
            if (this.isSrcInSnapshot) {
                this.srcParent.undoRename4ScrParent(oldSrcChild.asReference(), this.srcChild);
            } else {
                FSDirectory.this.addLastINodeNoQuotaCheck(this.srcIIP, this.srcChild);
            }
        }

        void updateQuotasInSourceTree() throws QuotaExceededException {
            if (this.isSrcInSnapshot) {
                Quota.Counts newSrcCounts = this.srcChild.computeQuotaUsage(Quota.Counts.newInstance(), false);
                newSrcCounts.subtract(this.oldSrcCounts);
                this.srcParent.addSpaceConsumed(newSrcCounts.get(Quota.NAMESPACE), newSrcCounts.get(Quota.DISKSPACE), false);
            }
        }
    }
}

