/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DatanodeInfo
extends DatanodeID
implements Node {
    private long capacity;
    private long dfsUsed;
    private long remaining;
    private long blockPoolUsed;
    private long cacheCapacity;
    private long cacheUsed;
    private long lastUpdate;
    private int xceiverCount;
    private String location = "/default-rack";
    private String softwareVersion;
    private List<String> dependentHostNames = new LinkedList<String>();
    protected AdminStates adminState;
    private transient int level;
    private transient Node parent;

    public DatanodeInfo(DatanodeInfo from) {
        super(from);
        this.capacity = from.getCapacity();
        this.dfsUsed = from.getDfsUsed();
        this.remaining = from.getRemaining();
        this.blockPoolUsed = from.getBlockPoolUsed();
        this.cacheCapacity = from.getCacheCapacity();
        this.cacheUsed = from.getCacheUsed();
        this.lastUpdate = from.getLastUpdate();
        this.xceiverCount = from.getXceiverCount();
        this.location = from.getNetworkLocation();
        this.adminState = from.getAdminState();
    }

    public DatanodeInfo(DatanodeID nodeID) {
        super(nodeID);
        this.capacity = 0L;
        this.dfsUsed = 0L;
        this.remaining = 0L;
        this.blockPoolUsed = 0L;
        this.cacheCapacity = 0L;
        this.cacheUsed = 0L;
        this.lastUpdate = 0L;
        this.xceiverCount = 0;
        this.adminState = null;
    }

    public DatanodeInfo(DatanodeID nodeID, String location) {
        this(nodeID);
        this.location = location;
    }

    public DatanodeInfo(DatanodeID nodeID, String location, long capacity, long dfsUsed, long remaining, long blockPoolUsed, long cacheCapacity, long cacheUsed, long lastUpdate, int xceiverCount, AdminStates adminState) {
        this(nodeID.getIpAddr(), nodeID.getHostName(), nodeID.getDatanodeUuid(), nodeID.getXferPort(), nodeID.getInfoPort(), nodeID.getInfoSecurePort(), nodeID.getIpcPort(), capacity, dfsUsed, remaining, blockPoolUsed, cacheCapacity, cacheUsed, lastUpdate, xceiverCount, location, adminState);
    }

    public DatanodeInfo(String ipAddr, String hostName, String datanodeUuid, int xferPort, int infoPort, int infoSecurePort, int ipcPort, long capacity, long dfsUsed, long remaining, long blockPoolUsed, long cacheCapacity, long cacheUsed, long lastUpdate, int xceiverCount, String networkLocation, AdminStates adminState) {
        super(ipAddr, hostName, datanodeUuid, xferPort, infoPort, infoSecurePort, ipcPort);
        this.capacity = capacity;
        this.dfsUsed = dfsUsed;
        this.remaining = remaining;
        this.blockPoolUsed = blockPoolUsed;
        this.cacheCapacity = cacheCapacity;
        this.cacheUsed = cacheUsed;
        this.lastUpdate = lastUpdate;
        this.xceiverCount = xceiverCount;
        this.location = networkLocation;
        this.adminState = adminState;
    }

    @Override
    public String getName() {
        return this.getXferAddr();
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getDfsUsed() {
        return this.dfsUsed;
    }

    public long getBlockPoolUsed() {
        return this.blockPoolUsed;
    }

    public long getNonDfsUsed() {
        long nonDFSUsed = this.capacity - this.dfsUsed - this.remaining;
        return nonDFSUsed < 0L ? 0L : nonDFSUsed;
    }

    public float getDfsUsedPercent() {
        return DFSUtil.getPercentUsed(this.dfsUsed, this.capacity);
    }

    public long getRemaining() {
        return this.remaining;
    }

    public float getBlockPoolUsedPercent() {
        return DFSUtil.getPercentUsed(this.blockPoolUsed, this.capacity);
    }

    public float getRemainingPercent() {
        return DFSUtil.getPercentRemaining(this.remaining, this.capacity);
    }

    public long getCacheCapacity() {
        return this.cacheCapacity;
    }

    public long getCacheUsed() {
        return this.cacheUsed;
    }

    public float getCacheUsedPercent() {
        return DFSUtil.getPercentUsed(this.cacheUsed, this.cacheCapacity);
    }

    public long getCacheRemaining() {
        return this.cacheCapacity - this.cacheUsed;
    }

    public float getCacheRemainingPercent() {
        return DFSUtil.getPercentRemaining(this.getCacheRemaining(), this.cacheCapacity);
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public int getXceiverCount() {
        return this.xceiverCount;
    }

    public void setCapacity(long capacity) {
        this.capacity = capacity;
    }

    public void setDfsUsed(long dfsUsed) {
        this.dfsUsed = dfsUsed;
    }

    public void setRemaining(long remaining) {
        this.remaining = remaining;
    }

    public void setBlockPoolUsed(long bpUsed) {
        this.blockPoolUsed = bpUsed;
    }

    public void setCacheCapacity(long cacheCapacity) {
        this.cacheCapacity = cacheCapacity;
    }

    public void setCacheUsed(long cacheUsed) {
        this.cacheUsed = cacheUsed;
    }

    public void setLastUpdate(long lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public void setXceiverCount(int xceiverCount) {
        this.xceiverCount = xceiverCount;
    }

    @Override
    public synchronized String getNetworkLocation() {
        return this.location;
    }

    @Override
    public synchronized void setNetworkLocation(String location) {
        this.location = NodeBase.normalize(location);
    }

    public void addDependentHostName(String hostname) {
        this.dependentHostNames.add(hostname);
    }

    public List<String> getDependentHostNames() {
        return this.dependentHostNames;
    }

    public void setDependentHostNames(List<String> dependencyList) {
        this.dependentHostNames = dependencyList;
    }

    public String getDatanodeReport() {
        StringBuilder buffer = new StringBuilder();
        long c = this.getCapacity();
        long r = this.getRemaining();
        long u = this.getDfsUsed();
        long nonDFSUsed = this.getNonDfsUsed();
        float usedPercent = this.getDfsUsedPercent();
        float remainingPercent = this.getRemainingPercent();
        long cc = this.getCacheCapacity();
        long cr = this.getCacheRemaining();
        long cu = this.getCacheUsed();
        float cacheUsedPercent = this.getCacheUsedPercent();
        float cacheRemainingPercent = this.getCacheRemainingPercent();
        String lookupName = NetUtils.getHostNameOfIP(this.getName());
        buffer.append("Name: " + this.getName());
        if (lookupName != null) {
            buffer.append(" (" + lookupName + ")");
        }
        buffer.append("\n");
        buffer.append("Hostname: " + this.getHostName() + "\n");
        if (!"/default-rack".equals(this.location)) {
            buffer.append("Rack: " + this.location + "\n");
        }
        buffer.append("Decommission Status : ");
        if (this.isDecommissioned()) {
            buffer.append("Decommissioned\n");
        } else if (this.isDecommissionInProgress()) {
            buffer.append("Decommission in progress\n");
        } else {
            buffer.append("Normal\n");
        }
        buffer.append("Configured Capacity: " + c + " (" + StringUtils.byteDesc(c) + ")" + "\n");
        buffer.append("DFS Used: " + u + " (" + StringUtils.byteDesc(u) + ")" + "\n");
        buffer.append("Non DFS Used: " + nonDFSUsed + " (" + StringUtils.byteDesc(nonDFSUsed) + ")" + "\n");
        buffer.append("DFS Remaining: " + r + " (" + StringUtils.byteDesc(r) + ")" + "\n");
        buffer.append("DFS Used%: " + DFSUtil.percent2String(usedPercent) + "\n");
        buffer.append("DFS Remaining%: " + DFSUtil.percent2String(remainingPercent) + "\n");
        buffer.append("Configured Cache Capacity: " + cc + " (" + StringUtils.byteDesc(cc) + ")" + "\n");
        buffer.append("Cache Used: " + cu + " (" + StringUtils.byteDesc(cu) + ")" + "\n");
        buffer.append("Cache Remaining: " + cr + " (" + StringUtils.byteDesc(cr) + ")" + "\n");
        buffer.append("Cache Used%: " + DFSUtil.percent2String(cacheUsedPercent) + "\n");
        buffer.append("Cache Remaining%: " + DFSUtil.percent2String(cacheRemainingPercent) + "\n");
        buffer.append("Xceivers: " + this.getXceiverCount() + "\n");
        buffer.append("Last contact: " + new Date(this.lastUpdate) + "\n");
        return buffer.toString();
    }

    public String dumpDatanode() {
        StringBuilder buffer = new StringBuilder();
        long c = this.getCapacity();
        long r = this.getRemaining();
        long u = this.getDfsUsed();
        long cc = this.getCacheCapacity();
        long cr = this.getCacheRemaining();
        long cu = this.getCacheUsed();
        buffer.append(this.getName());
        if (!"/default-rack".equals(this.location)) {
            buffer.append(" " + this.location);
        }
        if (this.isDecommissioned()) {
            buffer.append(" DD");
        } else if (this.isDecommissionInProgress()) {
            buffer.append(" DP");
        } else {
            buffer.append(" IN");
        }
        buffer.append(" " + c + "(" + StringUtils.byteDesc(c) + ")");
        buffer.append(" " + u + "(" + StringUtils.byteDesc(u) + ")");
        buffer.append(" " + DFSUtil.percent2String((double)u / (double)c));
        buffer.append(" " + r + "(" + StringUtils.byteDesc(r) + ")");
        buffer.append(" " + cc + "(" + StringUtils.byteDesc(cc) + ")");
        buffer.append(" " + cu + "(" + StringUtils.byteDesc(cu) + ")");
        buffer.append(" " + DFSUtil.percent2String((double)cu / (double)cc));
        buffer.append(" " + cr + "(" + StringUtils.byteDesc(cr) + ")");
        buffer.append(" " + new Date(this.lastUpdate));
        return buffer.toString();
    }

    public void startDecommission() {
        this.adminState = AdminStates.DECOMMISSION_INPROGRESS;
    }

    public void stopDecommission() {
        this.adminState = null;
    }

    public boolean isDecommissionInProgress() {
        return this.adminState == AdminStates.DECOMMISSION_INPROGRESS;
    }

    public boolean isDecommissioned() {
        return this.adminState == AdminStates.DECOMMISSIONED;
    }

    public void setDecommissioned() {
        this.adminState = AdminStates.DECOMMISSIONED;
    }

    public AdminStates getAdminState() {
        if (this.adminState == null) {
            return AdminStates.NORMAL;
        }
        return this.adminState;
    }

    public boolean isStale(long staleInterval) {
        return Time.now() - this.lastUpdate >= staleInterval;
    }

    protected void setAdminState(AdminStates newState) {
        this.adminState = newState == AdminStates.NORMAL ? null : newState;
    }

    @Override
    public Node getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Node parent) {
        this.parent = parent;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || super.equals(obj);
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    public void setSoftwareVersion(String softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

    public static enum AdminStates {
        NORMAL("In Service"),
        DECOMMISSION_INPROGRESS("Decommission In Progress"),
        DECOMMISSIONED("Decommissioned");

        final String value;

        private AdminStates(String v) {
            this.value = v;
        }

        public String toString() {
            return this.value;
        }

        public static AdminStates fromValue(String value) {
            for (AdminStates as : AdminStates.values()) {
                if (!as.value.equals(value)) continue;
                return as;
            }
            return NORMAL;
        }
    }
}

