/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.SysInfo;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MAPREDUCE"})
@InterfaceStability.Unstable
public class ResourceCalculatorPlugin
extends Configured {
    private static final Log LOG = LogFactory.getLog(ResourceCalculatorPlugin.class);
    private final SysInfo sys;

    protected ResourceCalculatorPlugin() {
        this(SysInfo.newInstance());
    }

    public ResourceCalculatorPlugin(SysInfo sys) {
        this.sys = sys;
    }

    public long getVirtualMemorySize() {
        return this.sys.getVirtualMemorySize();
    }

    public long getPhysicalMemorySize() {
        return this.sys.getPhysicalMemorySize();
    }

    public long getAvailableVirtualMemorySize() {
        return this.sys.getAvailableVirtualMemorySize();
    }

    public long getAvailablePhysicalMemorySize() {
        return this.sys.getAvailablePhysicalMemorySize();
    }

    public int getNumProcessors() {
        return this.sys.getNumProcessors();
    }

    public int getNumCores() {
        return this.sys.getNumCores();
    }

    public long getCpuFrequency() {
        return this.sys.getCpuFrequency();
    }

    public long getCumulativeCpuTime() {
        return this.sys.getCumulativeCpuTime();
    }

    public float getCpuUsagePercentage() {
        return this.sys.getCpuUsagePercentage();
    }

    public float getNumVCoresUsed() {
        return this.sys.getNumVCoresUsed();
    }

    public long getNetworkBytesRead() {
        return this.sys.getNetworkBytesRead();
    }

    public long getNetworkBytesWritten() {
        return this.sys.getNetworkBytesWritten();
    }

    public long getStorageBytesRead() {
        return this.sys.getStorageBytesRead();
    }

    public long getStorageBytesWritten() {
        return this.sys.getStorageBytesWritten();
    }

    public static ResourceCalculatorPlugin getResourceCalculatorPlugin(Class<? extends ResourceCalculatorPlugin> clazz, Configuration conf) {
        if (clazz != null) {
            return ReflectionUtils.newInstance(clazz, conf);
        }
        try {
            return new ResourceCalculatorPlugin();
        }
        catch (UnsupportedOperationException ue) {
            LOG.warn("Failed to instantiate default resource calculator. " + ue.getMessage());
        }
        catch (Throwable t) {
            LOG.warn(t + ": Failed to instantiate default resource calculator.", t);
        }
        return null;
    }

    public static ResourceCalculatorPlugin getContainersMonitorPlugin(Configuration conf) {
        Class<ResourceCalculatorPlugin> clazzNM = conf.getClass("yarn.nodemanager.resource-calculator.class", null, ResourceCalculatorPlugin.class);
        Class<ResourceCalculatorPlugin> clazz = conf.getClass("yarn.nodemanager.container-monitor.resource-calculator.class", clazzNM, ResourceCalculatorPlugin.class);
        return ResourceCalculatorPlugin.getResourceCalculatorPlugin(clazz, conf);
    }

    public static ResourceCalculatorPlugin getNodeResourceMonitorPlugin(Configuration conf) {
        Class<ResourceCalculatorPlugin> clazz = conf.getClass("yarn.nodemanager.resource-calculator.class", null, ResourceCalculatorPlugin.class);
        return ResourceCalculatorPlugin.getResourceCalculatorPlugin(clazz, conf);
    }
}

