/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hdfs.DFSStripedInputStream;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.StripeReader;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.util.StripedBlockUtil;
import org.apache.hadoop.io.erasurecode.ECChunk;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureDecoder;

class StatefulStripeReader
extends StripeReader {
    StatefulStripeReader(StripedBlockUtil.AlignedStripe alignedStripe, ErasureCodingPolicy ecPolicy, LocatedBlock[] targetBlocks, StripeReader.BlockReaderInfo[] readerInfos, DFSUtilClient.CorruptedBlocks corruptedBlocks, RawErasureDecoder decoder, DFSStripedInputStream dfsStripedInputStream) {
        super(alignedStripe, ecPolicy, targetBlocks, readerInfos, corruptedBlocks, decoder, dfsStripedInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void prepareDecodeInputs() {
        ByteBuffer cur;
        DFSStripedInputStream dFSStripedInputStream = this.dfsStripedInputStream;
        synchronized (dFSStripedInputStream) {
            cur = this.dfsStripedInputStream.getCurStripeBuf().duplicate();
        }
        this.decodeInputs = new ECChunk[this.dataBlkNum + this.parityBlkNum];
        int bufLen = (int)this.alignedStripe.getSpanInBlock();
        int bufOff = (int)this.alignedStripe.getOffsetInBlock();
        for (int i = 0; i < this.dataBlkNum; ++i) {
            cur.limit(cur.capacity());
            int pos = bufOff % this.cellSize + this.cellSize * i;
            cur.position(pos);
            cur.limit(pos + bufLen);
            this.decodeInputs[i] = new ECChunk(cur.slice(), 0, bufLen);
            if (this.alignedStripe.chunks[i] != null) continue;
            this.alignedStripe.chunks[i] = new StripedBlockUtil.StripingChunk(this.decodeInputs[i].getBuffer());
        }
    }

    @Override
    boolean prepareParityChunk(int index) {
        Preconditions.checkState(index >= this.dataBlkNum && this.alignedStripe.chunks[index] == null);
        if (this.readerInfos[index] != null && this.readerInfos[index].shouldSkip) {
            this.alignedStripe.chunks[index] = new StripedBlockUtil.StripingChunk(2);
            return false;
        }
        int parityIndex = index - this.dataBlkNum;
        ByteBuffer buf = this.dfsStripedInputStream.getParityBuffer().duplicate();
        buf.position(this.cellSize * parityIndex);
        buf.limit(this.cellSize * parityIndex + (int)this.alignedStripe.range.spanInBlock);
        this.decodeInputs[index] = new ECChunk(buf.slice(), 0, (int)this.alignedStripe.range.spanInBlock);
        this.alignedStripe.chunks[index] = new StripedBlockUtil.StripingChunk(this.decodeInputs[index].getBuffer());
        return true;
    }

    @Override
    void decode() throws IOException {
        this.finalizeDecodeInputs();
        this.decodeAndFillBuffer(false);
    }
}

