/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class Command
extends Configured {
    public static final String COMMAND_NAME_FIELD = "NAME";
    public static final String COMMAND_USAGE_FIELD = "USAGE";
    public static final String COMMAND_DESCRIPTION_FIELD = "DESCRIPTION";
    protected String[] args;
    protected String name;
    protected int exitCode = 0;
    protected int numErrors = 0;
    protected boolean recursive = false;
    private int depth = 0;
    protected ArrayList<Exception> exceptions = new ArrayList();
    private static final Logger LOG = LoggerFactory.getLogger(Command.class);
    public PrintStream out = System.out;
    public PrintStream err = System.err;
    private CommandFactory commandFactory = null;

    protected Command() {
        this.out = System.out;
        this.err = System.err;
    }

    protected Command(Configuration conf) {
        super(conf);
    }

    public abstract String getCommandName();

    protected void setRecursive(boolean flag) {
        this.recursive = flag;
    }

    protected boolean isRecursive() {
        return this.recursive;
    }

    protected int getDepth() {
        return this.depth;
    }

    protected abstract void run(Path var1) throws IOException;

    protected void run(PathData pathData) throws IOException {
        this.run(pathData.path);
    }

    public int runAll() {
        int exitCode = 0;
        for (String src : this.args) {
            try {
                PathData[] srcs;
                for (PathData s2 : srcs = PathData.expandAsGlob(src, this.getConf())) {
                    this.run(s2);
                }
            }
            catch (IOException e) {
                exitCode = -1;
                this.displayError(e);
            }
        }
        return exitCode;
    }

    public void setCommandFactory(CommandFactory factory) {
        this.commandFactory = factory;
    }

    protected CommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    public int run(String ... argv) {
        LinkedList<String> args = new LinkedList<String>(Arrays.asList(argv));
        try {
            if (this.isDeprecated()) {
                this.displayWarning("DEPRECATED: Please use '" + this.getReplacementCommand() + "' instead.");
            }
            this.processOptions(args);
            this.processRawArguments(args);
        }
        catch (CommandInterruptException e) {
            this.displayError("Interrupted");
            return 130;
        }
        catch (IOException e) {
            this.displayError(e);
        }
        return this.numErrors == 0 ? this.exitCode : this.exitCodeForError();
    }

    protected int exitCodeForError() {
        return 1;
    }

    protected void processOptions(LinkedList<String> args) throws IOException {
    }

    protected void processRawArguments(LinkedList<String> args) throws IOException {
        this.processArguments(this.expandArguments(args));
    }

    protected LinkedList<PathData> expandArguments(LinkedList<String> args) throws IOException {
        LinkedList<PathData> expandedArgs = new LinkedList<PathData>();
        for (String arg : args) {
            try {
                expandedArgs.addAll(this.expandArgument(arg));
            }
            catch (IOException e) {
                this.displayError(e);
            }
        }
        return expandedArgs;
    }

    protected List<PathData> expandArgument(String arg) throws IOException {
        PathData[] items = PathData.expandAsGlob(arg, this.getConf());
        if (items.length == 0) {
            throw new PathNotFoundException(arg);
        }
        return Arrays.asList(items);
    }

    protected void processArguments(LinkedList<PathData> args) throws IOException {
        for (PathData arg : args) {
            try {
                this.processArgument(arg);
            }
            catch (IOException e) {
                this.displayError(e);
            }
        }
    }

    protected void processArgument(PathData item) throws IOException {
        if (item.exists) {
            this.processPathArgument(item);
        } else {
            this.processNonexistentPath(item);
        }
    }

    protected void processPathArgument(PathData item) throws IOException {
        this.depth = 0;
        this.processPaths(null, item);
    }

    protected void processNonexistentPath(PathData item) throws IOException {
        throw new PathNotFoundException(item.toString());
    }

    protected void processPaths(PathData parent, PathData ... items) throws IOException {
        for (PathData item : items) {
            try {
                this.processPathInternal(item);
            }
            catch (IOException e) {
                this.displayError(e);
            }
        }
    }

    protected void processPaths(PathData parent, RemoteIterator<PathData> itemsIterator) throws IOException {
        int groupSize = this.getListingGroupSize();
        if (groupSize == 0) {
            while (itemsIterator.hasNext()) {
                this.processPaths(parent, itemsIterator.next());
            }
        } else {
            ArrayList<PathData> items = new ArrayList<PathData>(groupSize);
            while (itemsIterator.hasNext()) {
                items.add(itemsIterator.next());
                if (itemsIterator.hasNext() && items.size() != groupSize) continue;
                this.processPaths(parent, items.toArray(new PathData[items.size()]));
                items.clear();
            }
        }
    }

    private void processPathInternal(PathData item) throws IOException {
        this.processPath(item);
        if (this.recursive && this.isPathRecursable(item)) {
            this.recursePath(item);
        }
        this.postProcessPath(item);
    }

    protected boolean isSorted() {
        return false;
    }

    protected int getListingGroupSize() {
        return 0;
    }

    protected boolean isPathRecursable(PathData item) throws IOException {
        return item.stat.isDirectory();
    }

    protected void processPath(PathData item) throws IOException {
        throw new RuntimeException("processPath() is not implemented");
    }

    protected void postProcessPath(PathData item) throws IOException {
    }

    protected void recursePath(PathData item) throws IOException {
        try {
            ++this.depth;
            if (this.isSorted()) {
                this.processPaths(item, item.getDirectoryContents());
            } else {
                this.processPaths(item, item.getDirectoryContentsIterator());
            }
        }
        finally {
            --this.depth;
        }
    }

    public void displayError(Exception e) {
        this.exceptions.add(e);
        if (e instanceof InterruptedIOException) {
            throw new CommandInterruptException();
        }
        String errorMessage = e.getLocalizedMessage();
        if (errorMessage == null) {
            errorMessage = StringUtils.stringifyException(e);
            LOG.debug(errorMessage);
        } else {
            errorMessage = errorMessage.split("\n", 2)[0];
        }
        this.displayError(errorMessage);
    }

    public void displayError(String message) {
        ++this.numErrors;
        this.displayWarning(message);
    }

    public void displayWarning(String message) {
        this.err.println(this.getName() + ": " + message);
    }

    public String getName() {
        return this.name == null ? this.getCommandField(COMMAND_NAME_FIELD) : (this.name.startsWith("-") ? this.name.substring(1) : this.name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUsage() {
        String cmd = "-" + this.getName();
        String usage = this.isDeprecated() ? "" : this.getCommandField(COMMAND_USAGE_FIELD);
        return usage.isEmpty() ? cmd : cmd + " " + usage;
    }

    public String getDescription() {
        return this.isDeprecated() ? "(DEPRECATED) Same as '" + this.getReplacementCommand() + "'" : this.getCommandField(COMMAND_DESCRIPTION_FIELD);
    }

    public final boolean isDeprecated() {
        return this.getReplacementCommand() != null;
    }

    public String getReplacementCommand() {
        return null;
    }

    private String getCommandField(String field) {
        String value;
        try {
            Field f = this.getClass().getDeclaredField(field);
            f.setAccessible(true);
            value = f.get(this).toString();
        }
        catch (Exception e) {
            throw new RuntimeException("failed to get " + this.getClass().getSimpleName() + "." + field, e);
        }
        return value;
    }

    static class CommandInterruptException
    extends RuntimeException {
        CommandInterruptException() {
        }
    }
}

