/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.atlas.metrics.Metrics;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.typesystem.types.TypeSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestContextV1 {
    private static final Logger LOG = LoggerFactory.getLogger(RequestContextV1.class);
    private static final ThreadLocal<RequestContextV1> CURRENT_CONTEXT = new ThreadLocal();
    private Set<AtlasObjectId> createdEntityIds = new LinkedHashSet<AtlasObjectId>();
    private Set<AtlasObjectId> updatedEntityIds = new LinkedHashSet<AtlasObjectId>();
    private Set<AtlasObjectId> deletedEntityIds = new LinkedHashSet<AtlasObjectId>();
    private String user;
    private final long requestTime;
    TypeSystem typeSystem = TypeSystem.getInstance();
    private Metrics metrics = new Metrics();

    private RequestContextV1() {
        this.requestTime = System.currentTimeMillis();
    }

    public static RequestContextV1 get() {
        RequestContextV1 ret = CURRENT_CONTEXT.get();
        if (ret == null) {
            ret = new RequestContextV1();
            CURRENT_CONTEXT.set(ret);
        }
        return ret;
    }

    public static void clear() {
        CURRENT_CONTEXT.remove();
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void recordEntityCreate(Collection<AtlasObjectId> createdEntityIds) {
        this.createdEntityIds.addAll(createdEntityIds);
    }

    public void recordEntityCreate(AtlasObjectId createdEntityId) {
        this.createdEntityIds.add(createdEntityId);
    }

    public void recordEntityUpdate(Collection<AtlasObjectId> updatedEntityIds) {
        this.updatedEntityIds.addAll(updatedEntityIds);
    }

    public void recordEntityUpdate(AtlasObjectId entityId) {
        this.updatedEntityIds.add(entityId);
    }

    public void recordEntityDelete(AtlasObjectId entityId) {
        this.deletedEntityIds.add(entityId);
    }

    public Collection<AtlasObjectId> getCreatedEntityIds() {
        return this.createdEntityIds;
    }

    public Collection<AtlasObjectId> getUpdatedEntityIds() {
        return this.updatedEntityIds;
    }

    public Collection<AtlasObjectId> getDeletedEntityIds() {
        return this.deletedEntityIds;
    }

    public long getRequestTime() {
        return this.requestTime;
    }

    public boolean isDeletedEntity(AtlasObjectId entityId) {
        return this.deletedEntityIds.contains(entityId);
    }

    public static Metrics getMetrics() {
        return RequestContextV1.get().metrics;
    }
}

