/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.valueextractors;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.asterix.common.exceptions.MetadataException;
import org.apache.asterix.common.transactions.JobId;
import org.apache.asterix.metadata.api.IValueExtractor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.util.string.UTF8StringReader;

public class NestedDatatypeNameValueExtractor
implements IValueExtractor<String> {
    private final String datatypeName;
    private final UTF8StringReader reader = new UTF8StringReader();

    public NestedDatatypeNameValueExtractor(String datatypeName) {
        this.datatypeName = datatypeName;
    }

    @Override
    public String getValue(JobId jobId, ITupleReference tuple) throws MetadataException, HyracksDataException {
        byte[] serRecord = tuple.getFieldData(2);
        int recordStartOffset = tuple.getFieldStart(2);
        int recordLength = tuple.getFieldLength(2);
        ByteArrayInputStream stream = new ByteArrayInputStream(serRecord, recordStartOffset, recordLength);
        DataInputStream in = new DataInputStream(stream);
        try {
            String nestedType = this.reader.readUTF((DataInput)in);
            if (nestedType.equals(this.datatypeName)) {
                recordStartOffset = tuple.getFieldStart(1);
                recordLength = tuple.getFieldLength(1);
                stream = new ByteArrayInputStream(serRecord, recordStartOffset, recordLength);
                in = new DataInputStream(stream);
                return this.reader.readUTF((DataInput)in);
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        return null;
    }
}

