/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.lock;

import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.asterix.common.exceptions.MetadataException;
import org.apache.asterix.common.metadata.IMetadataLock;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;

public class DatasetLock
implements IMetadataLock {
    private final String key;
    private final ReentrantReadWriteLock lock;
    private final ReentrantReadWriteLock dsReadLock;
    private final ReentrantReadWriteLock dsModifyLock;
    private final MutableInt indexBuildCounter;

    public DatasetLock(String key) {
        this.key = key;
        this.lock = new ReentrantReadWriteLock(true);
        this.dsReadLock = new ReentrantReadWriteLock(true);
        this.dsModifyLock = new ReentrantReadWriteLock(true);
        this.indexBuildCounter = new MutableInt(0);
    }

    private void readLock() {
        this.lock.readLock().lock();
    }

    private void readUnlock() {
        this.lock.readLock().unlock();
    }

    private void writeLock() {
        this.lock.writeLock().lock();
    }

    private void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    private void readReadLock() {
        this.dsReadLock.readLock().lock();
    }

    private void modifyReadLock() {
        this.dsModifyLock.readLock().lock();
    }

    private void modifyReadUnlock() {
        this.dsModifyLock.readLock().unlock();
    }

    private void readReadUnlock() {
        this.dsReadLock.readLock().unlock();
    }

    private void readWriteUnlock() {
        this.dsReadLock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifySharedWriteLock() {
        MutableInt mutableInt = this.indexBuildCounter;
        synchronized (mutableInt) {
            if (this.indexBuildCounter.getValue() > 0) {
                this.indexBuildCounter.setValue(this.indexBuildCounter.getValue() + 1);
            } else {
                this.dsModifyLock.writeLock().lock();
                this.indexBuildCounter.setValue(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifySharedWriteUnlock() {
        MutableInt mutableInt = this.indexBuildCounter;
        synchronized (mutableInt) {
            if (this.indexBuildCounter.getValue() == 1) {
                this.dsModifyLock.writeLock().unlock();
            }
            this.indexBuildCounter.setValue(this.indexBuildCounter.getValue() - 1);
        }
    }

    private void modifyExclusiveWriteLock() {
        this.dsModifyLock.writeLock().lock();
    }

    private void modifyExclusiveWriteUnlock() {
        this.dsModifyLock.writeLock().unlock();
    }

    public void upgrade(IMetadataLock.Mode from, IMetadataLock.Mode to) throws AlgebricksException {
        if (from != IMetadataLock.Mode.EXCLUSIVE_MODIFY || to != IMetadataLock.Mode.UPGRADED_WRITE) {
            throw new MetadataException(1045, new Serializable[]{from, to});
        }
        this.dsReadLock.readLock().unlock();
        this.dsReadLock.writeLock().lock();
    }

    public void downgrade(IMetadataLock.Mode from, IMetadataLock.Mode to) throws AlgebricksException {
        if (from != IMetadataLock.Mode.UPGRADED_WRITE || to != IMetadataLock.Mode.EXCLUSIVE_MODIFY) {
            throw new MetadataException(1046, new Serializable[]{from, to});
        }
        this.dsReadLock.writeLock().unlock();
        this.dsReadLock.readLock().lock();
    }

    public void lock(IMetadataLock.Mode mode) {
        switch (mode) {
            case INDEX_BUILD: {
                this.readLock();
                this.modifySharedWriteLock();
                break;
            }
            case MODIFY: {
                this.readLock();
                this.readReadLock();
                this.modifyReadLock();
                break;
            }
            case EXCLUSIVE_MODIFY: {
                this.readLock();
                this.readReadLock();
                this.modifyExclusiveWriteLock();
                break;
            }
            case WRITE: {
                this.writeLock();
                break;
            }
            case READ: {
                this.readLock();
                this.readReadLock();
                break;
            }
            default: {
                throw new IllegalStateException("locking mode " + mode + " is not supported");
            }
        }
    }

    public void unlock(IMetadataLock.Mode mode) {
        switch (mode) {
            case INDEX_BUILD: {
                this.modifySharedWriteUnlock();
                this.readUnlock();
                break;
            }
            case MODIFY: {
                this.modifyReadUnlock();
                this.readReadUnlock();
                this.readUnlock();
                break;
            }
            case EXCLUSIVE_MODIFY: {
                this.modifyExclusiveWriteUnlock();
                this.readReadUnlock();
                this.readUnlock();
                break;
            }
            case WRITE: {
                this.writeUnlock();
                break;
            }
            case READ: {
                this.readReadUnlock();
                this.readUnlock();
                break;
            }
            case UPGRADED_WRITE: {
                this.readWriteUnlock();
                this.modifyExclusiveWriteUnlock();
                this.readUnlock();
                break;
            }
            default: {
                throw new IllegalStateException("unlocking mode " + mode + " is not supported");
            }
        }
    }

    public String getKey() {
        return this.key;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof DatasetLock)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        return Objects.equals(this.key, ((DatasetLock)o).key);
    }

    public String toString() {
        return this.key;
    }
}

