/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.bootstrap;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.asterix.metadata.api.IAsterixStateProxy;
import org.apache.asterix.metadata.api.IMetadataNode;

public class AsterixStateProxy
implements IAsterixStateProxy {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(AsterixStateProxy.class.getName());
    private IMetadataNode metadataNode;
    private static final IAsterixStateProxy cc = new AsterixStateProxy();

    public static IAsterixStateProxy registerRemoteObject(int metadataCallbackPort) throws RemoteException {
        IAsterixStateProxy stub = (IAsterixStateProxy)UnicastRemoteObject.exportObject((Remote)cc, metadataCallbackPort);
        LOGGER.info("Asterix Distributed State Proxy Bound");
        return stub;
    }

    public static void unregisterRemoteObject() throws RemoteException {
        UnicastRemoteObject.unexportObject(cc, true);
        LOGGER.info("Asterix Distributed State Proxy Unbound");
    }

    @Override
    public synchronized void setMetadataNode(IMetadataNode metadataNode) {
        this.metadataNode = metadataNode;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMetadataNode waitForMetadataNode(long waitFor, TimeUnit timeUnit) throws InterruptedException {
        AsterixStateProxy asterixStateProxy = this;
        synchronized (asterixStateProxy) {
            long startTime;
            for (long timeToWait = TimeUnit.MILLISECONDS.convert(waitFor, timeUnit); this.metadataNode == null && timeToWait > 0L; timeToWait -= System.currentTimeMillis() - startTime) {
                startTime = System.currentTimeMillis();
                this.wait(timeToWait);
            }
            return this.metadataNode;
        }
    }
}

