/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.lock;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.core.server.ActiveMQScheduledComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.lockmanager.DistributedLock;
import org.apache.activemq.artemis.lockmanager.DistributedLockManager;
import org.apache.activemq.artemis.utils.RunnableEx;
import org.apache.activemq.artemis.utils.SimpleFutureImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockCoordinator
extends ActiveMQScheduledComponent {
    public static final int DEFAULT_CHECK_PERIOD = 5000;
    String debugInfo;
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ArrayList<RunnableEx> lockAcquiredCallback = new ArrayList();
    private final ArrayList<RunnableEx> lockReleasedCallback = new ArrayList();
    private final long checkPeriod;
    private final String name;
    private final String lockID;
    DistributedLockManager lockManager;
    DistributedLock distributedLock;
    volatile boolean locked;

    public String getDebugInfo() {
        return this.debugInfo;
    }

    public LockCoordinator setDebugInfo(String debugInfo) {
        this.debugInfo = debugInfo;
        return this;
    }

    public DistributedLockManager getLockManager() {
        return this.lockManager;
    }

    public void onLockAcquired(RunnableEx runnable) {
        this.lockAcquiredCallback.add(runnable);
        this.executor.execute(() -> this.runIfLocked(runnable));
    }

    public void onLockReleased(RunnableEx runnable) {
        this.lockReleasedCallback.add(runnable);
    }

    public void stop() {
        super.stop();
        SimpleFutureImpl simpleFuture = new SimpleFutureImpl();
        this.executor.execute(() -> {
            if (this.locked) {
                this.fireLockChanged(false);
            }
            if (this.distributedLock != null) {
                try {
                    this.distributedLock.unlock();
                }
                catch (Exception e) {
                    logger.debug("Error unlocking during stop", (Throwable)e);
                }
                try {
                    this.distributedLock.close();
                }
                catch (Exception e) {
                    logger.debug("Error closing lock during stop", (Throwable)e);
                }
                this.distributedLock = null;
            }
            if (this.lockManager != null) {
                try {
                    this.lockManager.stop();
                }
                catch (Exception e) {
                    logger.debug("Error stopping lock manager during stop", (Throwable)e);
                }
                this.lockManager = null;
            }
            simpleFuture.set(null);
        });
        try {
            simpleFuture.get();
        }
        catch (Exception e) {
            logger.debug("Error waiting for stop to complete", (Throwable)e);
        }
    }

    public boolean isLocked() {
        return this.locked;
    }

    public LockCoordinator(ScheduledExecutorService scheduledExecutor, Executor executor, long checkPeriod, DistributedLockManager lockManager, String lockID, String name) {
        super(scheduledExecutor, executor, checkPeriod, checkPeriod, TimeUnit.MILLISECONDS, false);
        assert (executor != null);
        this.lockManager = lockManager;
        this.checkPeriod = checkPeriod;
        this.lockID = lockID;
        this.name = name;
    }

    private void fireLockChanged(boolean locked) {
        this.locked = locked;
        if (locked) {
            AtomicBoolean treatErrors = new AtomicBoolean(false);
            this.lockAcquiredCallback.forEach(r -> this.doRunTreatingErrors((RunnableEx)r, treatErrors));
            if (treatErrors.get()) {
                this.retryLock();
            }
        } else {
            this.lockReleasedCallback.forEach(this::doRunWithLogException);
        }
    }

    private void retryLock() {
        ActiveMQServerLogger.LOGGER.retryLockCoordinator(this.name);
        this.executor.execute(this::executeRetryLock);
    }

    private void executeRetryLock() {
        if (this.locked) {
            logger.debug("Unlocking to retry the callback");
            this.fireLockChanged(false);
            if (this.distributedLock != null) {
                try {
                    this.distributedLock.unlock();
                    this.distributedLock.close();
                }
                catch (Exception e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
                this.distributedLock = null;
            }
            if (this.lockManager != null) {
                try {
                    this.lockManager.stop();
                }
                catch (Exception e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void runIfLocked(RunnableEx checkBeingAdded) {
        if (this.locked) {
            try {
                this.doRun(checkBeingAdded);
            }
            catch (Throwable e) {
                logger.warn(e.getMessage(), e);
                this.retryLock();
            }
        }
    }

    private void doRunTreatingErrors(RunnableEx r, AtomicBoolean errorOnStart) {
        try {
            r.run();
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
            errorOnStart.set(true);
        }
    }

    private void doRun(RunnableEx r) throws Exception {
        r.run();
    }

    private void doRunWithLogException(RunnableEx r) {
        try {
            r.run();
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
        }
    }

    public void run() {
        try {
            if (!this.locked) {
                DistributedLock lock;
                if (!this.lockManager.isStarted()) {
                    this.lockManager.start();
                }
                if ((lock = this.lockManager.getDistributedLock(this.lockID)).tryLock(1L, TimeUnit.SECONDS)) {
                    logger.debug("Succeeded on locking {}, lockID={}", (Object)this.name, (Object)this.lockID);
                    this.distributedLock = lock;
                    this.fireLockChanged(true);
                } else {
                    logger.debug("Not able to lock {}, lockID={}", (Object)this.name, (Object)this.lockID);
                    lock.close();
                    this.lockManager.stop();
                }
            } else if (!this.distributedLock.isHeldByCaller()) {
                this.fireLockChanged(false);
                this.distributedLock.close();
                this.distributedLock = null;
                this.lockManager.stop();
            }
        }
        catch (Exception e) {
            this.fireLockChanged(false);
            if (this.distributedLock != null) {
                try {
                    this.distributedLock.close();
                }
                catch (Exception closeEx) {
                    logger.debug("Error closing lock", (Throwable)closeEx);
                }
                this.distributedLock = null;
            }
            if (this.lockManager != null) {
                try {
                    this.lockManager.stop();
                }
                catch (Exception stopEx) {
                    logger.debug("Error stopping lock manager", (Throwable)stopEx);
                }
            }
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }
}

