/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.tools.config;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.Configurable;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import picocli.CommandLine;

@CommandLine.Command(name="properties", description={"Export the broker's configuration as a properties file."})
public class ExportProperties
extends Configurable {
    @CommandLine.Option(names={"--output"}, description={"Output name for the file."}, defaultValue="broker.properties")
    private File output;

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        PrintStream out = context.out;
        BufferedOutputStream outputStream = null;
        System.out.println("Exporting configuration as " + String.valueOf(this.output));
        if (this.output == null) {
            throw new RuntimeException("output is a required property");
        }
        if (this.output != null) {
            PrintStream printStream;
            outputStream = new BufferedOutputStream(new FileOutputStream(this.output));
            context.out = printStream = new PrintStream(outputStream);
        }
        FileConfiguration configuration = this.readConfiguration();
        configuration.exportAsProperties(this.output);
        return null;
    }
}

