/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.activation;

import java.io.PrintStream;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.activation.ActivationSequenceUtils;
import org.apache.activemq.artemis.cli.commands.tools.LockAbstract;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.DistributedLockManagerConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationPrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.impl.FileLockNodeManager;
import org.apache.activemq.artemis.lockmanager.DistributedLock;
import org.apache.activemq.artemis.lockmanager.DistributedLockManager;
import org.apache.activemq.artemis.lockmanager.MutableLong;
import picocli.CommandLine;

@CommandLine.Command(name="set", description={"Set local and/or remote (i.e. coordinated) activation sequence."})
public class ActivationSequenceSet
extends LockAbstract {
    private static final int MANAGER_START_TIMEOUT_SECONDS = 60;
    @CommandLine.Option(names={"--node-id"}, description={"Target sequence for this UUID overwriting the NodeID of this broker too. If not set, broker NodeID is used instead."})
    public String nodeId = null;
    @CommandLine.Option(names={"--remote"}, description={"Set just remote (i.e. coordinated) activation sequence."})
    public boolean remote = false;
    @CommandLine.Option(names={"--local"}, description={"Set just local activation sequence."})
    public boolean local = false;
    @CommandLine.Option(names={"--to"}, description={"The new activation sequence."}, required=true)
    public long value;

    @Override
    public Object execute(ActionContext context) throws Exception {
        Object output = super.execute(context);
        ActivationSequenceSet.execute(this, (Configuration)this.getFileConfiguration(), context.out);
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(ActivationSequenceSet command, Configuration config, PrintStream out) throws Exception {
        block37: {
            DistributedLockManagerConfiguration managerConfiguration;
            String nodeId = command.nodeId;
            boolean remote = command.remote;
            boolean local = command.local;
            long value = command.value;
            if (remote && local) {
                throw new IllegalArgumentException("Both --local and --remote cannot be present. To set both sequences just remove --local and --remote.");
            }
            if (value < 0L) {
                throw new IllegalArgumentException("--to must be >= 0");
            }
            HAPolicyConfiguration policyConfig = config.getHAPolicyConfiguration();
            String coordinationId = nodeId;
            if (policyConfig instanceof ReplicationBackupPolicyConfiguration) {
                ReplicationBackupPolicyConfiguration backupPolicyConfig = (ReplicationBackupPolicyConfiguration)policyConfig;
                managerConfiguration = backupPolicyConfig.getDistributedManagerConfiguration();
            } else if (policyConfig instanceof ReplicationPrimaryPolicyConfiguration) {
                ReplicationPrimaryPolicyConfiguration primaryPolicyConfig = (ReplicationPrimaryPolicyConfiguration)policyConfig;
                managerConfiguration = primaryPolicyConfig.getDistributedManagerConfiguration();
                if (primaryPolicyConfig.getCoordinationId() != null) {
                    if (nodeId != null) {
                        throw new IllegalArgumentException("Forcing NodeID with multi-primary is not supported! Try again without --node-id");
                    }
                    coordinationId = primaryPolicyConfig.getCoordinationId();
                }
            } else {
                throw new UnsupportedOperationException("This command support just <primary> or <backup> replication configuration");
            }
            Objects.requireNonNull(managerConfiguration);
            FileLockNodeManager nodeManager = new FileLockNodeManager(config.getNodeManagerLockLocation(), false);
            nodeManager.start();
            try {
                if (!(coordinationId == null || nodeManager.getNodeId() != null && nodeManager.getNodeId().toString().equals(coordinationId))) {
                    nodeManager = ActivationSequenceUtils.applyCoordinationId(coordinationId, (NodeManager)nodeManager, config.getNodeManagerLockLocation());
                }
                String localNodeId = nodeManager.getNodeId().toString();
                if (!remote) {
                    long localActivationSequence = nodeManager.getNodeActivationSequence();
                    nodeManager.writeNodeActivationSequence(value);
                    if (out != null) {
                        if (localActivationSequence == -1L) {
                            out.println("Forced local activation sequence for NodeID=" + localNodeId + " to " + value);
                        } else {
                            out.println("Forced local activation sequence for NodeID=" + localNodeId + " from " + localActivationSequence + " to " + value);
                        }
                    }
                }
                if (local) break block37;
                try (DistributedLockManager manager = DistributedLockManager.newInstanceOf((String)managerConfiguration.getClassName(), (Map)managerConfiguration.getProperties());){
                    if (!manager.start(60L, TimeUnit.SECONDS)) {
                        throw new IllegalStateException("distributed manager isn't started in 60 seconds");
                    }
                    try (MutableLong coordinatedActivationSequence = manager.getMutableLong(localNodeId);
                         DistributedLock primaryLock = manager.getDistributedLock(localNodeId);){
                        if (!primaryLock.tryLock()) {
                            throw new IllegalStateException("Cannot safely set coordinated activation sequence for NodeID=" + localNodeId + ": primary lock is still held.");
                        }
                        long remoteActivationSequence = coordinatedActivationSequence.get();
                        coordinatedActivationSequence.set(value);
                        if (out != null) {
                            out.println("Forced coordinated activation sequence for NodeID=" + localNodeId + " from " + remoteActivationSequence + " to " + value);
                        }
                    }
                }
            }
            finally {
                nodeManager.stop();
            }
        }
    }
}

