/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.Create;
import org.apache.activemq.artemis.cli.commands.InstallAbstract;
import org.apache.activemq.artemis.util.JVMArgumentParser;
import picocli.CommandLine;

@CommandLine.Command(name="upgrade", description={"Update a broker instance to the current artemis.home, keeping all the data and broker.xml. Warning: backup your instance before using this command and compare the files."})
public class Upgrade
extends InstallAbstract {
    private static final String[] KEEPING_JVM_ARGUMENTS = new String[]{"-Xmx", "-Djava.security.auth.login.config", "-Dhawtio.roles="};
    private static final Map<String, String> KEEPING_JVM_ARGUMENTS_ALTERNATES = Map.of("-Dhawtio.roles=", "-Dhawtio.role=");
    private static final String JDK_PREFIX_WINDOWS = "IF \"%JAVA_ARGS%\"==\"\" (set JAVA_ARGS=";
    private static final String JDK_PREFIX_LINUX = "JAVA_ARGS=";
    public static final String OLD_LOGGING_PROPERTIES = "logging.properties";

    protected void checkDirectory() {
        if (!this.directory.exists()) {
            throw new RuntimeException(String.format("Could not find path '%s' to upgrade.", this.directory));
        }
        if (!this.directory.canWrite()) {
            throw new RuntimeException(String.format("The path '%s' is not writable.", this.directory));
        }
    }

    @Override
    public Object execute(ActionContext context) throws Exception {
        this.checkDirectory();
        super.execute(context);
        return this.run(context);
    }

    @Override
    public Object run(ActionContext context) throws Exception {
        super.run(context);
        context.out.println("*******************************************************************************************************************************");
        context.out.println("Upgrading broker instance " + String.valueOf(this.directory) + " to use artemis.home=" + this.getBrokerHome());
        File bkpFolder = this.findBackup(context);
        File binBkp = new File(bkpFolder, "bin");
        File etcBkp = new File(bkpFolder, "etc");
        File tmp = new File(bkpFolder, "tmp");
        Files.createDirectory(binBkp.toPath(), new FileAttribute[0]);
        Files.createDirectory(etcBkp.toPath(), new FileAttribute[0]);
        Files.createDirectory(tmp.toPath(), new FileAttribute[0]);
        File bin = new File(this.directory, "bin");
        File etcFolder = new File(this.directory, this.etc);
        File dataFolder = new File(this.directory, this.data);
        File logFolder = new File(this.directory, "log");
        File oomeDumpFile = new File(logFolder, "oom_dump.hprof");
        File artemisCmdScript = new File(bin, "artemis.cmd");
        File artemisScript = new File(bin, "artemis");
        if (this.etc == null || this.etc.equals("etc")) {
            if (this.IS_WINDOWS) {
                pattern = "set ARTEMIS_INSTANCE_ETC=";
                etcFolder = this.getETC(context, etcFolder, artemisCmdScript, pattern);
            } else {
                pattern = "ARTEMIS_INSTANCE_ETC=";
                etcFolder = this.getETC(context, etcFolder, artemisScript, pattern);
            }
        }
        if (bin == null || !bin.exists()) {
            throw new IOException(String.valueOf(bin) + " does not exist for binary");
        }
        if (etcFolder == null || !etcFolder.exists()) {
            throw new IOException(String.valueOf(etcFolder) + " does not exist for etc");
        }
        HashMap<String, String> filters = new HashMap<String, String>();
        Create.addScriptFilters(filters, this.getHome(), this.getInstance(), etcFolder, dataFolder, oomeDumpFile, this.javaMemory, this.getJavaOptions(), this.getJavaUtilityOptions(), "NA");
        if (this.IS_WINDOWS) {
            File serviceExe = new File(this.directory, "bin/artemis-service.exe");
            File serviceExeBkp = new File(bkpFolder, "bin/artemis-service.exe");
            context.out.println("Copying " + String.valueOf(serviceExe) + " to " + String.valueOf(serviceExeBkp));
            Files.copy(serviceExe.toPath(), serviceExeBkp.toPath(), StandardCopyOption.REPLACE_EXISTING);
            context.out.println("Updating " + String.valueOf(serviceExe.toPath()));
            this.write("bin/artemis-service.exe", true);
            File serviceExeConfig = new File(this.directory, "bin/artemis-service.exe.config");
            File serviceExeConfigBkp = new File(bkpFolder, "bin/artemis-service.exe.config");
            if (serviceExeConfig.exists()) {
                context.out.println("Copying " + String.valueOf(serviceExeConfig) + " to " + String.valueOf(serviceExeConfigBkp));
                Files.copy(serviceExeConfig.toPath(), serviceExeConfigBkp.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            context.out.println("Updating " + String.valueOf(serviceExeConfig));
            this.write("bin/artemis-service.exe.config", true);
            File artemisCmdScriptTmp = new File(tmp, "artemis.cmd");
            File artemisCmdScriptBkp = new File(binBkp, "artemis.cmd");
            this.write("bin/artemis.cmd", artemisCmdScriptTmp, filters, false, false);
            this.upgrade(context, artemisCmdScriptTmp, artemisCmdScript, artemisCmdScriptBkp, "set ARTEMIS_INSTANCE_ETC=");
            File serviceXmlTmp = new File(tmp, "artemis-service.xml");
            File serviceXml = new File(bin, "artemis-service.xml");
            File serviceXmlBkp = new File(binBkp, "artemis-service.xml");
            Map<String, String> keepPrefixAlternates = Map.of("<startargument>-Dhawtio.roles=", "<startargument>-Dhawtio.role=");
            this.write("bin/artemis-service.xml", serviceXmlTmp, filters, false, false);
            this.upgrade(context, serviceXmlTmp, serviceXml, serviceXmlBkp, keepPrefixAlternates, "<env name=\"ARTEMIS_INSTANCE\"", "<env name=\"ARTEMIS_INSTANCE_ETC\"", "<env name=\"ARTEMIS_DATA_DIR\"", "<logpath>", "<startargument>-Xmx", "<name>", "<id>", "<startargument>-Dhawtio.roles=");
            File artemisProfileCmdTmp = new File(tmp, "artemis.profile.cmd");
            File artemisProfileCmd = new File(etcFolder, "artemis.profile.cmd");
            File artemisProfileCmdBkp = new File(etcBkp, "artemis.profile.cmd");
            this.write("etc/artemis.profile.cmd", artemisProfileCmdTmp, filters, false, false);
            this.upgradeJDK(context, JDK_PREFIX_WINDOWS, "", KEEPING_JVM_ARGUMENTS_ALTERNATES, KEEPING_JVM_ARGUMENTS, artemisProfileCmdTmp, artemisProfileCmd, artemisProfileCmdBkp, Collections.emptyMap(), "set ARTEMIS_INSTANCE=\"", "set ARTEMIS_DATA_DIR=", "set ARTEMIS_OOME_DUMP=");
            File artemisUtilityProfileCmd = new File(etcFolder, "artemis-utility.profile.cmd");
            File artemisUtilityProfileCmdTmp = new File(tmp, "artemis-utility.profile.cmd");
            File artemisUtilityProfileCmdBkp = new File(etcBkp, "artemis-utility.profile.cmd");
            if (artemisUtilityProfileCmd.exists()) {
                this.write("etc/artemis-utility.profile.cmd", artemisUtilityProfileCmdTmp, filters, false, false);
                this.upgradeJDK(context, JDK_PREFIX_WINDOWS, "", KEEPING_JVM_ARGUMENTS_ALTERNATES, KEEPING_JVM_ARGUMENTS, artemisUtilityProfileCmdTmp, artemisUtilityProfileCmd, artemisUtilityProfileCmdBkp, Collections.emptyMap(), "set ARTEMIS_INSTANCE=\"", "set ARTEMIS_DATA_DIR=");
            } else {
                if (this.data == null || this.data.equals("data")) {
                    dataFolder = this.getDATA(context, dataFolder, artemisProfileCmd, "set ARTEMIS_DATA_DIR=");
                    Create.addScriptFilters(filters, this.getHome(), this.getInstance(), etcFolder, dataFolder, oomeDumpFile, this.javaMemory, this.getJavaOptions(), this.getJavaUtilityOptions(), "NA");
                }
                context.out.println("Creating " + String.valueOf(artemisUtilityProfileCmd));
                this.write("etc/artemis-utility.profile.cmd", artemisUtilityProfileCmd, filters, false, false);
            }
        }
        if (this.IS_NIX) {
            File artemisScriptTmp = new File(tmp, "artemis");
            File artemisScriptBkp = new File(binBkp, "artemis");
            this.write("bin/artemis", artemisScriptTmp, filters, false, false);
            this.upgrade(context, artemisScriptTmp, artemisScript, artemisScriptBkp, "ARTEMIS_INSTANCE_ETC=");
            File artemisService = new File(bin, "artemis-service");
            File artemisServiceTmp = new File(tmp, "artemis-service");
            File artemisServiceBkp = new File(binBkp, "artemis-service");
            this.write("bin/artemis-service", artemisServiceTmp, filters, false, false);
            this.upgrade(context, artemisServiceTmp, artemisService, artemisServiceBkp, new String[0]);
            Map<String, String> keepPrefixAlternates = Map.of("HAWTIO_ROLES=", "HAWTIO_ROLE=");
            File artemisProfile = new File(etcFolder, "artemis.profile");
            File artemisProfileTmp = new File(tmp, "artemis.profile");
            File artemisProfileBkp = new File(etcBkp, "artemis.profile");
            this.write("etc/artemis.profile", artemisProfileTmp, filters, false, false);
            this.upgradeJDK(context, JDK_PREFIX_LINUX, "\"", KEEPING_JVM_ARGUMENTS_ALTERNATES, KEEPING_JVM_ARGUMENTS, artemisProfileTmp, artemisProfile, artemisProfileBkp, keepPrefixAlternates, "ARTEMIS_INSTANCE=", "ARTEMIS_DATA_DIR=", "ARTEMIS_OOME_DUMP=", "HAWTIO_ROLES=");
            File artemisUtilityProfile = new File(etcFolder, "artemis-utility.profile");
            File artemisUtilityProfileTmp = new File(tmp, "artemis-utility.profile");
            File artemisUtilityProfileBkp = new File(etcBkp, "artemis-utility.profile");
            if (artemisUtilityProfile.exists()) {
                this.write("etc/artemis-utility.profile", artemisUtilityProfileTmp, filters, false, false);
                this.upgradeJDK(context, JDK_PREFIX_LINUX, "\"", KEEPING_JVM_ARGUMENTS_ALTERNATES, KEEPING_JVM_ARGUMENTS, artemisUtilityProfileTmp, artemisUtilityProfile, artemisUtilityProfileBkp, keepPrefixAlternates, "ARTEMIS_INSTANCE=", "ARTEMIS_DATA_DIR=");
            } else {
                if (this.data == null || this.data.equals("data")) {
                    dataFolder = this.getDATA(context, dataFolder, artemisProfile, "ARTEMIS_DATA_DIR=");
                    Create.addScriptFilters(filters, this.getHome(), this.getInstance(), etcFolder, dataFolder, oomeDumpFile, this.javaMemory, this.getJavaOptions(), this.getJavaUtilityOptions(), "NA");
                }
                context.out.println("Creating " + String.valueOf(artemisUtilityProfile));
                this.write("etc/artemis-utility.profile", artemisUtilityProfile, filters, false, false);
            }
        }
        File bootstrapXml = new File(etcFolder, "bootstrap.xml");
        File bootstrapXmlTmp = new File(tmp, "bootstrap.xml");
        File bootstrapXmlBkp = new File(etcBkp, "bootstrap.xml");
        Files.copy(bootstrapXml.toPath(), bootstrapXmlTmp.toPath(), new CopyOption[0]);
        this.replaceLines(context, bootstrapXmlTmp, bootstrapXml, bootstrapXmlBkp, "^(.*)<web path.*$", "$1<web path=\"web\" rootRedirectLocation=\"console\">", "^(.*)<binding uri=\"http://localhost:8161\"(.*)$", "$1<binding name=\"artemis\" uri=\"http://localhost:8161\"$2", "^(.*)<app url=(.*branding.*)$", "$1<app name=\"branding\" url=$2", "^(.*)<app url=(.*plugin.*)$", "$1<app name=\"plugin\" url=$2", "^(.*)<app url=\"([^\"]+)\"(.*)$", "$1<app name=\"$2\" url=\"$2\"$3");
        this.removeWars(context, bootstrapXml);
        this.upgradeLogging(context, etcFolder, etcBkp);
        context.out.println();
        context.out.println("*******************************************************************************************************************************");
        return null;
    }

    private File getETC(ActionContext context, File etcFolder, File cmd, String prefix) throws IOException {
        return this.getPathFromFile(context, etcFolder, cmd, prefix, "ETC");
    }

    private File getDATA(ActionContext context, File etcFolder, File profile, String prefix) throws IOException {
        return this.getPathFromFile(context, etcFolder, profile, prefix, "DATA");
    }

    private String getLine(File cmd, String pattern) throws IOException {
        try (Stream<String> lines = Files.lines(cmd.toPath());){
            Iterator iterator = lines.iterator();
            while (iterator.hasNext()) {
                String line = (String)iterator.next();
                if (!line.trim().startsWith(pattern)) continue;
                String string = line;
                return string;
            }
        }
        return null;
    }

    private File getPathFromFile(ActionContext context, File defaultPath, File file, String prefix, String name) throws IOException {
        String pathEntryLine = this.getLine(file, prefix);
        if (pathEntryLine != null) {
            String pathEntry = pathEntryLine.trim().substring(prefix.length() + 1, pathEntryLine.length() - 1);
            File path = new File(pathEntry);
            context.out.println(name + " found as " + String.valueOf(path));
            return path;
        }
        return defaultPath;
    }

    private void upgradeJDK(ActionContext context, String jdkPrefix, String endOfLine, Map<String, String> keepArgumentAlternates, String[] keepArguments, File tmpFile, File targetFile, File bkpFile, Map<String, String> keepPrefixAlternates, String ... keepingPrefixes) throws Exception {
        HashMap replaceMatrix = new HashMap();
        HashMap currentArguments = new HashMap();
        this.doUpgrade(context, tmpFile, targetFile, bkpFile, oldLine -> {
            if (oldLine.trim().startsWith(jdkPrefix)) {
                JVMArgumentParser.parseOriginalArgs(jdkPrefix, endOfLine, oldLine, keepArgumentAlternates, keepArguments, currentArguments);
                return;
            }
            for (String prefix : keepingPrefixes) {
                if (oldLine.trim().startsWith(prefix)) {
                    replaceMatrix.put(prefix, oldLine);
                    continue;
                }
                if (!keepPrefixAlternates.containsKey(prefix)) continue;
                String oldPrefix = (String)keepPrefixAlternates.get(prefix);
                if (!oldLine.trim().startsWith(oldPrefix)) continue;
                String renamedOldLine = oldLine.replaceFirst(oldPrefix, prefix);
                replaceMatrix.put(prefix, renamedOldLine);
            }
        }, newLine -> {
            if (newLine.trim().startsWith(jdkPrefix)) {
                String result = JVMArgumentParser.parseNewLine(jdkPrefix, endOfLine, newLine, keepArguments, currentArguments);
                return result;
            }
            for (String prefix : keepingPrefixes) {
                if (!newLine.trim().startsWith(prefix)) continue;
                String originalLine = (String)replaceMatrix.get(prefix);
                return originalLine;
            }
            return newLine;
        });
    }

    private void replaceLines(ActionContext context, File tmpFile, File targetFile, File bkpFile, String ... replacePairs) throws Exception {
        this.doUpgrade(context, tmpFile, targetFile, bkpFile, null, newLine -> {
            String replacedLine = newLine;
            for (int i = 0; i < replacePairs.length; i += 2) {
                if (!replacedLine.matches(replacePairs[i])) continue;
                replacedLine = replacedLine.replaceAll(replacePairs[i], replacePairs[i + 1]);
            }
            return replacedLine;
        });
    }

    private void upgrade(ActionContext context, File tmpFile, File targetFile, File bkpFile, String ... keepingPrefixes) throws Exception {
        this.upgrade(context, tmpFile, targetFile, bkpFile, Collections.emptyMap(), keepingPrefixes);
    }

    private void upgrade(ActionContext context, File tmpFile, File targetFile, File bkpFile, Map<String, String> keepPrefixAlternates, String ... keepingPrefixes) throws Exception {
        HashMap replaceMatrix = new HashMap();
        this.doUpgrade(context, tmpFile, targetFile, bkpFile, oldLine -> {
            if (keepingPrefixes.length > 0) {
                for (String prefix : keepingPrefixes) {
                    if (oldLine.trim().startsWith(prefix)) {
                        replaceMatrix.put(prefix, oldLine);
                        continue;
                    }
                    if (!keepPrefixAlternates.containsKey(prefix)) continue;
                    String oldPrefix = (String)keepPrefixAlternates.get(prefix);
                    if (!oldLine.trim().startsWith(oldPrefix)) continue;
                    String renamedOldLine = oldLine.replaceFirst(oldPrefix, prefix);
                    replaceMatrix.put(prefix, renamedOldLine);
                }
            }
        }, newLine -> {
            if (keepingPrefixes.length > 0) {
                for (String prefix : keepingPrefixes) {
                    if (!newLine.trim().startsWith(prefix)) continue;
                    String originalLine = (String)replaceMatrix.get(prefix);
                    return originalLine;
                }
            }
            return newLine;
        });
    }

    private void doUpgrade(ActionContext context, File tmpFile, File targetFile, File bkpFile, Consumer<String> originalConsumer, Function<String, String> targetFunction) throws Exception {
        context.out.println("Copying " + String.valueOf(targetFile) + " to " + String.valueOf(bkpFile));
        Files.copy(targetFile.toPath(), bkpFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        if (originalConsumer != null) {
            try (Stream<String> originalLines = Files.lines(targetFile.toPath());){
                originalLines.forEach(line -> originalConsumer.accept((String)line));
            }
        }
        context.out.println("Updating " + String.valueOf(targetFile));
        try (Stream<String> lines = Files.lines(tmpFile.toPath());
             PrintStream streamOutput = new PrintStream(new FileOutputStream(targetFile));){
            Iterator linesIterator = lines.iterator();
            while (linesIterator.hasNext()) {
                String line2 = (String)linesIterator.next();
                if ((line2 = targetFunction.apply(line2)) == null) continue;
                streamOutput.println(line2);
            }
        }
    }

    private void upgradeLogging(ActionContext context, File etcFolder, File bkpFolder) throws Exception {
        File newUtilityLogging;
        File oldLogging = new File(etcFolder, OLD_LOGGING_PROPERTIES);
        if (oldLogging.exists()) {
            File newLogging;
            File oldLoggingCopy = new File(bkpFolder, OLD_LOGGING_PROPERTIES);
            context.out.println("Copying " + String.valueOf(oldLogging.toPath()) + " to " + String.valueOf(oldLoggingCopy.toPath()));
            Files.copy(oldLogging.toPath(), oldLoggingCopy.toPath(), StandardCopyOption.REPLACE_EXISTING);
            context.out.println("Removing " + String.valueOf(oldLogging.toPath()));
            if (!oldLogging.delete()) {
                context.out.println(String.valueOf(oldLogging.toPath()) + " could not be removed!");
            }
            if (!(newLogging = new File(etcFolder, "log4j2.properties")).exists()) {
                context.out.println("Creating " + String.valueOf(newLogging));
                try (InputStream inputStream = Upgrade.openStream("etc/log4j2.properties");
                     FileOutputStream outputStream = new FileOutputStream(newLogging);){
                    Upgrade.copy(inputStream, outputStream);
                }
            }
        }
        if (!(newUtilityLogging = new File(etcFolder, "log4j2-utility.properties")).exists()) {
            context.out.println("Creating " + String.valueOf(newUtilityLogging));
            try (InputStream inputStream = Upgrade.openStream("etc/log4j2-utility.properties");
                 FileOutputStream outputStream = new FileOutputStream(newUtilityLogging);){
                Upgrade.copy(inputStream, outputStream);
            }
        }
    }

    protected File findBackup(ActionContext context) throws IOException {
        for (int bkp = 0; bkp < 10; ++bkp) {
            File bkpFolder = new File(this.directory, "old-config-bkp." + bkp);
            if (bkpFolder.exists()) continue;
            Files.createDirectory(bkpFolder.toPath(), new FileAttribute[0]);
            context.out.println("Using " + bkpFolder.getAbsolutePath() + " as a backup folder for the modified files");
            return bkpFolder;
        }
        throw new RuntimeException("Too many backup folders in place already. Please remove some of the old-config-bkp.* folders");
    }

    private void removeWars(ActionContext context, File bootstrapXml) throws Exception {
        StringBuilder sb = new StringBuilder();
        boolean remove = false;
        try (Stream<String> lines = Files.lines(bootstrapXml.toPath());){
            Iterator linesIterator = lines.iterator();
            while (linesIterator.hasNext()) {
                String line = (String)linesIterator.next();
                if (line.matches("^(.*)<app name=(.*branding.*)$")) {
                    context.out.println("removing branding war as no longer needed");
                    remove = true;
                    continue;
                }
                if (line.matches("^(.*)<app name=(.*plugin.*)$")) {
                    context.out.println("removing plugin war as no longer needed");
                    remove = true;
                    continue;
                }
                sb.append(line).append(System.lineSeparator());
            }
        }
        if (remove) {
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(sb.toString().getBytes(StandardCharsets.UTF_8));
                 FileOutputStream outputStream = new FileOutputStream(bootstrapXml);){
                Upgrade.copy(inputStream, outputStream);
            }
        }
    }
}

