/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.sql;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FlightSqlColumnMetadata {
    private static final String CATALOG_NAME = "ARROW:FLIGHT:SQL:CATALOG_NAME";
    private static final String SCHEMA_NAME = "ARROW:FLIGHT:SQL:SCHEMA_NAME";
    private static final String TABLE_NAME = "ARROW:FLIGHT:SQL:TABLE_NAME";
    private static final String TYPE_NAME = "ARROW:FLIGHT:SQL:TYPE_NAME";
    private static final String PRECISION = "ARROW:FLIGHT:SQL:PRECISION";
    private static final String SCALE = "ARROW:FLIGHT:SQL:SCALE";
    private static final String IS_AUTO_INCREMENT = "ARROW:FLIGHT:SQL:IS_AUTO_INCREMENT";
    private static final String IS_CASE_SENSITIVE = "ARROW:FLIGHT:SQL:IS_CASE_SENSITIVE";
    private static final String IS_READ_ONLY = "ARROW:FLIGHT:SQL:IS_READ_ONLY";
    private static final String IS_SEARCHABLE = "ARROW:FLIGHT:SQL:IS_SEARCHABLE";
    private static final String BOOLEAN_TRUE_STR = "1";
    private static final String BOOLEAN_FALSE_STR = "0";
    private final Map<String, String> metadataMap;

    public FlightSqlColumnMetadata(Map<String, String> metadataMap) {
        this.metadataMap = new HashMap<String, String>(metadataMap);
    }

    public Map<String, String> getMetadataMap() {
        return Collections.unmodifiableMap(this.metadataMap);
    }

    public String getCatalogName() {
        return this.metadataMap.get(CATALOG_NAME);
    }

    public String getSchemaName() {
        return this.metadataMap.get(SCHEMA_NAME);
    }

    public String getTableName() {
        return this.metadataMap.get(TABLE_NAME);
    }

    public String getTypeName() {
        return this.metadataMap.get(TYPE_NAME);
    }

    public Integer getPrecision() {
        String value = this.metadataMap.get(PRECISION);
        if (value == null) {
            return null;
        }
        return Integer.valueOf(value);
    }

    public Integer getScale() {
        String value = this.metadataMap.get(SCALE);
        if (value == null) {
            return null;
        }
        return Integer.valueOf(value);
    }

    public Boolean isAutoIncrement() {
        String value = this.metadataMap.get(IS_AUTO_INCREMENT);
        if (value == null) {
            return null;
        }
        return FlightSqlColumnMetadata.stringToBoolean(value);
    }

    public Boolean isCaseSensitive() {
        String value = this.metadataMap.get(IS_CASE_SENSITIVE);
        if (value == null) {
            return null;
        }
        return FlightSqlColumnMetadata.stringToBoolean(value);
    }

    public Boolean isReadOnly() {
        String value = this.metadataMap.get(IS_READ_ONLY);
        if (value == null) {
            return null;
        }
        return FlightSqlColumnMetadata.stringToBoolean(value);
    }

    public Boolean isSearchable() {
        String value = this.metadataMap.get(IS_SEARCHABLE);
        if (value == null) {
            return null;
        }
        return FlightSqlColumnMetadata.stringToBoolean(value);
    }

    private static String booleanToString(boolean boolValue) {
        return boolValue ? BOOLEAN_TRUE_STR : BOOLEAN_FALSE_STR;
    }

    private static boolean stringToBoolean(String value) {
        return value.equals(BOOLEAN_TRUE_STR);
    }

    public static class Builder {
        private final Map<String, String> metadataMap = new HashMap<String, String>();

        public Builder catalogName(String catalogName) {
            this.metadataMap.put(FlightSqlColumnMetadata.CATALOG_NAME, catalogName);
            return this;
        }

        public Builder schemaName(String schemaName) {
            this.metadataMap.put(FlightSqlColumnMetadata.SCHEMA_NAME, schemaName);
            return this;
        }

        public Builder tableName(String tableName) {
            this.metadataMap.put(FlightSqlColumnMetadata.TABLE_NAME, tableName);
            return this;
        }

        public Builder typeName(String typeName) {
            this.metadataMap.put(FlightSqlColumnMetadata.TYPE_NAME, typeName);
            return this;
        }

        public Builder precision(int precision) {
            this.metadataMap.put(FlightSqlColumnMetadata.PRECISION, Integer.toString(precision));
            return this;
        }

        public Builder scale(int scale) {
            this.metadataMap.put(FlightSqlColumnMetadata.SCALE, Integer.toString(scale));
            return this;
        }

        public Builder isAutoIncrement(boolean isAutoIncrement) {
            this.metadataMap.put(FlightSqlColumnMetadata.IS_AUTO_INCREMENT, FlightSqlColumnMetadata.booleanToString(isAutoIncrement));
            return this;
        }

        public Builder isCaseSensitive(boolean isCaseSensitive) {
            this.metadataMap.put(FlightSqlColumnMetadata.IS_CASE_SENSITIVE, FlightSqlColumnMetadata.booleanToString(isCaseSensitive));
            return this;
        }

        public Builder isReadOnly(boolean isReadOnly) {
            this.metadataMap.put(FlightSqlColumnMetadata.IS_READ_ONLY, FlightSqlColumnMetadata.booleanToString(isReadOnly));
            return this;
        }

        public Builder isSearchable(boolean isSearchable) {
            this.metadataMap.put(FlightSqlColumnMetadata.IS_SEARCHABLE, FlightSqlColumnMetadata.booleanToString(isSearchable));
            return this;
        }

        public FlightSqlColumnMetadata build() {
            return new FlightSqlColumnMetadata(this.metadataMap);
        }
    }
}

