/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.sql;

import com.google.common.collect.ImmutableList;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.arrow.flight.Action;
import org.apache.arrow.flight.ActionType;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.PutResult;
import org.apache.arrow.flight.Result;
import org.apache.arrow.flight.SchemaResult;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.flight.sql.FlightSqlUtils;
import org.apache.arrow.flight.sql.impl.FlightSql;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.UnionMode;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;

public interface FlightSqlProducer
extends FlightProducer,
AutoCloseable {
    default public FlightInfo getFlightInfo(FlightProducer.CallContext context, FlightDescriptor descriptor) {
        Any command = FlightSqlUtils.parseOrThrow(descriptor.getCommand());
        if (command.is(FlightSql.CommandStatementQuery.class)) {
            return this.getFlightInfoStatement(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandStatementQuery.class), context, descriptor);
        }
        if (command.is(FlightSql.CommandPreparedStatementQuery.class)) {
            return this.getFlightInfoPreparedStatement(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandPreparedStatementQuery.class), context, descriptor);
        }
        if (command.is(FlightSql.CommandGetCatalogs.class)) {
            return this.getFlightInfoCatalogs(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetCatalogs.class), context, descriptor);
        }
        if (command.is(FlightSql.CommandGetDbSchemas.class)) {
            return this.getFlightInfoSchemas(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetDbSchemas.class), context, descriptor);
        }
        if (command.is(FlightSql.CommandGetTables.class)) {
            return this.getFlightInfoTables(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetTables.class), context, descriptor);
        }
        if (command.is(FlightSql.CommandGetTableTypes.class)) {
            return this.getFlightInfoTableTypes(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetTableTypes.class), context, descriptor);
        }
        if (command.is(FlightSql.CommandGetSqlInfo.class)) {
            return this.getFlightInfoSqlInfo(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetSqlInfo.class), context, descriptor);
        }
        if (command.is(FlightSql.CommandGetPrimaryKeys.class)) {
            return this.getFlightInfoPrimaryKeys(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetPrimaryKeys.class), context, descriptor);
        }
        if (command.is(FlightSql.CommandGetExportedKeys.class)) {
            return this.getFlightInfoExportedKeys(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetExportedKeys.class), context, descriptor);
        }
        if (command.is(FlightSql.CommandGetImportedKeys.class)) {
            return this.getFlightInfoImportedKeys(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetImportedKeys.class), context, descriptor);
        }
        if (command.is(FlightSql.CommandGetCrossReference.class)) {
            return this.getFlightInfoCrossReference(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetCrossReference.class), context, descriptor);
        }
        throw CallStatus.INVALID_ARGUMENT.withDescription("The defined request is invalid.").toRuntimeException();
    }

    default public SchemaResult getSchema(FlightProducer.CallContext context, FlightDescriptor descriptor) {
        Any command = FlightSqlUtils.parseOrThrow(descriptor.getCommand());
        if (command.is(FlightSql.CommandStatementQuery.class)) {
            return this.getSchemaStatement(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandStatementQuery.class), context, descriptor);
        }
        if (command.is(FlightSql.CommandGetCatalogs.class)) {
            return new SchemaResult(Schemas.GET_CATALOGS_SCHEMA);
        }
        if (command.is(FlightSql.CommandGetDbSchemas.class)) {
            return new SchemaResult(Schemas.GET_SCHEMAS_SCHEMA);
        }
        if (command.is(FlightSql.CommandGetTables.class)) {
            return new SchemaResult(Schemas.GET_TABLES_SCHEMA);
        }
        if (command.is(FlightSql.CommandGetTableTypes.class)) {
            return new SchemaResult(Schemas.GET_TABLE_TYPES_SCHEMA);
        }
        if (command.is(FlightSql.CommandGetSqlInfo.class)) {
            return new SchemaResult(Schemas.GET_SQL_INFO_SCHEMA);
        }
        if (command.is(FlightSql.CommandGetPrimaryKeys.class)) {
            return new SchemaResult(Schemas.GET_PRIMARY_KEYS_SCHEMA);
        }
        if (command.is(FlightSql.CommandGetImportedKeys.class)) {
            return new SchemaResult(Schemas.GET_IMPORTED_KEYS_SCHEMA);
        }
        if (command.is(FlightSql.CommandGetExportedKeys.class)) {
            return new SchemaResult(Schemas.GET_EXPORTED_KEYS_SCHEMA);
        }
        if (command.is(FlightSql.CommandGetCrossReference.class)) {
            return new SchemaResult(Schemas.GET_CROSS_REFERENCE_SCHEMA);
        }
        throw CallStatus.INVALID_ARGUMENT.withDescription("Invalid command provided.").toRuntimeException();
    }

    default public void getStream(FlightProducer.CallContext context, Ticket ticket, FlightProducer.ServerStreamListener listener) {
        Any command;
        try {
            command = Any.parseFrom((byte[])ticket.getBytes());
        }
        catch (InvalidProtocolBufferException e) {
            listener.error((Throwable)e);
            return;
        }
        if (command.is(FlightSql.TicketStatementQuery.class)) {
            this.getStreamStatement(FlightSqlUtils.unpackOrThrow(command, FlightSql.TicketStatementQuery.class), context, listener);
        } else if (command.is(FlightSql.CommandPreparedStatementQuery.class)) {
            this.getStreamPreparedStatement(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandPreparedStatementQuery.class), context, listener);
        } else if (command.is(FlightSql.CommandGetCatalogs.class)) {
            this.getStreamCatalogs(context, listener);
        } else if (command.is(FlightSql.CommandGetDbSchemas.class)) {
            this.getStreamSchemas(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetDbSchemas.class), context, listener);
        } else if (command.is(FlightSql.CommandGetTables.class)) {
            this.getStreamTables(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetTables.class), context, listener);
        } else if (command.is(FlightSql.CommandGetTableTypes.class)) {
            this.getStreamTableTypes(context, listener);
        } else if (command.is(FlightSql.CommandGetSqlInfo.class)) {
            this.getStreamSqlInfo(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetSqlInfo.class), context, listener);
        } else if (command.is(FlightSql.CommandGetPrimaryKeys.class)) {
            this.getStreamPrimaryKeys(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetPrimaryKeys.class), context, listener);
        } else if (command.is(FlightSql.CommandGetExportedKeys.class)) {
            this.getStreamExportedKeys(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetExportedKeys.class), context, listener);
        } else if (command.is(FlightSql.CommandGetImportedKeys.class)) {
            this.getStreamImportedKeys(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetImportedKeys.class), context, listener);
        } else if (command.is(FlightSql.CommandGetCrossReference.class)) {
            this.getStreamCrossReference(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetCrossReference.class), context, listener);
        } else {
            throw CallStatus.INVALID_ARGUMENT.withDescription("The defined request is invalid.").toRuntimeException();
        }
    }

    default public Runnable acceptPut(FlightProducer.CallContext context, FlightStream flightStream, FlightProducer.StreamListener<PutResult> ackStream) {
        Any command = FlightSqlUtils.parseOrThrow(flightStream.getDescriptor().getCommand());
        if (command.is(FlightSql.CommandStatementUpdate.class)) {
            return this.acceptPutStatement(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandStatementUpdate.class), context, flightStream, ackStream);
        }
        if (command.is(FlightSql.CommandPreparedStatementUpdate.class)) {
            return this.acceptPutPreparedStatementUpdate(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandPreparedStatementUpdate.class), context, flightStream, ackStream);
        }
        if (command.is(FlightSql.CommandPreparedStatementQuery.class)) {
            return this.acceptPutPreparedStatementQuery(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandPreparedStatementQuery.class), context, flightStream, ackStream);
        }
        throw CallStatus.INVALID_ARGUMENT.withDescription("The defined request is invalid.").toRuntimeException();
    }

    default public void listActions(FlightProducer.CallContext context, FlightProducer.StreamListener<ActionType> listener) {
        FlightSqlUtils.FLIGHT_SQL_ACTIONS.forEach(arg_0 -> listener.onNext(arg_0));
        listener.onCompleted();
    }

    default public void doAction(FlightProducer.CallContext context, Action action, FlightProducer.StreamListener<Result> listener) {
        String actionType = action.getType();
        if (actionType.equals(FlightSqlUtils.FLIGHT_SQL_CREATE_PREPARED_STATEMENT.getType())) {
            FlightSql.ActionCreatePreparedStatementRequest request = FlightSqlUtils.unpackAndParseOrThrow(action.getBody(), FlightSql.ActionCreatePreparedStatementRequest.class);
            this.createPreparedStatement(request, context, listener);
        } else if (actionType.equals(FlightSqlUtils.FLIGHT_SQL_CLOSE_PREPARED_STATEMENT.getType())) {
            FlightSql.ActionClosePreparedStatementRequest request = FlightSqlUtils.unpackAndParseOrThrow(action.getBody(), FlightSql.ActionClosePreparedStatementRequest.class);
            this.closePreparedStatement(request, context, listener);
        } else {
            throw CallStatus.INVALID_ARGUMENT.withDescription("Invalid action provided.").toRuntimeException();
        }
    }

    public void createPreparedStatement(FlightSql.ActionCreatePreparedStatementRequest var1, FlightProducer.CallContext var2, FlightProducer.StreamListener<Result> var3);

    public void closePreparedStatement(FlightSql.ActionClosePreparedStatementRequest var1, FlightProducer.CallContext var2, FlightProducer.StreamListener<Result> var3);

    public FlightInfo getFlightInfoStatement(FlightSql.CommandStatementQuery var1, FlightProducer.CallContext var2, FlightDescriptor var3);

    public FlightInfo getFlightInfoPreparedStatement(FlightSql.CommandPreparedStatementQuery var1, FlightProducer.CallContext var2, FlightDescriptor var3);

    public SchemaResult getSchemaStatement(FlightSql.CommandStatementQuery var1, FlightProducer.CallContext var2, FlightDescriptor var3);

    public void getStreamStatement(FlightSql.TicketStatementQuery var1, FlightProducer.CallContext var2, FlightProducer.ServerStreamListener var3);

    public void getStreamPreparedStatement(FlightSql.CommandPreparedStatementQuery var1, FlightProducer.CallContext var2, FlightProducer.ServerStreamListener var3);

    public Runnable acceptPutStatement(FlightSql.CommandStatementUpdate var1, FlightProducer.CallContext var2, FlightStream var3, FlightProducer.StreamListener<PutResult> var4);

    public Runnable acceptPutPreparedStatementUpdate(FlightSql.CommandPreparedStatementUpdate var1, FlightProducer.CallContext var2, FlightStream var3, FlightProducer.StreamListener<PutResult> var4);

    public Runnable acceptPutPreparedStatementQuery(FlightSql.CommandPreparedStatementQuery var1, FlightProducer.CallContext var2, FlightStream var3, FlightProducer.StreamListener<PutResult> var4);

    public FlightInfo getFlightInfoSqlInfo(FlightSql.CommandGetSqlInfo var1, FlightProducer.CallContext var2, FlightDescriptor var3);

    public void getStreamSqlInfo(FlightSql.CommandGetSqlInfo var1, FlightProducer.CallContext var2, FlightProducer.ServerStreamListener var3);

    public FlightInfo getFlightInfoCatalogs(FlightSql.CommandGetCatalogs var1, FlightProducer.CallContext var2, FlightDescriptor var3);

    public void getStreamCatalogs(FlightProducer.CallContext var1, FlightProducer.ServerStreamListener var2);

    public FlightInfo getFlightInfoSchemas(FlightSql.CommandGetDbSchemas var1, FlightProducer.CallContext var2, FlightDescriptor var3);

    public void getStreamSchemas(FlightSql.CommandGetDbSchemas var1, FlightProducer.CallContext var2, FlightProducer.ServerStreamListener var3);

    public FlightInfo getFlightInfoTables(FlightSql.CommandGetTables var1, FlightProducer.CallContext var2, FlightDescriptor var3);

    public void getStreamTables(FlightSql.CommandGetTables var1, FlightProducer.CallContext var2, FlightProducer.ServerStreamListener var3);

    public FlightInfo getFlightInfoTableTypes(FlightSql.CommandGetTableTypes var1, FlightProducer.CallContext var2, FlightDescriptor var3);

    public void getStreamTableTypes(FlightProducer.CallContext var1, FlightProducer.ServerStreamListener var2);

    public FlightInfo getFlightInfoPrimaryKeys(FlightSql.CommandGetPrimaryKeys var1, FlightProducer.CallContext var2, FlightDescriptor var3);

    public void getStreamPrimaryKeys(FlightSql.CommandGetPrimaryKeys var1, FlightProducer.CallContext var2, FlightProducer.ServerStreamListener var3);

    public FlightInfo getFlightInfoExportedKeys(FlightSql.CommandGetExportedKeys var1, FlightProducer.CallContext var2, FlightDescriptor var3);

    public FlightInfo getFlightInfoImportedKeys(FlightSql.CommandGetImportedKeys var1, FlightProducer.CallContext var2, FlightDescriptor var3);

    public FlightInfo getFlightInfoCrossReference(FlightSql.CommandGetCrossReference var1, FlightProducer.CallContext var2, FlightDescriptor var3);

    public void getStreamExportedKeys(FlightSql.CommandGetExportedKeys var1, FlightProducer.CallContext var2, FlightProducer.ServerStreamListener var3);

    public void getStreamImportedKeys(FlightSql.CommandGetImportedKeys var1, FlightProducer.CallContext var2, FlightProducer.ServerStreamListener var3);

    public void getStreamCrossReference(FlightSql.CommandGetCrossReference var1, FlightProducer.CallContext var2, FlightProducer.ServerStreamListener var3);

    public static final class Schemas {
        public static final Schema GET_TABLES_SCHEMA = new Schema(Arrays.asList(Field.nullable((String)"catalog_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.nullable((String)"db_schema_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"table_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"table_type", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"table_schema", (ArrowType)Types.MinorType.VARBINARY.getType())));
        public static final Schema GET_TABLES_SCHEMA_NO_SCHEMA = new Schema(Arrays.asList(Field.nullable((String)"catalog_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.nullable((String)"db_schema_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"table_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"table_type", (ArrowType)Types.MinorType.VARCHAR.getType())));
        public static final Schema GET_CATALOGS_SCHEMA = new Schema(Collections.singletonList(Field.notNullable((String)"catalog_name", (ArrowType)Types.MinorType.VARCHAR.getType())));
        public static final Schema GET_TABLE_TYPES_SCHEMA = new Schema(Collections.singletonList(Field.notNullable((String)"table_type", (ArrowType)Types.MinorType.VARCHAR.getType())));
        public static final Schema GET_SCHEMAS_SCHEMA = new Schema(Arrays.asList(Field.nullable((String)"catalog_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"db_schema_name", (ArrowType)Types.MinorType.VARCHAR.getType())));
        private static final Schema GET_IMPORTED_EXPORTED_AND_CROSS_REFERENCE_KEYS_SCHEMA;
        public static final Schema GET_IMPORTED_KEYS_SCHEMA;
        public static final Schema GET_EXPORTED_KEYS_SCHEMA;
        public static final Schema GET_CROSS_REFERENCE_SCHEMA;
        private static final List<Field> GET_SQL_INFO_DENSE_UNION_SCHEMA_FIELDS;
        public static final Schema GET_SQL_INFO_SCHEMA;
        public static final Schema GET_PRIMARY_KEYS_SCHEMA;

        private Schemas() {
        }

        static {
            GET_IMPORTED_KEYS_SCHEMA = GET_IMPORTED_EXPORTED_AND_CROSS_REFERENCE_KEYS_SCHEMA = new Schema(Arrays.asList(Field.nullable((String)"pk_catalog_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.nullable((String)"pk_db_schema_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"pk_table_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"pk_column_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.nullable((String)"fk_catalog_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.nullable((String)"fk_db_schema_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"fk_table_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"fk_column_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"key_sequence", (ArrowType)Types.MinorType.INT.getType()), Field.nullable((String)"fk_key_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.nullable((String)"pk_key_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"update_rule", (ArrowType)Types.MinorType.UINT1.getType()), Field.notNullable((String)"delete_rule", (ArrowType)Types.MinorType.UINT1.getType())));
            GET_EXPORTED_KEYS_SCHEMA = GET_IMPORTED_EXPORTED_AND_CROSS_REFERENCE_KEYS_SCHEMA;
            GET_CROSS_REFERENCE_SCHEMA = GET_IMPORTED_EXPORTED_AND_CROSS_REFERENCE_KEYS_SCHEMA;
            GET_SQL_INFO_DENSE_UNION_SCHEMA_FIELDS = Arrays.asList(Field.notNullable((String)"string_value", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"bool_value", (ArrowType)Types.MinorType.BIT.getType()), Field.notNullable((String)"bigint_value", (ArrowType)Types.MinorType.BIGINT.getType()), Field.notNullable((String)"int32_bitmask", (ArrowType)Types.MinorType.INT.getType()), new Field("string_list", FieldType.notNullable((ArrowType)Types.MinorType.LIST.getType()), Collections.singletonList(Field.nullable((String)"item", (ArrowType)Types.MinorType.VARCHAR.getType()))), new Field("int32_to_int32_list_map", FieldType.notNullable((ArrowType)new ArrowType.Map(false)), Collections.singletonList(new Field("entries", new FieldType(false, Types.MinorType.STRUCT.getType(), null), (List)ImmutableList.of((Object)Field.notNullable((String)"key", (ArrowType)Types.MinorType.INT.getType()), (Object)new Field("value", FieldType.nullable((ArrowType)Types.MinorType.LIST.getType()), Collections.singletonList(Field.nullable((String)"item", (ArrowType)Types.MinorType.INT.getType()))))))));
            GET_SQL_INFO_SCHEMA = new Schema(Arrays.asList(Field.notNullable((String)"info_name", (ArrowType)Types.MinorType.UINT4.getType()), new Field("value", FieldType.notNullable((ArrowType)new ArrowType.Union(UnionMode.Dense, IntStream.range(0, GET_SQL_INFO_DENSE_UNION_SCHEMA_FIELDS.size()).toArray())), GET_SQL_INFO_DENSE_UNION_SCHEMA_FIELDS)));
            GET_PRIMARY_KEYS_SCHEMA = new Schema(Arrays.asList(Field.nullable((String)"catalog_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.nullable((String)"db_schema_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"table_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"column_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"key_sequence", (ArrowType)Types.MinorType.INT.getType()), Field.nullable((String)"key_name", (ArrowType)Types.MinorType.VARCHAR.getType())));
        }
    }
}

