/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.digests;

import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.Xof;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.digests.AsconBaseDigest;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.util.Pack;

public class AsconXof128
extends AsconBaseDigest
implements Xof {
    private boolean m_squeezing = false;

    public AsconXof128() {
        this.reset();
    }

    @Override
    protected long pad(int n) {
        return 1L << (n << 3);
    }

    @Override
    protected long loadBytes(byte[] byArray, int n) {
        return Pack.littleEndianToLong(byArray, n);
    }

    @Override
    protected long loadBytes(byte[] byArray, int n, int n2) {
        return Pack.littleEndianToLong(byArray, n, n2);
    }

    @Override
    protected void setBytes(long l, byte[] byArray, int n) {
        Pack.longToLittleEndian(l, byArray, n);
    }

    @Override
    protected void setBytes(long l, byte[] byArray, int n, int n2) {
        Pack.longToLittleEndian(l, byArray, n, n2);
    }

    @Override
    protected void padAndAbsorb() {
        this.m_squeezing = true;
        super.padAndAbsorb();
    }

    @Override
    public String getAlgorithmName() {
        return "Ascon-XOF-128";
    }

    @Override
    public void update(byte by) {
        if (this.m_squeezing) {
            throw new IllegalArgumentException("attempt to absorb while squeezing");
        }
        super.update(by);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        if (this.m_squeezing) {
            throw new IllegalArgumentException("attempt to absorb while squeezing");
        }
        super.update(byArray, n, n2);
    }

    @Override
    public int doOutput(byte[] byArray, int n, int n2) {
        return this.hash(byArray, n, n2);
    }

    @Override
    public int doFinal(byte[] byArray, int n, int n2) {
        int n3 = this.doOutput(byArray, n, n2);
        this.reset();
        return n3;
    }

    @Override
    public int getByteLength() {
        return 8;
    }

    @Override
    public void reset() {
        this.m_squeezing = false;
        super.reset();
        this.x0 = -2701369817892108309L;
        this.x1 = -3711838248891385495L;
        this.x2 = -1778763697082575311L;
        this.x3 = 1072114354614917324L;
        this.x4 = -2282070310009238562L;
    }
}

