/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.io.entity;

import java.io.IOException;
import java.io.InputStream;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.core5.annotation.Contract;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.ContentType;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.core5.http.io.entity.AbstractHttpEntity;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.core5.io.Closer;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.shaded.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class BasicHttpEntity
extends AbstractHttpEntity {
    private final InputStream content;
    private final long length;

    public BasicHttpEntity(InputStream content, long contentLength, ContentType contentType, String contentEncoding, boolean chunked) {
        super(contentType, contentEncoding, chunked);
        this.content = Args.notNull(content, "Content stream");
        this.length = contentLength;
    }

    public BasicHttpEntity(InputStream content, long contentLength, ContentType contentType, String contentEncoding) {
        this(content, contentLength, contentType, contentEncoding, false);
    }

    public BasicHttpEntity(InputStream content, long contentLength, ContentType contentType) {
        this(content, contentLength, contentType, null);
    }

    public BasicHttpEntity(InputStream content, ContentType contentType, String contentEncoding) {
        this(content, -1L, contentType, contentEncoding);
    }

    public BasicHttpEntity(InputStream content, ContentType contentType) {
        this(content, -1L, contentType, null);
    }

    public BasicHttpEntity(InputStream content, ContentType contentType, boolean chunked) {
        this(content, -1L, contentType, null, chunked);
    }

    @Override
    public final long getContentLength() {
        return this.length;
    }

    @Override
    public final InputStream getContent() throws IllegalStateException {
        return this.content;
    }

    @Override
    public final boolean isRepeatable() {
        return false;
    }

    @Override
    public final boolean isStreaming() {
        return true;
    }

    @Override
    public final void close() throws IOException {
        Closer.close(this.content);
    }
}

